/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.cli.common.messages;

import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.containers.ContainerUtil;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OutputMessageUtil {
    public static String formatOutputMessage(Collection<File> sourceFiles, File outputFile) {
        return "Output:\n" + outputFile.getPath() + "\n" + "Sources:" + "\n" + StringUtil.join(sourceFiles, "\n");
    }

    @Nullable
    public static Output parseOutputMessage(@NotNull String message) {
        if (message == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/jet/cli/common/messages/OutputMessageUtil", "parseOutputMessage"));
        }
        String[] strings = message.split("\n");
        if (strings.length <= 2) {
            return null;
        }
        if (!"Output:".equals(strings[0])) {
            return null;
        }
        if ("Sources:".equals(strings[1])) {
            return new Output(OutputMessageUtil.parseSourceFiles(strings, 2), null);
        }
        File outputFile = new File(strings[1]);
        if (!"Sources:".equals(strings[2])) {
            return null;
        }
        return new Output(OutputMessageUtil.parseSourceFiles(strings, 3), outputFile);
    }

    private static Collection<File> parseSourceFiles(String[] strings, int start) {
        ArrayList<File> sourceFiles = ContainerUtil.newArrayList();
        for (int i = start; i < strings.length; ++i) {
            sourceFiles.add(new File(strings[i]));
        }
        return sourceFiles;
    }

    public static class Output {
        @NotNull
        public final Collection<File> sourceFiles;
        @Nullable
        public final File outputFile;

        public Output(@NotNull Collection<File> sourceFiles, @Nullable File outputFile) {
            if (sourceFiles == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/jet/cli/common/messages/OutputMessageUtil$Output", "<init>"));
            }
            this.sourceFiles = sourceFiles;
            this.outputFile = outputFile;
        }
    }
}

