/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.codegen;

import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.asm4.MethodVisitor;
import org.jetbrains.asm4.Type;
import org.jetbrains.asm4.commons.InstructionAdapter;
import org.jetbrains.jet.codegen.ClassBuilder;
import org.jetbrains.jet.codegen.ExpressionCodegen;
import org.jetbrains.jet.codegen.FrameMap;
import org.jetbrains.jet.codegen.ImplementationBodyCodegen;
import org.jetbrains.jet.codegen.MemberCodegen;
import org.jetbrains.jet.codegen.StackValue;
import org.jetbrains.jet.codegen.binding.CodegenBinding;
import org.jetbrains.jet.codegen.context.CodegenContext;
import org.jetbrains.jet.codegen.context.FieldOwnerContext;
import org.jetbrains.jet.codegen.context.MethodContext;
import org.jetbrains.jet.codegen.context.ScriptContext;
import org.jetbrains.jet.codegen.signature.JvmMethodSignature;
import org.jetbrains.jet.codegen.state.GenerationState;
import org.jetbrains.jet.lang.descriptors.ClassDescriptor;
import org.jetbrains.jet.lang.descriptors.ScriptDescriptor;
import org.jetbrains.jet.lang.descriptors.ValueParameterDescriptor;
import org.jetbrains.jet.lang.psi.JetDeclaration;
import org.jetbrains.jet.lang.psi.JetScript;
import org.jetbrains.jet.lang.psi.JetTypeParameterListOwner;
import org.jetbrains.jet.lang.resolve.BindingContext;
import org.jetbrains.jet.lang.resolve.java.AsmTypeConstants;

public class ScriptCodegen
extends MemberCodegen {
    @NotNull
    private JetScript scriptDeclaration;
    @NotNull
    private final ScriptContext context;
    @NotNull
    private List<ScriptDescriptor> earlierScripts;

    public static ScriptCodegen createScriptCodegen(@NotNull JetScript declaration, @NotNull GenerationState state, @NotNull CodegenContext parentContext) {
        if (declaration == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/jet/codegen/ScriptCodegen", "createScriptCodegen"));
        }
        if (state == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "org/jetbrains/jet/codegen/ScriptCodegen", "createScriptCodegen"));
        }
        if (parentContext == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "org/jetbrains/jet/codegen/ScriptCodegen", "createScriptCodegen"));
        }
        ScriptDescriptor scriptDescriptor = state.getBindingContext().get(BindingContext.SCRIPT, declaration);
        assert (scriptDescriptor != null);
        ClassDescriptor classDescriptorForScript = state.getBindingContext().get(CodegenBinding.CLASS_FOR_SCRIPT, scriptDescriptor);
        assert (classDescriptorForScript != null);
        ScriptContext scriptContext = parentContext.intoScript(scriptDescriptor, classDescriptorForScript);
        return new ScriptCodegen(declaration, state, scriptContext, state.getEarlierScriptsForReplInterpreter());
    }

    private ScriptCodegen(@NotNull JetScript scriptDeclaration, @NotNull GenerationState state, @NotNull ScriptContext context, @Nullable List<ScriptDescriptor> earlierScripts) {
        if (scriptDeclaration == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/jet/codegen/ScriptCodegen", "<init>"));
        }
        if (state == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "org/jetbrains/jet/codegen/ScriptCodegen", "<init>"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "org/jetbrains/jet/codegen/ScriptCodegen", "<init>"));
        }
        super(state, null);
        this.scriptDeclaration = scriptDeclaration;
        this.context = context;
        this.earlierScripts = earlierScripts == null ? Collections.emptyList() : earlierScripts;
    }

    public void generate() {
        ScriptDescriptor scriptDescriptor = this.context.getScriptDescriptor();
        ClassDescriptor classDescriptorForScript = (ClassDescriptor)this.context.getContextDescriptor();
        Type classType = this.bindingContext.get(CodegenBinding.ASM_TYPE, classDescriptorForScript);
        assert (classType != null);
        ClassBuilder classBuilder = this.state.getFactory().newVisitor(classType, this.scriptDeclaration.getContainingFile());
        classBuilder.defineClass(this.scriptDeclaration, 50, 1, classType.getInternalName(), null, "java/lang/Object", new String[0]);
        this.genMembers(this.context, classBuilder);
        this.genFieldsForParameters(scriptDescriptor, classBuilder);
        this.genConstructor(scriptDescriptor, classDescriptorForScript, classBuilder, this.context.intoFunction(scriptDescriptor.getScriptCodeDescriptor()));
        classBuilder.done();
    }

    private void genConstructor(@NotNull ScriptDescriptor scriptDescriptor, @NotNull ClassDescriptor classDescriptorForScript, @NotNull ClassBuilder classBuilder, @NotNull MethodContext context) {
        if (scriptDescriptor == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/jet/codegen/ScriptCodegen", "genConstructor"));
        }
        if (classDescriptorForScript == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "org/jetbrains/jet/codegen/ScriptCodegen", "genConstructor"));
        }
        if (classBuilder == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "org/jetbrains/jet/codegen/ScriptCodegen", "genConstructor"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "3", "org/jetbrains/jet/codegen/ScriptCodegen", "genConstructor"));
        }
        Type blockType = this.typeMapper.mapType(scriptDescriptor.getReturnType());
        classBuilder.newField(null, 17, "rv", blockType.getDescriptor(), null, null);
        JvmMethodSignature jvmSignature = this.typeMapper.mapScriptSignature(scriptDescriptor, this.earlierScripts);
        MethodVisitor mv = classBuilder.newMethod(this.scriptDeclaration, 1, jvmSignature.getAsmMethod().getName(), jvmSignature.getAsmMethod().getDescriptor(), null, null);
        mv.visitCode();
        InstructionAdapter instructionAdapter = new InstructionAdapter(mv);
        Type classType = this.bindingContext.get(CodegenBinding.ASM_TYPE, classDescriptorForScript);
        assert (classType != null);
        instructionAdapter.load(0, classType);
        instructionAdapter.invokespecial("java/lang/Object", "<init>", "()V");
        instructionAdapter.load(0, classType);
        FrameMap frameMap = context.prepareFrame(this.typeMapper);
        for (ScriptDescriptor importedScript : this.earlierScripts) {
            frameMap.enter(importedScript, AsmTypeConstants.OBJECT_TYPE);
        }
        Type[] argTypes = jvmSignature.getAsmMethod().getArgumentTypes();
        int add = 0;
        for (int i = 0; i < scriptDescriptor.getValueParameters().size(); ++i) {
            ValueParameterDescriptor parameter = scriptDescriptor.getValueParameters().get(i);
            frameMap.enter(parameter, argTypes[i + add]);
        }
        ImplementationBodyCodegen.generateInitializers(new ExpressionCodegen(instructionAdapter, frameMap, Type.VOID_TYPE, context, this.state, this), this.scriptDeclaration.getDeclarations(), this.bindingContext, this.state);
        int offset = 1;
        for (ScriptDescriptor earlierScript : this.earlierScripts) {
            Type earlierClassType = CodegenBinding.asmTypeForScriptDescriptor(this.bindingContext, earlierScript);
            instructionAdapter.load(0, classType);
            instructionAdapter.load(offset, earlierClassType);
            offset += earlierClassType.getSize();
            instructionAdapter.putfield(classType.getInternalName(), this.getScriptFieldName(earlierScript), earlierClassType.getDescriptor());
        }
        for (ValueParameterDescriptor parameter : scriptDescriptor.getValueParameters()) {
            Type parameterType = this.typeMapper.mapType(parameter.getType());
            instructionAdapter.load(0, classType);
            instructionAdapter.load(offset, parameterType);
            offset += parameterType.getSize();
            instructionAdapter.putfield(classType.getInternalName(), parameter.getName().getIdentifier(), parameterType.getDescriptor());
        }
        StackValue stackValue = new ExpressionCodegen(mv, frameMap, Type.VOID_TYPE, context, this.state, this).gen(this.scriptDeclaration.getBlockExpression());
        if (stackValue.type != Type.VOID_TYPE) {
            stackValue.put(stackValue.type, instructionAdapter);
            instructionAdapter.putfield(classType.getInternalName(), "rv", blockType.getDescriptor());
        }
        instructionAdapter.areturn(Type.VOID_TYPE);
        mv.visitMaxs(-1, -1);
        mv.visitEnd();
    }

    private void genFieldsForParameters(@NotNull ScriptDescriptor script, @NotNull ClassBuilder classBuilder) {
        int access;
        if (script == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/jet/codegen/ScriptCodegen", "genFieldsForParameters"));
        }
        if (classBuilder == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "org/jetbrains/jet/codegen/ScriptCodegen", "genFieldsForParameters"));
        }
        for (ScriptDescriptor earlierScript : this.earlierScripts) {
            Type earlierClassName = CodegenBinding.asmTypeForScriptDescriptor(this.bindingContext, earlierScript);
            access = 18;
            classBuilder.newField(null, access, this.getScriptFieldName(earlierScript), earlierClassName.getDescriptor(), null, null);
        }
        for (ValueParameterDescriptor parameter : script.getValueParameters()) {
            Type parameterType = this.typeMapper.mapType(parameter);
            access = 17;
            classBuilder.newField(null, access, parameter.getName().getIdentifier(), parameterType.getDescriptor(), null, null);
        }
    }

    private void genMembers(@NotNull FieldOwnerContext context, @NotNull ClassBuilder classBuilder) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/jet/codegen/ScriptCodegen", "genMembers"));
        }
        if (classBuilder == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "org/jetbrains/jet/codegen/ScriptCodegen", "genMembers"));
        }
        for (JetDeclaration decl : this.scriptDeclaration.getDeclarations()) {
            this.genFunctionOrProperty(context, (JetTypeParameterListOwner)decl, classBuilder);
        }
    }

    private int getScriptIndex(@NotNull ScriptDescriptor scriptDescriptor) {
        if (scriptDescriptor == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/jet/codegen/ScriptCodegen", "getScriptIndex"));
        }
        int index = this.earlierScripts.indexOf(scriptDescriptor);
        if (index < 0) {
            throw new IllegalStateException("Unregistered script: " + scriptDescriptor);
        }
        return index + 1;
    }

    public String getScriptFieldName(@NotNull ScriptDescriptor scriptDescriptor) {
        if (scriptDescriptor == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/jet/codegen/ScriptCodegen", "getScriptFieldName"));
        }
        return "script$" + this.getScriptIndex(scriptDescriptor);
    }
}

