/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.codegen.signature;

import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.asm4.Type;
import org.jetbrains.asm4.commons.Method;
import org.jetbrains.jet.codegen.signature.JvmMethodParameterKind;
import org.jetbrains.jet.codegen.signature.JvmMethodParameterSignature;

public class JvmMethodSignature {
    @NotNull
    private final Method asmMethod;
    private final String genericsSignature;
    @NotNull
    private final List<JvmMethodParameterSignature> kotlinParameterTypes;

    protected JvmMethodSignature(@NotNull Method asmMethod, @Nullable String genericsSignature, @NotNull List<JvmMethodParameterSignature> kotlinParameterTypes) {
        if (asmMethod == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/jet/codegen/signature/JvmMethodSignature", "<init>"));
        }
        if (kotlinParameterTypes == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "org/jetbrains/jet/codegen/signature/JvmMethodSignature", "<init>"));
        }
        this.asmMethod = asmMethod;
        this.genericsSignature = genericsSignature;
        this.kotlinParameterTypes = kotlinParameterTypes;
    }

    @NotNull
    public Method getAsmMethod() {
        Method method = this.asmMethod;
        if (method == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/codegen/signature/JvmMethodSignature", "getAsmMethod"));
        }
        return method;
    }

    public String getGenericsSignature() {
        return this.genericsSignature;
    }

    @NotNull
    public List<JvmMethodParameterSignature> getKotlinParameterTypes() {
        List<JvmMethodParameterSignature> list2 = this.kotlinParameterTypes;
        if (list2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/codegen/signature/JvmMethodSignature", "getKotlinParameterTypes"));
        }
        return list2;
    }

    public List<Type> getValueParameterTypes() {
        ArrayList<Type> r = new ArrayList<Type>(this.kotlinParameterTypes.size());
        for (JvmMethodParameterSignature p : this.kotlinParameterTypes) {
            if (p.getKind() != JvmMethodParameterKind.VALUE) continue;
            r.add(p.getAsmType());
        }
        return r;
    }

    @NotNull
    public String getName() {
        String string = this.asmMethod.getName();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/codegen/signature/JvmMethodSignature", "getName"));
        }
        return string;
    }

    public String toString() {
        return this.asmMethod.toString();
    }
}

