/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.descriptors.serialization;

import gnu.trove.TObjectHashingStrategy;
import gnu.trove.TObjectIntHashMap;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class Interner<T> {
    private final Interner<T> parent;
    private final int firstIndex;
    private final TObjectIntHashMap<T> interned;
    private final List<T> all;

    public Interner(Interner<T> parent, @NotNull TObjectHashingStrategy<T> hashing) {
        if (hashing == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "org/jetbrains/jet/descriptors/serialization/Interner", "<init>"));
        }
        this.all = new ArrayList<T>();
        this.parent = parent;
        this.firstIndex = parent == null ? 0 : parent.all.size();
        this.interned = new TObjectIntHashMap<T>(hashing);
    }

    public Interner(@NotNull TObjectHashingStrategy<T> hashing) {
        if (hashing == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/jet/descriptors/serialization/Interner", "<init>"));
        }
        this(null, hashing);
    }

    public Interner(@Nullable Interner<T> parent) {
        this(parent, TObjectHashingStrategy.CANONICAL);
    }

    public Interner() {
        this((Interner)null);
    }

    public int intern(@NotNull T obj) {
        if (obj == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/jet/descriptors/serialization/Interner", "intern"));
        }
        assert (this.parent == null || this.parent.all.size() == this.firstIndex) : "Parent changed in parallel with child: indexes will be wrong";
        if (this.parent != null && this.parent.interned.contains(obj)) {
            return this.parent.intern(obj);
        }
        if (this.interned.contains(obj)) {
            return this.interned.get(obj);
        }
        int index = this.firstIndex + this.interned.size();
        this.interned.put(obj, index);
        this.all.add(obj);
        return index;
    }

    public List<T> getAllInternedObjects() {
        return this.all;
    }
}

