/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.descriptors.serialization;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jet.descriptors.serialization.NameResolver;
import org.jetbrains.jet.descriptors.serialization.NameTable;
import org.jetbrains.jet.descriptors.serialization.ProtoBuf;
import org.jetbrains.jet.utils.ExceptionUtils;

public class NameSerializationUtil {
    private NameSerializationUtil() {
    }

    @NotNull
    public static NameResolver deserializeNameResolver(@NotNull InputStream in) {
        NameResolver nameResolver;
        block3: {
            if (in == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/jet/descriptors/serialization/NameSerializationUtil", "deserializeNameResolver"));
            }
            try {
                ProtoBuf.SimpleNameTable simpleNames = ProtoBuf.SimpleNameTable.parseDelimitedFrom(in);
                ProtoBuf.QualifiedNameTable qualifiedNames = ProtoBuf.QualifiedNameTable.parseDelimitedFrom(in);
                nameResolver = new NameResolver(simpleNames, qualifiedNames);
                if (nameResolver != null) break block3;
            }
            catch (IOException e) {
                throw ExceptionUtils.rethrow(e);
            }
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/descriptors/serialization/NameSerializationUtil", "deserializeNameResolver"));
        }
        return nameResolver;
    }

    public static void serializeNameResolver(@NotNull OutputStream out, @NotNull NameResolver nameResolver) {
        if (out == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/jet/descriptors/serialization/NameSerializationUtil", "serializeNameResolver"));
        }
        if (nameResolver == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "org/jetbrains/jet/descriptors/serialization/NameSerializationUtil", "serializeNameResolver"));
        }
        NameSerializationUtil.serializeNameTable(out, nameResolver.getSimpleNameTable(), nameResolver.getQualifiedNameTable());
    }

    public static void serializeNameTable(@NotNull OutputStream out, @NotNull NameTable nameTable) {
        if (out == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/jet/descriptors/serialization/NameSerializationUtil", "serializeNameTable"));
        }
        if (nameTable == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "org/jetbrains/jet/descriptors/serialization/NameSerializationUtil", "serializeNameTable"));
        }
        NameSerializationUtil.serializeNameTable(out, NameSerializationUtil.toSimpleNameTable(nameTable), NameSerializationUtil.toQualifiedNameTable(nameTable));
    }

    private static void serializeNameTable(@NotNull OutputStream out, @NotNull ProtoBuf.SimpleNameTable simpleNameTable, @NotNull ProtoBuf.QualifiedNameTable qualifiedNameTable) {
        if (out == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/jet/descriptors/serialization/NameSerializationUtil", "serializeNameTable"));
        }
        if (simpleNameTable == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "org/jetbrains/jet/descriptors/serialization/NameSerializationUtil", "serializeNameTable"));
        }
        if (qualifiedNameTable == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "org/jetbrains/jet/descriptors/serialization/NameSerializationUtil", "serializeNameTable"));
        }
        try {
            simpleNameTable.writeDelimitedTo(out);
            qualifiedNameTable.writeDelimitedTo(out);
        }
        catch (IOException e) {
            throw ExceptionUtils.rethrow(e);
        }
    }

    @NotNull
    public static ProtoBuf.SimpleNameTable toSimpleNameTable(@NotNull NameTable nameTable) {
        if (nameTable == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/jet/descriptors/serialization/NameSerializationUtil", "toSimpleNameTable"));
        }
        ProtoBuf.SimpleNameTable.Builder simpleNames = ProtoBuf.SimpleNameTable.newBuilder();
        for (String simpleName : nameTable.getSimpleNames()) {
            simpleNames.addName(simpleName);
        }
        ProtoBuf.SimpleNameTable simpleNameTable = simpleNames.build();
        if (simpleNameTable == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/descriptors/serialization/NameSerializationUtil", "toSimpleNameTable"));
        }
        return simpleNameTable;
    }

    @NotNull
    public static ProtoBuf.QualifiedNameTable toQualifiedNameTable(@NotNull NameTable nameTable) {
        if (nameTable == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/jet/descriptors/serialization/NameSerializationUtil", "toQualifiedNameTable"));
        }
        ProtoBuf.QualifiedNameTable.Builder qualifiedNames = ProtoBuf.QualifiedNameTable.newBuilder();
        for (ProtoBuf.QualifiedNameTable.QualifiedName.Builder qName : nameTable.getFqNames()) {
            qualifiedNames.addQualifiedName(qName);
        }
        ProtoBuf.QualifiedNameTable qualifiedNameTable = qualifiedNames.build();
        if (qualifiedNameTable == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/descriptors/serialization/NameSerializationUtil", "toQualifiedNameTable"));
        }
        return qualifiedNameTable;
    }

    @NotNull
    public static NameResolver createNameResolver(@NotNull NameTable table) {
        if (table == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/jet/descriptors/serialization/NameSerializationUtil", "createNameResolver"));
        }
        NameResolver nameResolver = new NameResolver(NameSerializationUtil.toSimpleNameTable(table), NameSerializationUtil.toQualifiedNameTable(table));
        if (nameResolver == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/descriptors/serialization/NameSerializationUtil", "createNameResolver"));
        }
        return nameResolver;
    }
}

