/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.lang.diagnostics;

import com.google.common.collect.Lists;
import com.intellij.lang.ASTNode;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jet.lang.descriptors.DeclarationDescriptor;
import org.jetbrains.jet.lang.diagnostics.Diagnostic;
import org.jetbrains.jet.lang.psi.JetExpression;
import org.jetbrains.jet.lang.resolve.BindingContext;
import org.jetbrains.jet.lang.resolve.BindingContextUtils;

public class DiagnosticUtils {
    @NotNull
    private static final Comparator<TextRange> TEXT_RANGE_COMPARATOR = new Comparator<TextRange>(){

        @Override
        public int compare(TextRange o1, TextRange o2) {
            if (o1.getStartOffset() != o2.getStartOffset()) {
                return o1.getStartOffset() - o2.getStartOffset();
            }
            return o1.getEndOffset() - o2.getEndOffset();
        }
    };

    private DiagnosticUtils() {
    }

    public static String atLocation(BindingContext bindingContext, DeclarationDescriptor descriptor) {
        PsiElement element = BindingContextUtils.descriptorToDeclaration(bindingContext, descriptor);
        if (element == null) {
            element = BindingContextUtils.descriptorToDeclaration(bindingContext, descriptor.getOriginal());
        }
        if (element == null && descriptor instanceof ASTNode) {
            element = DiagnosticUtils.getClosestPsiElement((ASTNode)((Object)descriptor));
        }
        if (element != null) {
            return DiagnosticUtils.atLocation(element);
        }
        return "unknown location";
    }

    public static String atLocation(JetExpression expression) {
        return DiagnosticUtils.atLocation(expression.getNode());
    }

    public static String atLocation(@NotNull PsiElement element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/jet/lang/diagnostics/DiagnosticUtils", "atLocation"));
        }
        return DiagnosticUtils.atLocation(element.getNode());
    }

    public static String atLocation(@NotNull ASTNode node) {
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/jet/lang/diagnostics/DiagnosticUtils", "atLocation"));
        }
        int startOffset = node.getStartOffset();
        PsiElement element = DiagnosticUtils.getClosestPsiElement(node);
        if (element != null && element.isValid()) {
            return DiagnosticUtils.atLocation(element.getContainingFile(), element.getTextRange());
        }
        return "' at offset " + startOffset + " (line and file unknown: no PSI element)";
    }

    @Nullable
    public static PsiElement getClosestPsiElement(@NotNull ASTNode node) {
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/jet/lang/diagnostics/DiagnosticUtils", "getClosestPsiElement"));
        }
        while (node.getPsi() == null) {
            node = node.getTreeParent();
        }
        return node.getPsi();
    }

    @NotNull
    public static PsiFile getContainingFile(@NotNull ASTNode node) {
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/jet/lang/diagnostics/DiagnosticUtils", "getContainingFile"));
        }
        PsiElement closestPsiElement = DiagnosticUtils.getClosestPsiElement(node);
        assert (closestPsiElement != null) : "This node is not contained by a file";
        PsiFile psiFile = closestPsiElement.getContainingFile();
        if (psiFile == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/diagnostics/DiagnosticUtils", "getContainingFile"));
        }
        return psiFile;
    }

    @NotNull
    public static String atLocation(@NotNull PsiFile file, @NotNull TextRange textRange) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/jet/lang/diagnostics/DiagnosticUtils", "atLocation"));
        }
        if (textRange == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "org/jetbrains/jet/lang/diagnostics/DiagnosticUtils", "atLocation"));
        }
        Document document = file.getViewProvider().getDocument();
        String string = DiagnosticUtils.atLocation(file, textRange, document);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/diagnostics/DiagnosticUtils", "atLocation"));
        }
        return string;
    }

    @NotNull
    public static String atLocation(PsiFile file, TextRange textRange, Document document) {
        int offset = textRange.getStartOffset();
        VirtualFile virtualFile = file.getVirtualFile();
        String pathSuffix = " in " + (virtualFile == null ? file.getName() : virtualFile.getPath());
        String string = DiagnosticUtils.offsetToLineAndColumn(document, offset).toString() + pathSuffix;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/diagnostics/DiagnosticUtils", "atLocation"));
        }
        return string;
    }

    @NotNull
    public static LineAndColumn getLineAndColumn(@NotNull Diagnostic diagnostic) {
        if (diagnostic == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/jet/lang/diagnostics/DiagnosticUtils", "getLineAndColumn"));
        }
        PsiFile file = diagnostic.getPsiFile();
        List<TextRange> textRanges = diagnostic.getTextRanges();
        if (textRanges.isEmpty()) {
            LineAndColumn lineAndColumn = LineAndColumn.NONE;
            if (lineAndColumn == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/diagnostics/DiagnosticUtils", "getLineAndColumn"));
            }
            return lineAndColumn;
        }
        TextRange firstRange = DiagnosticUtils.firstRange(textRanges);
        LineAndColumn lineAndColumn = DiagnosticUtils.getLineAndColumnInPsiFile(file, firstRange);
        if (lineAndColumn == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/diagnostics/DiagnosticUtils", "getLineAndColumn"));
        }
        return lineAndColumn;
    }

    @NotNull
    public static LineAndColumn getLineAndColumnInPsiFile(PsiFile file, TextRange range) {
        Document document = file.getViewProvider().getDocument();
        LineAndColumn lineAndColumn = DiagnosticUtils.offsetToLineAndColumn(document, range.getStartOffset());
        if (lineAndColumn == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/diagnostics/DiagnosticUtils", "getLineAndColumnInPsiFile"));
        }
        return lineAndColumn;
    }

    @NotNull
    public static LineAndColumn offsetToLineAndColumn(Document document, int offset) {
        if (document == null) {
            LineAndColumn lineAndColumn = new LineAndColumn(-1, offset);
            if (lineAndColumn == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/diagnostics/DiagnosticUtils", "offsetToLineAndColumn"));
            }
            return lineAndColumn;
        }
        int lineNumber = document.getLineNumber(offset);
        int lineStartOffset = document.getLineStartOffset(lineNumber);
        int column = offset - lineStartOffset;
        LineAndColumn lineAndColumn = new LineAndColumn(lineNumber + 1, column + 1);
        if (lineAndColumn == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/diagnostics/DiagnosticUtils", "offsetToLineAndColumn"));
        }
        return lineAndColumn;
    }

    public static void throwIfRunningOnServer(Throwable e) {
        if (System.getProperty("kotlin.running.in.server.mode", "false").equals("true") || ApplicationManager.getApplication().isUnitTestMode()) {
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            if (e instanceof Error) {
                throw (Error)e;
            }
            throw new RuntimeException(e);
        }
    }

    @NotNull
    private static TextRange firstRange(@NotNull List<TextRange> ranges) {
        if (ranges == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/jet/lang/diagnostics/DiagnosticUtils", "firstRange"));
        }
        TextRange textRange = Collections.min(ranges, TEXT_RANGE_COMPARATOR);
        if (textRange == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/diagnostics/DiagnosticUtils", "firstRange"));
        }
        return textRange;
    }

    @NotNull
    public static List<Diagnostic> sortedDiagnostics(@NotNull Collection<Diagnostic> diagnostics) {
        if (diagnostics == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/jet/lang/diagnostics/DiagnosticUtils", "sortedDiagnostics"));
        }
        Comparator<Diagnostic> diagnosticComparator = new Comparator<Diagnostic>(){

            @Override
            public int compare(Diagnostic d1, Diagnostic d2) {
                TextRange range2;
                String path2;
                String path1 = d1.getPsiFile().getViewProvider().getVirtualFile().getPath();
                if (!path1.equals(path2 = d2.getPsiFile().getViewProvider().getVirtualFile().getPath())) {
                    return path1.compareTo(path2);
                }
                TextRange range1 = DiagnosticUtils.firstRange(d1.getTextRanges());
                if (!range1.equals(range2 = DiagnosticUtils.firstRange(d2.getTextRanges()))) {
                    return TEXT_RANGE_COMPARATOR.compare(range1, range2);
                }
                return d1.getFactory().getName().compareTo(d2.getFactory().getName());
            }
        };
        ArrayList<Diagnostic> result = Lists.newArrayList(diagnostics);
        Collections.sort(result, diagnosticComparator);
        ArrayList<Diagnostic> arrayList = result;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/diagnostics/DiagnosticUtils", "sortedDiagnostics"));
        }
        return arrayList;
    }

    public static final class LineAndColumn {
        public static final LineAndColumn NONE = new LineAndColumn(-1, -1);
        private final int line;
        private final int column;

        public LineAndColumn(int line, int column) {
            this.line = line;
            this.column = column;
        }

        public int getLine() {
            return this.line;
        }

        public int getColumn() {
            return this.column;
        }

        public String toString() {
            if (this.line < 0) {
                return "(offset: " + this.column + " line unknown)";
            }
            return "(" + this.line + "," + this.column + ")";
        }
    }
}

