/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.lang.psi;

import com.intellij.lang.ASTNode;
import com.intellij.psi.tree.IElementType;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jet.lang.psi.IfNotParsed;
import org.jetbrains.jet.lang.psi.JetElementImpl;
import org.jetbrains.jet.lang.psi.JetExpression;
import org.jetbrains.jet.lang.psi.JetVisitor;
import org.jetbrains.jet.lang.psi.JetVisitorVoid;
import org.jetbrains.jet.lexer.JetTokens;

public class JetImportDirective
extends JetElementImpl {
    public JetImportDirective(@NotNull ASTNode node) {
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/jet/lang/psi/JetImportDirective", "<init>"));
        }
        super(node);
    }

    @Override
    public void accept(@NotNull JetVisitorVoid visitor) {
        if (visitor == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/jet/lang/psi/JetImportDirective", "accept"));
        }
        visitor.visitImportDirective(this);
    }

    @Override
    public <R, D> R accept(@NotNull JetVisitor<R, D> visitor, D data2) {
        if (visitor == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/jet/lang/psi/JetImportDirective", "accept"));
        }
        return visitor.visitImportDirective(this, data2);
    }

    public boolean isAbsoluteInRootNamespace() {
        return this.findChildByType(JetTokens.PACKAGE_KEYWORD) != null;
    }

    @IfNotParsed
    @Nullable
    public JetExpression getImportedReference() {
        return this.findChildByClass(JetExpression.class);
    }

    @Nullable
    public ASTNode getAliasNameNode() {
        boolean asPassed = false;
        for (ASTNode childNode = this.getNode().getFirstChildNode(); childNode != null; childNode = childNode.getTreeNext()) {
            IElementType tt = childNode.getElementType();
            if (tt == JetTokens.AS_KEYWORD) {
                asPassed = true;
            }
            if (!asPassed || tt != JetTokens.IDENTIFIER) continue;
            return childNode;
        }
        return null;
    }

    @Nullable
    public String getAliasName() {
        ASTNode aliasNameNode = this.getAliasNameNode();
        if (aliasNameNode == null) {
            return null;
        }
        return aliasNameNode.getText();
    }

    public boolean isAllUnder() {
        return this.getNode().findChildByType(JetTokens.MUL) != null;
    }
}

