/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.lang.psi;

import com.intellij.lang.ASTNode;
import com.intellij.psi.PsiElement;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jet.JetNodeTypes;
import org.jetbrains.jet.lang.psi.JetAnnotation;
import org.jetbrains.jet.lang.psi.JetAnnotationEntry;
import org.jetbrains.jet.lang.psi.JetElementImpl;
import org.jetbrains.jet.lang.psi.JetModifierList;
import org.jetbrains.jet.lang.psi.JetModifierListOwner;
import org.jetbrains.jet.lang.psi.JetProjectionKind;
import org.jetbrains.jet.lang.psi.JetTypeReference;
import org.jetbrains.jet.lang.psi.JetVisitor;
import org.jetbrains.jet.lang.psi.JetVisitorVoid;
import org.jetbrains.jet.lexer.JetToken;
import org.jetbrains.jet.lexer.JetTokens;

public class JetTypeProjection
extends JetElementImpl
implements JetModifierListOwner {
    public JetTypeProjection(@NotNull ASTNode node) {
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/jet/lang/psi/JetTypeProjection", "<init>"));
        }
        super(node);
    }

    @Override
    public JetModifierList getModifierList() {
        return (JetModifierList)this.findChildByType(JetNodeTypes.MODIFIER_LIST);
    }

    @Override
    public boolean hasModifier(JetToken modifier) {
        JetModifierList modifierList = this.getModifierList();
        return modifierList != null && modifierList.hasModifier(modifier);
    }

    @NotNull
    public JetProjectionKind getProjectionKind() {
        ASTNode projectionNode = this.getProjectionNode();
        if (projectionNode == null) {
            JetProjectionKind jetProjectionKind = JetProjectionKind.NONE;
            if (jetProjectionKind == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/psi/JetTypeProjection", "getProjectionKind"));
            }
            return jetProjectionKind;
        }
        if (projectionNode.getElementType() == JetTokens.IN_KEYWORD) {
            JetProjectionKind jetProjectionKind = JetProjectionKind.IN;
            if (jetProjectionKind == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/psi/JetTypeProjection", "getProjectionKind"));
            }
            return jetProjectionKind;
        }
        if (projectionNode.getElementType() == JetTokens.OUT_KEYWORD) {
            JetProjectionKind jetProjectionKind = JetProjectionKind.OUT;
            if (jetProjectionKind == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/psi/JetTypeProjection", "getProjectionKind"));
            }
            return jetProjectionKind;
        }
        if (projectionNode.getElementType() == JetTokens.MUL) {
            JetProjectionKind jetProjectionKind = JetProjectionKind.STAR;
            if (jetProjectionKind == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/psi/JetTypeProjection", "getProjectionKind"));
            }
            return jetProjectionKind;
        }
        throw new IllegalStateException(projectionNode.getText());
    }

    @Override
    public void accept(@NotNull JetVisitorVoid visitor) {
        if (visitor == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/jet/lang/psi/JetTypeProjection", "accept"));
        }
        visitor.visitTypeProjection(this);
    }

    @Override
    public <R, D> R accept(@NotNull JetVisitor<R, D> visitor, D data2) {
        if (visitor == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/jet/lang/psi/JetTypeProjection", "accept"));
        }
        return visitor.visitTypeProjection(this, data2);
    }

    @Nullable
    public JetTypeReference getTypeReference() {
        return (JetTypeReference)this.findChildByType(JetNodeTypes.TYPE_REFERENCE);
    }

    @Nullable
    public ASTNode getProjectionNode() {
        PsiElement star;
        JetModifierList modifierList = this.getModifierList();
        if (modifierList != null) {
            ASTNode node = modifierList.getModifierNode(JetTokens.IN_KEYWORD);
            if (node != null) {
                return node;
            }
            node = modifierList.getModifierNode(JetTokens.OUT_KEYWORD);
            if (node != null) {
                return node;
            }
        }
        if ((star = this.findChildByType(JetTokens.MUL)) != null) {
            return star.getNode();
        }
        return null;
    }

    @Override
    @NotNull
    public List<JetAnnotationEntry> getAnnotationEntries() {
        JetModifierList modifierList = this.getModifierList();
        if (modifierList == null) {
            List<JetAnnotationEntry> list2 = Collections.emptyList();
            if (list2 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/psi/JetTypeProjection", "getAnnotationEntries"));
            }
            return list2;
        }
        List<JetAnnotationEntry> list3 = modifierList.getAnnotationEntries();
        if (list3 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/psi/JetTypeProjection", "getAnnotationEntries"));
        }
        return list3;
    }

    @Override
    @NotNull
    public List<JetAnnotation> getAnnotations() {
        JetModifierList modifierList = this.getModifierList();
        if (modifierList == null) {
            List<JetAnnotation> list2 = Collections.emptyList();
            if (list2 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/psi/JetTypeProjection", "getAnnotations"));
            }
            return list2;
        }
        List<JetAnnotation> list3 = modifierList.getAnnotations();
        if (list3 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/psi/JetTypeProjection", "getAnnotations"));
        }
        return list3;
    }
}

