/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.lang.resolve;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jet.lang.diagnostics.Diagnostic;
import org.jetbrains.jet.lang.resolve.BindingContext;
import org.jetbrains.jet.lang.resolve.BindingTrace;
import org.jetbrains.jet.lang.resolve.Diagnostics;
import org.jetbrains.jet.lang.resolve.DiagnosticsWithSuppression;
import org.jetbrains.jet.util.slicedmap.MutableSlicedMap;
import org.jetbrains.jet.util.slicedmap.ReadOnlySlice;
import org.jetbrains.jet.util.slicedmap.SlicedMapImpl;
import org.jetbrains.jet.util.slicedmap.TrackingSlicedMap;
import org.jetbrains.jet.util.slicedmap.WritableSlice;

public class BindingTraceContext
implements BindingTrace {
    private final List<Diagnostic> diagnosticList;
    private final Diagnostics diagnostics;
    private final MutableSlicedMap map;
    private final BindingContext bindingContext;

    public BindingTraceContext() {
        this(SlicedMapImpl.create());
    }

    private BindingTraceContext(@NotNull MutableSlicedMap map) {
        if (map == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/jet/lang/resolve/BindingTraceContext", "<init>"));
        }
        this.diagnosticList = Lists.newArrayList();
        this.bindingContext = new BindingContext(){

            @Override
            @NotNull
            public Diagnostics getDiagnostics() {
                Diagnostics diagnostics = BindingTraceContext.this.diagnostics;
                if (diagnostics == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/BindingTraceContext$1", "getDiagnostics"));
                }
                return diagnostics;
            }

            @Override
            public <K, V> V get(ReadOnlySlice<K, V> slice, K key) {
                return BindingTraceContext.this.get(slice, key);
            }

            @Override
            @NotNull
            public <K, V> Collection<K> getKeys(WritableSlice<K, V> slice) {
                Collection<K> collection = BindingTraceContext.this.getKeys(slice);
                if (collection == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/BindingTraceContext$1", "getKeys"));
                }
                return collection;
            }

            @Override
            @NotNull
            public <K, V> ImmutableMap<K, V> getSliceContents(@NotNull ReadOnlySlice<K, V> slice) {
                if (slice == null) {
                    throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/jet/lang/resolve/BindingTraceContext$1", "getSliceContents"));
                }
                ImmutableMap<K, V> immutableMap = BindingTraceContext.this.map.getSliceContents(slice);
                if (immutableMap == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/BindingTraceContext$1", "getSliceContents"));
                }
                return immutableMap;
            }
        };
        this.map = map;
        this.diagnostics = new DiagnosticsWithSuppression(this.getBindingContext(), this.diagnosticList);
    }

    public static BindingTraceContext createTraceableBindingTrace() {
        return new BindingTraceContext(new TrackingSlicedMap(true));
    }

    @Override
    public void report(@NotNull Diagnostic diagnostic) {
        if (diagnostic == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/jet/lang/resolve/BindingTraceContext", "report"));
        }
        this.diagnosticList.add(diagnostic);
    }

    public void clearDiagnostics() {
        this.diagnosticList.clear();
    }

    @Override
    public BindingContext getBindingContext() {
        return this.bindingContext;
    }

    @Override
    public <K, V> void record(WritableSlice<K, V> slice, K key, V value) {
        this.map.put(slice, key, value);
    }

    @Override
    public <K> void record(WritableSlice<K, Boolean> slice, K key) {
        this.record(slice, key, true);
    }

    @Override
    public <K, V> V get(ReadOnlySlice<K, V> slice, K key) {
        return this.map.get(slice, key);
    }

    @Override
    @NotNull
    public <K, V> Collection<K> getKeys(WritableSlice<K, V> slice) {
        Collection<K> collection = this.map.getKeys(slice);
        if (collection == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/BindingTraceContext", "getKeys"));
        }
        return collection;
    }
}

