/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.lang.resolve;

import com.google.common.collect.Sets;
import com.intellij.lang.ASTNode;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jet.lang.descriptors.CallableMemberDescriptor;
import org.jetbrains.jet.lang.descriptors.ClassDescriptor;
import org.jetbrains.jet.lang.descriptors.ClassKind;
import org.jetbrains.jet.lang.descriptors.ConstructorDescriptor;
import org.jetbrains.jet.lang.descriptors.DeclarationDescriptor;
import org.jetbrains.jet.lang.descriptors.Modality;
import org.jetbrains.jet.lang.descriptors.PropertyDescriptor;
import org.jetbrains.jet.lang.descriptors.PropertyGetterDescriptor;
import org.jetbrains.jet.lang.descriptors.SimpleFunctionDescriptor;
import org.jetbrains.jet.lang.descriptors.impl.MutableClassDescriptor;
import org.jetbrains.jet.lang.diagnostics.Errors;
import org.jetbrains.jet.lang.psi.JetClass;
import org.jetbrains.jet.lang.psi.JetDelegationSpecifier;
import org.jetbrains.jet.lang.psi.JetExpression;
import org.jetbrains.jet.lang.psi.JetFunction;
import org.jetbrains.jet.lang.psi.JetModifierList;
import org.jetbrains.jet.lang.psi.JetModifierListOwner;
import org.jetbrains.jet.lang.psi.JetNamedDeclaration;
import org.jetbrains.jet.lang.psi.JetNamedFunction;
import org.jetbrains.jet.lang.psi.JetObjectDeclaration;
import org.jetbrains.jet.lang.psi.JetProperty;
import org.jetbrains.jet.lang.psi.JetPropertyAccessor;
import org.jetbrains.jet.lang.psi.JetPropertyDelegate;
import org.jetbrains.jet.lang.psi.JetTypeReference;
import org.jetbrains.jet.lang.resolve.BindingContext;
import org.jetbrains.jet.lang.resolve.BindingContextUtils;
import org.jetbrains.jet.lang.resolve.BindingTrace;
import org.jetbrains.jet.lang.resolve.BodiesResolveContext;
import org.jetbrains.jet.lang.resolve.DescriptorResolver;
import org.jetbrains.jet.lang.resolve.ModifiersChecker;
import org.jetbrains.jet.lang.types.DeferredType;
import org.jetbrains.jet.lang.types.JetType;
import org.jetbrains.jet.lexer.JetKeywordToken;
import org.jetbrains.jet.lexer.JetTokens;

public class DeclarationsChecker {
    @NotNull
    private BindingTrace trace;
    @NotNull
    private ModifiersChecker modifiersChecker;

    public void setTrace(@NotNull BindingTrace trace) {
        if (trace == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/jet/lang/resolve/DeclarationsChecker", "setTrace"));
        }
        this.trace = trace;
        this.modifiersChecker = new ModifiersChecker(trace);
    }

    public void process(@NotNull BodiesResolveContext bodiesResolveContext) {
        if (bodiesResolveContext == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/jet/lang/resolve/DeclarationsChecker", "process"));
        }
        Map<JetClass, MutableClassDescriptor> classes = bodiesResolveContext.getClasses();
        for (Map.Entry<JetClass, MutableClassDescriptor> entry : classes.entrySet()) {
            JetClass aClass = entry.getKey();
            MutableClassDescriptor classDescriptor = entry.getValue();
            if (!bodiesResolveContext.completeAnalysisNeeded(aClass)) continue;
            this.checkClass(aClass, classDescriptor);
            this.modifiersChecker.checkModifiersForDeclaration(aClass, classDescriptor);
        }
        Map<JetObjectDeclaration, MutableClassDescriptor> objects = bodiesResolveContext.getObjects();
        for (Map.Entry<JetObjectDeclaration, MutableClassDescriptor> entry : objects.entrySet()) {
            JetObjectDeclaration objectDeclaration = entry.getKey();
            MutableClassDescriptor objectDescriptor = entry.getValue();
            if (!bodiesResolveContext.completeAnalysisNeeded(objectDeclaration)) continue;
            this.checkObject(objectDeclaration);
            this.modifiersChecker.checkModifiersForDeclaration(objectDeclaration, objectDescriptor);
        }
        Map<JetNamedFunction, SimpleFunctionDescriptor> functions = bodiesResolveContext.getFunctions();
        for (Map.Entry<JetNamedFunction, SimpleFunctionDescriptor> entry : functions.entrySet()) {
            JetNamedFunction function = entry.getKey();
            SimpleFunctionDescriptor functionDescriptor = entry.getValue();
            if (!bodiesResolveContext.completeAnalysisNeeded(function)) continue;
            this.checkFunction(function, functionDescriptor);
            this.modifiersChecker.checkModifiersForDeclaration(function, functionDescriptor);
        }
        Map<JetProperty, PropertyDescriptor> properties = bodiesResolveContext.getProperties();
        for (Map.Entry<JetProperty, PropertyDescriptor> entry : properties.entrySet()) {
            JetProperty property2 = entry.getKey();
            PropertyDescriptor propertyDescriptor = entry.getValue();
            if (!bodiesResolveContext.completeAnalysisNeeded(property2)) continue;
            this.checkProperty(property2, propertyDescriptor);
            this.modifiersChecker.checkModifiersForDeclaration(property2, propertyDescriptor);
        }
    }

    private void reportErrorIfHasIllegalModifier(JetModifierListOwner declaration) {
        if (declaration.hasModifier(JetTokens.ENUM_KEYWORD)) {
            this.trace.report(Errors.ILLEGAL_ENUM_ANNOTATION.on(declaration));
        }
        if (declaration.hasModifier(JetTokens.ANNOTATION_KEYWORD)) {
            this.trace.report(Errors.ILLEGAL_ANNOTATION_KEYWORD.on(declaration));
        }
    }

    private void checkObject(JetObjectDeclaration declaration) {
        this.reportErrorIfHasIllegalModifier(declaration);
    }

    private void checkClass(JetClass aClass, MutableClassDescriptor classDescriptor) {
        this.checkOpenMembers(classDescriptor);
        if (aClass.isTrait()) {
            this.checkTraitModifiers(aClass);
        } else if (classDescriptor.getKind() == ClassKind.ENUM_CLASS) {
            this.checkEnumModifiers(aClass);
        } else if (classDescriptor.getKind() == ClassKind.ENUM_ENTRY) {
            this.checkEnumEntry(aClass, classDescriptor);
        }
    }

    private void checkTraitModifiers(JetClass aClass) {
        this.reportErrorIfHasIllegalModifier(aClass);
        JetModifierList modifierList = aClass.getModifierList();
        if (modifierList == null) {
            return;
        }
        if (modifierList.hasModifier(JetTokens.FINAL_KEYWORD)) {
            this.trace.report(Errors.TRAIT_CAN_NOT_BE_FINAL.on(modifierList.getModifierNode(JetTokens.FINAL_KEYWORD).getPsi()));
        }
        if (modifierList.hasModifier(JetTokens.ABSTRACT_KEYWORD)) {
            this.trace.report(Errors.ABSTRACT_MODIFIER_IN_TRAIT.on(aClass));
        }
        if (modifierList.hasModifier(JetTokens.OPEN_KEYWORD)) {
            this.trace.report(Errors.OPEN_MODIFIER_IN_TRAIT.on(aClass));
        }
    }

    private void checkOpenMembers(MutableClassDescriptor classDescriptor) {
        for (CallableMemberDescriptor memberDescriptor : classDescriptor.getDeclaredCallableMembers()) {
            JetNamedDeclaration member;
            if (memberDescriptor.getKind() != CallableMemberDescriptor.Kind.DECLARATION || (member = (JetNamedDeclaration)BindingContextUtils.descriptorToDeclaration(this.trace.getBindingContext(), memberDescriptor)) == null || classDescriptor.getModality() != Modality.FINAL || !member.hasModifier(JetTokens.OPEN_KEYWORD)) continue;
            this.trace.report(Errors.NON_FINAL_MEMBER_IN_FINAL_CLASS.on(member));
        }
    }

    private void checkProperty(JetProperty property2, PropertyDescriptor propertyDescriptor) {
        this.reportErrorIfHasIllegalModifier(property2);
        DeclarationDescriptor containingDeclaration = propertyDescriptor.getContainingDeclaration();
        if (containingDeclaration instanceof ClassDescriptor) {
            this.checkPropertyAbstractness(property2, propertyDescriptor, (ClassDescriptor)containingDeclaration);
        } else {
            this.modifiersChecker.checkIllegalModalityModifiers(property2);
        }
        this.checkPropertyInitializer(property2, propertyDescriptor);
        this.checkAccessors(property2, propertyDescriptor);
        this.checkDeclaredTypeInPublicMember(property2, propertyDescriptor);
    }

    private void checkDeclaredTypeInPublicMember(JetNamedDeclaration member, CallableMemberDescriptor memberDescriptor) {
        boolean hasDeferredType;
        if (member instanceof JetProperty) {
            hasDeferredType = ((JetProperty)member).getTypeRef() == null && DescriptorResolver.hasBody((JetProperty)member);
        } else {
            assert (member instanceof JetFunction);
            JetFunction function = (JetFunction)member;
            boolean bl = hasDeferredType = function.getReturnTypeRef() == null && function.getBodyExpression() != null && !function.hasBlockBody();
        }
        if (memberDescriptor.getVisibility().isPublicAPI() && memberDescriptor.getOverriddenDescriptors().size() == 0 && hasDeferredType) {
            this.trace.report(Errors.PUBLIC_MEMBER_SHOULD_SPECIFY_TYPE.on(member));
        }
    }

    private void checkPropertyAbstractness(@NotNull JetProperty property2, @NotNull PropertyDescriptor propertyDescriptor, @NotNull ClassDescriptor classDescriptor) {
        ASTNode abstractNode;
        if (property2 == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/jet/lang/resolve/DeclarationsChecker", "checkPropertyAbstractness"));
        }
        if (propertyDescriptor == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "org/jetbrains/jet/lang/resolve/DeclarationsChecker", "checkPropertyAbstractness"));
        }
        if (classDescriptor == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "org/jetbrains/jet/lang/resolve/DeclarationsChecker", "checkPropertyAbstractness"));
        }
        JetPropertyAccessor getter = property2.getGetter();
        JetPropertyAccessor setter = property2.getSetter();
        JetModifierList modifierList = property2.getModifierList();
        ASTNode aSTNode = abstractNode = modifierList != null ? modifierList.getModifierNode(JetTokens.ABSTRACT_KEYWORD) : null;
        if (abstractNode != null) {
            if (classDescriptor.getModality() != Modality.ABSTRACT && classDescriptor.getKind() != ClassKind.ENUM_CLASS) {
                String name = property2.getName();
                this.trace.report(Errors.ABSTRACT_PROPERTY_IN_NON_ABSTRACT_CLASS.on(property2, name != null ? name : "", classDescriptor));
                return;
            }
            if (classDescriptor.getKind() == ClassKind.TRAIT) {
                this.trace.report(Errors.ABSTRACT_MODIFIER_IN_TRAIT.on(property2));
            }
        }
        if (propertyDescriptor.getModality() == Modality.ABSTRACT) {
            JetPropertyDelegate delegate;
            JetExpression initializer;
            JetType returnType = propertyDescriptor.getReturnType();
            if (returnType instanceof DeferredType) {
                returnType = ((DeferredType)returnType).getActualType();
            }
            if ((initializer = property2.getInitializer()) != null) {
                this.trace.report(Errors.ABSTRACT_PROPERTY_WITH_INITIALIZER.on(initializer));
            }
            if ((delegate = property2.getDelegate()) != null) {
                this.trace.report(Errors.ABSTRACT_DELEGATED_PROPERTY.on(delegate));
            }
            if (getter != null && getter.getBodyExpression() != null) {
                this.trace.report(Errors.ABSTRACT_PROPERTY_WITH_GETTER.on(getter));
            }
            if (setter != null && setter.getBodyExpression() != null) {
                this.trace.report(Errors.ABSTRACT_PROPERTY_WITH_SETTER.on(setter));
            }
        }
    }

    private void checkPropertyInitializer(@NotNull JetProperty property2, @NotNull PropertyDescriptor propertyDescriptor) {
        boolean hasAccessorImplementation;
        if (property2 == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/jet/lang/resolve/DeclarationsChecker", "checkPropertyInitializer"));
        }
        if (propertyDescriptor == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "org/jetbrains/jet/lang/resolve/DeclarationsChecker", "checkPropertyInitializer"));
        }
        JetPropertyAccessor getter = property2.getGetter();
        JetPropertyAccessor setter = property2.getSetter();
        boolean bl = hasAccessorImplementation = getter != null && getter.getBodyExpression() != null || setter != null && setter.getBodyExpression() != null;
        if (propertyDescriptor.getModality() == Modality.ABSTRACT) {
            if (property2.getDelegateExpressionOrInitializer() == null && property2.getTypeRef() == null) {
                this.trace.report(Errors.PROPERTY_WITH_NO_TYPE_NO_INITIALIZER.on(property2));
            }
            return;
        }
        DeclarationDescriptor containingDeclaration = propertyDescriptor.getContainingDeclaration();
        boolean inTrait = containingDeclaration instanceof ClassDescriptor && ((ClassDescriptor)containingDeclaration).getKind() == ClassKind.TRAIT;
        JetExpression initializer = property2.getInitializer();
        JetPropertyDelegate delegate = property2.getDelegate();
        boolean backingFieldRequired = this.trace.getBindingContext().get(BindingContext.BACKING_FIELD_REQUIRED, propertyDescriptor);
        if (inTrait && backingFieldRequired && hasAccessorImplementation) {
            this.trace.report(Errors.BACKING_FIELD_IN_TRAIT.on(property2));
        }
        if (initializer == null && delegate == null) {
            boolean error = false;
            if (backingFieldRequired && !inTrait && !this.trace.getBindingContext().get(BindingContext.IS_INITIALIZED, propertyDescriptor).booleanValue()) {
                if (!(containingDeclaration instanceof ClassDescriptor) || hasAccessorImplementation) {
                    error = true;
                    this.trace.report(Errors.MUST_BE_INITIALIZED.on(property2));
                } else {
                    error = true;
                    this.trace.report(Errors.MUST_BE_INITIALIZED_OR_BE_ABSTRACT.on(property2));
                }
            }
            if (!error && property2.getTypeRef() == null) {
                this.trace.report(Errors.PROPERTY_WITH_NO_TYPE_NO_INITIALIZER.on(property2));
            }
            if (inTrait && property2.hasModifier(JetTokens.FINAL_KEYWORD) && backingFieldRequired) {
                this.trace.report(Errors.FINAL_PROPERTY_IN_TRAIT.on(property2));
            }
            return;
        }
        if (inTrait) {
            if (delegate != null) {
                this.trace.report(Errors.DELEGATED_PROPERTY_IN_TRAIT.on(delegate));
            } else {
                this.trace.report(Errors.PROPERTY_INITIALIZER_IN_TRAIT.on(initializer));
            }
        } else if (!backingFieldRequired && delegate == null) {
            this.trace.report(Errors.PROPERTY_INITIALIZER_NO_BACKING_FIELD.on(initializer));
        }
    }

    protected void checkFunction(JetNamedFunction function, SimpleFunctionDescriptor functionDescriptor) {
        this.reportErrorIfHasIllegalModifier(function);
        DeclarationDescriptor containingDescriptor = functionDescriptor.getContainingDeclaration();
        boolean hasAbstractModifier = function.hasModifier(JetTokens.ABSTRACT_KEYWORD);
        this.checkDeclaredTypeInPublicMember(function, functionDescriptor);
        if (containingDescriptor instanceof ClassDescriptor) {
            boolean hasBody;
            boolean inAbstractClass;
            ClassDescriptor classDescriptor = (ClassDescriptor)containingDescriptor;
            boolean inTrait = classDescriptor.getKind() == ClassKind.TRAIT;
            boolean inEnum = classDescriptor.getKind() == ClassKind.ENUM_CLASS;
            boolean bl = inAbstractClass = classDescriptor.getModality() == Modality.ABSTRACT;
            if (hasAbstractModifier && !inAbstractClass && !inEnum) {
                this.trace.report(Errors.ABSTRACT_FUNCTION_IN_NON_ABSTRACT_CLASS.on(function, functionDescriptor.getName().asString(), classDescriptor));
            }
            if (hasAbstractModifier && inTrait) {
                this.trace.report(Errors.ABSTRACT_MODIFIER_IN_TRAIT.on(function));
            }
            boolean bl2 = hasBody = function.getBodyExpression() != null;
            if (hasBody && hasAbstractModifier) {
                this.trace.report(Errors.ABSTRACT_FUNCTION_WITH_BODY.on(function, functionDescriptor));
            }
            if (!hasBody && function.hasModifier(JetTokens.FINAL_KEYWORD) && inTrait) {
                this.trace.report(Errors.FINAL_FUNCTION_WITH_NO_BODY.on(function, functionDescriptor));
            }
            if (!(hasBody || hasAbstractModifier || inTrait)) {
                this.trace.report(Errors.NON_ABSTRACT_FUNCTION_WITH_NO_BODY.on(function, functionDescriptor));
            }
            return;
        }
        this.modifiersChecker.checkIllegalModalityModifiers(function);
        if (function.getBodyExpression() == null && !hasAbstractModifier) {
            this.trace.report(Errors.NON_MEMBER_FUNCTION_NO_BODY.on(function, functionDescriptor));
        }
    }

    private void checkAccessors(@NotNull JetProperty property2, @NotNull PropertyDescriptor propertyDescriptor) {
        block7: {
            JetModifierList getterModifierList;
            if (property2 == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/jet/lang/resolve/DeclarationsChecker", "checkAccessors"));
            }
            if (propertyDescriptor == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "org/jetbrains/jet/lang/resolve/DeclarationsChecker", "checkAccessors"));
            }
            for (JetPropertyAccessor accessor : property2.getAccessors()) {
                this.modifiersChecker.checkIllegalModalityModifiers(accessor);
            }
            JetPropertyAccessor getter = property2.getGetter();
            PropertyGetterDescriptor getterDescriptor = propertyDescriptor.getGetter();
            JetModifierList jetModifierList = getterModifierList = getter != null ? getter.getModifierList() : null;
            if (getterModifierList == null || getterDescriptor == null) break block7;
            Map<JetKeywordToken, ASTNode> nodes = ModifiersChecker.getNodesCorrespondingToModifiers(getterModifierList, Sets.newHashSet(JetTokens.PUBLIC_KEYWORD, JetTokens.PROTECTED_KEYWORD, JetTokens.PRIVATE_KEYWORD, JetTokens.INTERNAL_KEYWORD));
            if (getterDescriptor.getVisibility() != propertyDescriptor.getVisibility()) {
                for (ASTNode node : nodes.values()) {
                    this.trace.report(Errors.GETTER_VISIBILITY_DIFFERS_FROM_PROPERTY_VISIBILITY.on(node.getPsi()));
                }
            } else {
                for (ASTNode node : nodes.values()) {
                    this.trace.report(Errors.REDUNDANT_MODIFIER_IN_GETTER.on(node.getPsi()));
                }
            }
        }
    }

    private void checkEnumModifiers(JetClass aClass) {
        if (aClass.hasModifier(JetTokens.OPEN_KEYWORD)) {
            this.trace.report(Errors.OPEN_MODIFIER_IN_ENUM.on(aClass));
        }
    }

    private void checkEnumEntry(JetClass aClass, ClassDescriptor classDescriptor) {
        DeclarationDescriptor declaration = classDescriptor.getContainingDeclaration().getContainingDeclaration();
        assert (declaration instanceof ClassDescriptor);
        ClassDescriptor enumClass = (ClassDescriptor)declaration;
        assert (enumClass.getKind() == ClassKind.ENUM_CLASS);
        List<JetDelegationSpecifier> delegationSpecifiers = aClass.getDelegationSpecifiers();
        ConstructorDescriptor constructor = enumClass.getUnsubstitutedPrimaryConstructor();
        assert (constructor != null);
        if (!constructor.getValueParameters().isEmpty() && delegationSpecifiers.isEmpty()) {
            this.trace.report(Errors.ENUM_ENTRY_SHOULD_BE_INITIALIZED.on(aClass, enumClass));
        }
        for (JetDelegationSpecifier delegationSpecifier : delegationSpecifiers) {
            JetType type;
            JetTypeReference typeReference = delegationSpecifier.getTypeReference();
            if (typeReference == null || (type = this.trace.getBindingContext().get(BindingContext.TYPE, typeReference)) == null) continue;
            JetType enumType = enumClass.getDefaultType();
            if (type.getConstructor().equals(enumType.getConstructor())) continue;
            this.trace.report(Errors.ENUM_ENTRY_ILLEGAL_TYPE.on(typeReference, enumClass));
        }
    }
}

