/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.lang.resolve.calls.model;

import com.google.common.collect.Maps;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jet.lang.psi.Call;
import org.jetbrains.jet.lang.psi.ValueArgument;
import org.jetbrains.jet.lang.resolve.calls.autocasts.DataFlowInfo;
import org.jetbrains.jet.lang.resolve.calls.model.MutableDataFlowInfoForArguments;

public class DataFlowInfoForArgumentsImpl
implements MutableDataFlowInfoForArguments {
    private final Call call;
    private final Map<ValueArgument, DataFlowInfo> infoMap;
    private final Map<ValueArgument, ValueArgument> nextArgument;
    private DataFlowInfo initialInfo;
    private DataFlowInfo resultInfo;

    public DataFlowInfoForArgumentsImpl(@NotNull Call call) {
        if (call == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/jet/lang/resolve/calls/model/DataFlowInfoForArgumentsImpl", "<init>"));
        }
        this.infoMap = Maps.newHashMap();
        this.nextArgument = Maps.newHashMap();
        this.call = call;
        this.initNextArgMap(call.getValueArguments());
    }

    private void initNextArgMap(@NotNull List<? extends ValueArgument> valueArguments) {
        if (valueArguments == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/jet/lang/resolve/calls/model/DataFlowInfoForArgumentsImpl", "initNextArgMap"));
        }
        Iterator<? extends ValueArgument> iterator2 = valueArguments.iterator();
        ValueArgument prev = null;
        while (iterator2.hasNext()) {
            ValueArgument argument = iterator2.next();
            if (prev != null) {
                this.nextArgument.put(prev, argument);
            }
            prev = argument;
        }
    }

    @Override
    public void setInitialDataFlowInfo(@NotNull DataFlowInfo dataFlowInfo) {
        if (dataFlowInfo == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/jet/lang/resolve/calls/model/DataFlowInfoForArgumentsImpl", "setInitialDataFlowInfo"));
        }
        this.initialInfo = dataFlowInfo;
    }

    @Override
    @NotNull
    public DataFlowInfo getInfo(@NotNull ValueArgument valueArgument) {
        if (valueArgument == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/jet/lang/resolve/calls/model/DataFlowInfoForArgumentsImpl", "getInfo"));
        }
        DataFlowInfo infoForArgument = this.infoMap.get(valueArgument);
        if (infoForArgument == null) {
            DataFlowInfo dataFlowInfo = this.initialInfo;
            if (dataFlowInfo == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/calls/model/DataFlowInfoForArgumentsImpl", "getInfo"));
            }
            return dataFlowInfo;
        }
        DataFlowInfo dataFlowInfo = this.initialInfo.and(infoForArgument);
        if (dataFlowInfo == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/calls/model/DataFlowInfoForArgumentsImpl", "getInfo"));
        }
        return dataFlowInfo;
    }

    @Override
    public void updateInfo(@NotNull ValueArgument valueArgument, @NotNull DataFlowInfo dataFlowInfo) {
        if (valueArgument == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/jet/lang/resolve/calls/model/DataFlowInfoForArgumentsImpl", "updateInfo"));
        }
        if (dataFlowInfo == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "org/jetbrains/jet/lang/resolve/calls/model/DataFlowInfoForArgumentsImpl", "updateInfo"));
        }
        ValueArgument next = this.nextArgument.get(valueArgument);
        if (next != null) {
            this.infoMap.put(next, dataFlowInfo);
            return;
        }
        this.resultInfo = dataFlowInfo;
    }

    @Override
    @NotNull
    public DataFlowInfo getResultInfo() {
        if (this.resultInfo == null) {
            DataFlowInfo dataFlowInfo = this.initialInfo;
            if (dataFlowInfo == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/calls/model/DataFlowInfoForArgumentsImpl", "getResultInfo"));
            }
            return dataFlowInfo;
        }
        assert (this.initialInfo != null) : "Initial data flow info was not set for call: " + this.call;
        DataFlowInfo dataFlowInfo = this.initialInfo.and(this.resultInfo);
        if (dataFlowInfo == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/calls/model/DataFlowInfoForArgumentsImpl", "getResultInfo"));
        }
        return dataFlowInfo;
    }
}

