/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.lang.resolve.calls.model;

import com.google.common.collect.Lists;
import java.util.Iterator;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jet.lang.psi.JetExpression;
import org.jetbrains.jet.lang.psi.ValueArgument;
import org.jetbrains.jet.lang.resolve.calls.model.ResolvedValueArgument;

public class VarargValueArgument
implements ResolvedValueArgument {
    private final List<ValueArgument> arguments = Lists.newArrayList();

    public void addArgument(@NotNull ValueArgument argument) {
        if (argument == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/jet/lang/resolve/calls/model/VarargValueArgument", "addArgument"));
        }
        this.arguments.add(argument);
    }

    @Override
    @NotNull
    public List<ValueArgument> getArguments() {
        List<ValueArgument> list2 = this.arguments;
        if (list2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/calls/model/VarargValueArgument", "getArguments"));
        }
        return list2;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder("vararg:{");
        Iterator<ValueArgument> iterator2 = this.arguments.iterator();
        while (iterator2.hasNext()) {
            ValueArgument valueArgument = iterator2.next();
            JetExpression expression = valueArgument.getArgumentExpression();
            builder.append(expression == null ? "no expression" : expression.getText());
            if (!iterator2.hasNext()) continue;
            builder.append(", ");
        }
        return builder.append("}").toString();
    }
}

