/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.lang.resolve.constants;

import com.google.common.base.Function;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jet.lang.descriptors.annotations.AnnotationArgumentVisitor;
import org.jetbrains.jet.lang.resolve.constants.CompileTimeConstant;
import org.jetbrains.jet.lang.types.JetType;
import org.jetbrains.jet.lang.types.lang.KotlinBuiltIns;

public class ByteValue
implements CompileTimeConstant<Byte> {
    public static final Function<Long, ByteValue> CREATE = new Function<Long, ByteValue>(){

        @Override
        public ByteValue apply(@Nullable Long input) {
            assert (input != null);
            return new ByteValue(input.byteValue());
        }
    };
    private final byte value;

    public ByteValue(byte value) {
        this.value = value;
    }

    @Override
    public Byte getValue() {
        return this.value;
    }

    @Override
    @NotNull
    public JetType getType(@NotNull KotlinBuiltIns kotlinBuiltIns) {
        if (kotlinBuiltIns == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/jet/lang/resolve/constants/ByteValue", "getType"));
        }
        JetType jetType = kotlinBuiltIns.getByteType();
        if (jetType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/constants/ByteValue", "getType"));
        }
        return jetType;
    }

    @Override
    public <R, D> R accept(AnnotationArgumentVisitor<R, D> visitor, D data2) {
        return visitor.visitByteValue(this, data2);
    }

    public String toString() {
        return this.value + ".toByte()";
    }
}

