/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.lang.resolve.constants;

import org.jetbrains.annotations.NotNull;
import org.jetbrains.jet.lang.descriptors.PropertyDescriptor;
import org.jetbrains.jet.lang.descriptors.annotations.AnnotationArgumentVisitor;
import org.jetbrains.jet.lang.resolve.constants.CompileTimeConstant;
import org.jetbrains.jet.lang.types.JetType;
import org.jetbrains.jet.lang.types.lang.KotlinBuiltIns;

public class EnumValue
implements CompileTimeConstant<PropertyDescriptor> {
    private final PropertyDescriptor value;

    public EnumValue(@NotNull PropertyDescriptor value) {
        if (value == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/jet/lang/resolve/constants/EnumValue", "<init>"));
        }
        this.value = value;
    }

    @Override
    @NotNull
    public PropertyDescriptor getValue() {
        PropertyDescriptor propertyDescriptor = this.value;
        if (propertyDescriptor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/constants/EnumValue", "getValue"));
        }
        return propertyDescriptor;
    }

    @Override
    @NotNull
    public JetType getType(@NotNull KotlinBuiltIns kotlinBuiltIns) {
        if (kotlinBuiltIns == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/jet/lang/resolve/constants/EnumValue", "getType"));
        }
        JetType jetType = this.value.getType();
        if (jetType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/constants/EnumValue", "getType"));
        }
        return jetType;
    }

    @Override
    public <R, D> R accept(AnnotationArgumentVisitor<R, D> visitor, D data2) {
        return visitor.visitEnumValue(this, data2);
    }

    public String toString() {
        return this.value.getType() + "." + this.value.getName();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        EnumValue enumValue = (EnumValue)o;
        return this.value.equals(enumValue.value);
    }

    public int hashCode() {
        return this.value.hashCode();
    }
}

