/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.lang.resolve.java.mapping;

import org.jetbrains.annotations.NotNull;
import org.jetbrains.asm4.Type;
import org.jetbrains.jet.lang.resolve.java.JvmPrimitiveType;

public class PrimitiveTypesUtil {
    private PrimitiveTypesUtil() {
    }

    public static Type asmTypeForPrimitive(@NotNull JvmPrimitiveType jvmPrimitiveType) {
        if (jvmPrimitiveType == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/jet/lang/resolve/java/mapping/PrimitiveTypesUtil", "asmTypeForPrimitive"));
        }
        switch (jvmPrimitiveType) {
            case BOOLEAN: {
                return Type.BOOLEAN_TYPE;
            }
            case CHAR: {
                return Type.CHAR_TYPE;
            }
            case BYTE: {
                return Type.BYTE_TYPE;
            }
            case SHORT: {
                return Type.SHORT_TYPE;
            }
            case INT: {
                return Type.INT_TYPE;
            }
            case FLOAT: {
                return Type.FLOAT_TYPE;
            }
            case LONG: {
                return Type.LONG_TYPE;
            }
            case DOUBLE: {
                return Type.DOUBLE_TYPE;
            }
        }
        throw new IllegalStateException("Unknown primitive type: " + (Object)((Object)jvmPrimitiveType));
    }
}

