/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.lang.resolve.java.resolver;

import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jet.lang.descriptors.CallableMemberDescriptor;
import org.jetbrains.jet.lang.descriptors.ClassDescriptor;
import org.jetbrains.jet.lang.descriptors.TypeParameterDescriptor;
import org.jetbrains.jet.lang.descriptors.ValueParameterDescriptor;
import org.jetbrains.jet.lang.resolve.BindingTrace;
import org.jetbrains.jet.lang.resolve.java.JavaBindingContext;
import org.jetbrains.jet.lang.resolve.java.kotlinSignature.AlternativeFieldSignatureData;
import org.jetbrains.jet.lang.resolve.java.kotlinSignature.AlternativeMethodSignatureData;
import org.jetbrains.jet.lang.resolve.java.kotlinSignature.SignaturesPropagationData;
import org.jetbrains.jet.lang.resolve.java.resolver.ExternalSignatureResolver;
import org.jetbrains.jet.lang.resolve.java.resolver.JavaAnnotationResolver;
import org.jetbrains.jet.lang.resolve.java.structure.JavaField;
import org.jetbrains.jet.lang.resolve.java.structure.JavaMethod;
import org.jetbrains.jet.lang.resolve.java.structure.impl.JavaFieldImpl;
import org.jetbrains.jet.lang.resolve.java.structure.impl.JavaMethodImpl;
import org.jetbrains.jet.lang.types.JetType;

public class TraceBasedExternalSignatureResolver
implements ExternalSignatureResolver {
    private BindingTrace trace;
    private JavaAnnotationResolver annotationResolver;

    public void setTrace(BindingTrace trace) {
        this.trace = trace;
    }

    public void setAnnotationResolver(JavaAnnotationResolver annotationResolver) {
        this.annotationResolver = annotationResolver;
    }

    @Override
    @NotNull
    public ExternalSignatureResolver.PropagatedMethodSignature resolvePropagatedSignature(@NotNull JavaMethod method, @NotNull ClassDescriptor owner, @NotNull JetType returnType, @Nullable JetType receiverType, @NotNull List<ValueParameterDescriptor> valueParameters, @NotNull List<TypeParameterDescriptor> typeParameters) {
        if (method == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/jet/lang/resolve/java/resolver/TraceBasedExternalSignatureResolver", "resolvePropagatedSignature"));
        }
        if (owner == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "org/jetbrains/jet/lang/resolve/java/resolver/TraceBasedExternalSignatureResolver", "resolvePropagatedSignature"));
        }
        if (returnType == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "org/jetbrains/jet/lang/resolve/java/resolver/TraceBasedExternalSignatureResolver", "resolvePropagatedSignature"));
        }
        if (valueParameters == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "4", "org/jetbrains/jet/lang/resolve/java/resolver/TraceBasedExternalSignatureResolver", "resolvePropagatedSignature"));
        }
        if (typeParameters == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "5", "org/jetbrains/jet/lang/resolve/java/resolver/TraceBasedExternalSignatureResolver", "resolvePropagatedSignature"));
        }
        SignaturesPropagationData data2 = new SignaturesPropagationData(owner, returnType, receiverType, valueParameters, typeParameters, (JavaMethodImpl)method, this.trace);
        ExternalSignatureResolver.PropagatedMethodSignature propagatedMethodSignature = new ExternalSignatureResolver.PropagatedMethodSignature(data2.getModifiedReturnType(), data2.getModifiedReceiverType(), data2.getModifiedValueParameters(), data2.getModifiedTypeParameters(), data2.getSignatureErrors(), data2.getSuperFunctions());
        if (propagatedMethodSignature == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/java/resolver/TraceBasedExternalSignatureResolver", "resolvePropagatedSignature"));
        }
        return propagatedMethodSignature;
    }

    @Override
    @NotNull
    public ExternalSignatureResolver.AlternativeMethodSignature resolveAlternativeMethodSignature(@NotNull JavaMethod method, boolean hasSuperMethods, @Nullable JetType returnType, @Nullable JetType receiverType, @NotNull List<ValueParameterDescriptor> valueParameters, @NotNull List<TypeParameterDescriptor> typeParameters) {
        if (method == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/jet/lang/resolve/java/resolver/TraceBasedExternalSignatureResolver", "resolveAlternativeMethodSignature"));
        }
        if (valueParameters == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "4", "org/jetbrains/jet/lang/resolve/java/resolver/TraceBasedExternalSignatureResolver", "resolveAlternativeMethodSignature"));
        }
        if (typeParameters == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "5", "org/jetbrains/jet/lang/resolve/java/resolver/TraceBasedExternalSignatureResolver", "resolveAlternativeMethodSignature"));
        }
        AlternativeMethodSignatureData data2 = new AlternativeMethodSignatureData(this.annotationResolver, (JavaMethodImpl)method, receiverType, valueParameters, returnType, typeParameters, hasSuperMethods);
        if (data2.isAnnotated() && !data2.hasErrors()) {
            ExternalSignatureResolver.AlternativeMethodSignature alternativeMethodSignature = new ExternalSignatureResolver.AlternativeMethodSignature(data2.getReturnType(), receiverType, data2.getValueParameters(), data2.getTypeParameters(), Collections.<String>emptyList());
            if (alternativeMethodSignature == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/java/resolver/TraceBasedExternalSignatureResolver", "resolveAlternativeMethodSignature"));
            }
            return alternativeMethodSignature;
        }
        List<String> error = data2.hasErrors() ? Collections.singletonList(data2.getError()) : Collections.emptyList();
        ExternalSignatureResolver.AlternativeMethodSignature alternativeMethodSignature = new ExternalSignatureResolver.AlternativeMethodSignature(returnType, receiverType, valueParameters, typeParameters, error);
        if (alternativeMethodSignature == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/java/resolver/TraceBasedExternalSignatureResolver", "resolveAlternativeMethodSignature"));
        }
        return alternativeMethodSignature;
    }

    @Override
    @NotNull
    public ExternalSignatureResolver.AlternativeFieldSignature resolveAlternativeFieldSignature(@NotNull JavaField field, @NotNull JetType returnType, boolean isVar) {
        if (field == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/jet/lang/resolve/java/resolver/TraceBasedExternalSignatureResolver", "resolveAlternativeFieldSignature"));
        }
        if (returnType == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "org/jetbrains/jet/lang/resolve/java/resolver/TraceBasedExternalSignatureResolver", "resolveAlternativeFieldSignature"));
        }
        AlternativeFieldSignatureData data2 = new AlternativeFieldSignatureData(this.annotationResolver, (JavaFieldImpl)field, returnType, isVar);
        if (data2.isAnnotated() && !data2.hasErrors()) {
            ExternalSignatureResolver.AlternativeFieldSignature alternativeFieldSignature = new ExternalSignatureResolver.AlternativeFieldSignature(data2.getReturnType(), null);
            if (alternativeFieldSignature == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/java/resolver/TraceBasedExternalSignatureResolver", "resolveAlternativeFieldSignature"));
            }
            return alternativeFieldSignature;
        }
        String error = data2.hasErrors() ? data2.getError() : null;
        ExternalSignatureResolver.AlternativeFieldSignature alternativeFieldSignature = new ExternalSignatureResolver.AlternativeFieldSignature(returnType, error);
        if (alternativeFieldSignature == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/java/resolver/TraceBasedExternalSignatureResolver", "resolveAlternativeFieldSignature"));
        }
        return alternativeFieldSignature;
    }

    @Override
    public void reportSignatureErrors(@NotNull CallableMemberDescriptor descriptor, @NotNull List<String> signatureErrors) {
        if (descriptor == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/jet/lang/resolve/java/resolver/TraceBasedExternalSignatureResolver", "reportSignatureErrors"));
        }
        if (signatureErrors == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "org/jetbrains/jet/lang/resolve/java/resolver/TraceBasedExternalSignatureResolver", "reportSignatureErrors"));
        }
        this.trace.record(JavaBindingContext.LOAD_FROM_JAVA_SIGNATURE_ERRORS, descriptor, signatureErrors);
    }
}

