/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.lang.resolve.java.scope;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jet.lang.descriptors.Visibilities;
import org.jetbrains.jet.lang.resolve.java.resolver.DescriptorResolverUtils;
import org.jetbrains.jet.lang.resolve.java.sam.SingleAbstractMethodUtils;
import org.jetbrains.jet.lang.resolve.java.scope.NamedMembers;
import org.jetbrains.jet.lang.resolve.java.structure.JavaClass;
import org.jetbrains.jet.lang.resolve.java.structure.JavaField;
import org.jetbrains.jet.lang.resolve.java.structure.JavaMember;
import org.jetbrains.jet.lang.resolve.java.structure.JavaMethod;
import org.jetbrains.jet.lang.resolve.java.structure.JavaNamedElement;
import org.jetbrains.jet.lang.resolve.java.structure.JavaPackage;
import org.jetbrains.jet.lang.resolve.name.FqName;
import org.jetbrains.jet.lang.resolve.name.Name;

final class MembersCache {
    private final Map<Name, Collection<Runnable>> memberProcessingTasks = new HashMap<Name, Collection<Runnable>>();
    private final Map<Name, NamedMembers> namedMembersMap = new HashMap<Name, NamedMembers>();

    MembersCache() {
    }

    @Nullable
    public NamedMembers get(@NotNull Name name) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/jet/lang/resolve/java/scope/MembersCache", "get"));
        }
        this.runTasksByName(name);
        return this.namedMembersMap.get(name);
    }

    @NotNull
    public Collection<NamedMembers> allMembers() {
        this.runAllTasks();
        this.memberProcessingTasks.clear();
        Collection<NamedMembers> collection = this.namedMembersMap.values();
        if (collection == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/java/scope/MembersCache", "allMembers"));
        }
        return collection;
    }

    @NotNull
    private NamedMembers getOrCreateEmpty(@NotNull JavaNamedElement element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/jet/lang/resolve/java/scope/MembersCache", "getOrCreateEmpty"));
        }
        Name name = element.getName();
        NamedMembers r = this.namedMembersMap.get(name);
        if (r == null) {
            r = new NamedMembers(name);
            this.namedMembersMap.put(name, r);
        }
        NamedMembers namedMembers = r;
        if (namedMembers == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/java/scope/MembersCache", "getOrCreateEmpty"));
        }
        return namedMembers;
    }

    private void addTask(@NotNull JavaNamedElement member, @NotNull RunOnce task) {
        if (member == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/jet/lang/resolve/java/scope/MembersCache", "addTask"));
        }
        if (task == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "org/jetbrains/jet/lang/resolve/java/scope/MembersCache", "addTask"));
        }
        Name name = member.getName();
        Collection<Runnable> tasks = this.memberProcessingTasks.get(name);
        if (tasks == null) {
            tasks = new HashSet<Runnable>();
            this.memberProcessingTasks.put(name, tasks);
        }
        tasks.add(task);
    }

    private void runTasksByName(Name name) {
        if (!this.memberProcessingTasks.containsKey(name)) {
            return;
        }
        Collection<Runnable> tasks = this.memberProcessingTasks.get(name);
        for (Runnable task : tasks) {
            task.run();
        }
        tasks.clear();
    }

    private void runAllTasks() {
        for (Collection<Runnable> tasks : this.memberProcessingTasks.values()) {
            for (Runnable task : tasks) {
                task.run();
            }
        }
    }

    @NotNull
    public static MembersCache buildForClass(@NotNull JavaClass javaClass, boolean staticMembers) {
        MembersCache membersCache;
        if (javaClass == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/jet/lang/resolve/java/scope/MembersCache", "buildForClass"));
        }
        MembersCache membersCache2 = membersCache = new MembersCache();
        membersCache2.getClass();
        membersCache2.new ClassMemberProcessor(javaClass, staticMembers).process();
        MembersCache membersCache3 = membersCache;
        membersCache3.getClass();
        membersCache3.new ExtraPackageMembersProcessor(javaClass.getInnerClasses()).process();
        MembersCache membersCache4 = membersCache;
        if (membersCache4 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/java/scope/MembersCache", "buildForClass"));
        }
        return membersCache4;
    }

    @NotNull
    public static MembersCache buildForPackage(@NotNull JavaPackage javaPackage) {
        if (javaPackage == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/jet/lang/resolve/java/scope/MembersCache", "buildForPackage"));
        }
        MembersCache membersCache = new MembersCache();
        Collection<JavaClass> classes = DescriptorResolverUtils.getClassesInPackage(javaPackage);
        MembersCache membersCache2 = membersCache;
        membersCache2.getClass();
        membersCache2.new ExtraPackageMembersProcessor(classes).process();
        MembersCache membersCache3 = membersCache;
        if (membersCache3 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/java/scope/MembersCache", "buildForPackage"));
        }
        return membersCache3;
    }

    private static abstract class RunOnce
    implements Runnable {
        private boolean hasRun = false;

        private RunOnce() {
        }

        @Override
        public final void run() {
            if (this.hasRun) {
                return;
            }
            this.hasRun = true;
            this.doRun();
        }

        protected abstract void doRun();
    }

    private class ClassMemberProcessor {
        @NotNull
        private final JavaClass javaClass;
        private final boolean staticMembers;

        private ClassMemberProcessor(@NotNull JavaClass javaClass, boolean staticMembers) {
            if (javaClass == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/jet/lang/resolve/java/scope/MembersCache$ClassMemberProcessor", "<init>"));
            }
            this.javaClass = javaClass;
            this.staticMembers = staticMembers;
        }

        private void process() {
            this.processFields();
            this.processMethods();
            this.processNestedClasses();
        }

        private void processFields() {
            for (final JavaField field : this.javaClass.getAllFields()) {
                MembersCache.this.addTask(field, new RunOnce(){

                    @Override
                    public void doRun() {
                        ClassMemberProcessor.this.processField(field);
                    }
                });
            }
        }

        private void processMethods() {
            this.createEntriesForAllMethods();
            this.processOwnMethods();
        }

        private void createEntriesForAllMethods() {
            for (JavaMethod method : this.javaClass.getAllMethods()) {
                MembersCache.this.getOrCreateEmpty(method);
            }
        }

        private void processOwnMethods() {
            for (final JavaMethod method : this.javaClass.getMethods()) {
                MembersCache.this.addTask(method, new RunOnce(){

                    @Override
                    public void doRun() {
                        ClassMemberProcessor.this.processOwnMethod(method);
                    }
                });
            }
        }

        private void processNestedClasses() {
            if (!this.staticMembers) {
                return;
            }
            for (final JavaClass nested : this.javaClass.getInnerClasses()) {
                MembersCache.this.addTask(nested, new RunOnce(){

                    @Override
                    public void doRun() {
                        ClassMemberProcessor.this.processNestedClass(nested);
                    }
                });
            }
        }

        private boolean includeMember(@NotNull JavaMember member) {
            if (member == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/jet/lang/resolve/java/scope/MembersCache$ClassMemberProcessor", "includeMember"));
            }
            if (this.javaClass.isEnum() && this.staticMembers) {
                return member.isStatic();
            }
            if (member.isStatic() != this.staticMembers) {
                return false;
            }
            if (!this.isInCurrentClass(member)) {
                return false;
            }
            if (member.getVisibility() == Visibilities.PRIVATE) {
                return false;
            }
            return !DescriptorResolverUtils.isObjectMethodInInterface(member);
        }

        private boolean isInCurrentClass(@NotNull JavaMember member) {
            if (member == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/jet/lang/resolve/java/scope/MembersCache$ClassMemberProcessor", "isInCurrentClass"));
            }
            FqName fqName = member.getContainingClass().getFqName();
            return fqName != null && fqName.equals(this.javaClass.getFqName());
        }

        private void processField(@NotNull JavaField field) {
            if (field == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/jet/lang/resolve/java/scope/MembersCache$ClassMemberProcessor", "processField"));
            }
            NamedMembers namedMembers = MembersCache.this.getOrCreateEmpty(field);
            if (this.includeMember(field)) {
                namedMembers.addField(field);
            }
        }

        private void processOwnMethod(@NotNull JavaMethod ownMethod) {
            if (ownMethod == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/jet/lang/resolve/java/scope/MembersCache$ClassMemberProcessor", "processOwnMethod"));
            }
            if (this.includeMember(ownMethod)) {
                MembersCache.this.getOrCreateEmpty(ownMethod).addMethod(ownMethod);
            }
        }

        private void processNestedClass(@NotNull JavaClass nested) {
            if (nested == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/jet/lang/resolve/java/scope/MembersCache$ClassMemberProcessor", "processNestedClass"));
            }
            if (SingleAbstractMethodUtils.isSamInterface(nested)) {
                MembersCache.this.getOrCreateEmpty(nested).setSamInterface(nested);
            }
        }
    }

    private class ExtraPackageMembersProcessor {
        @NotNull
        private final Collection<JavaClass> javaClasses;

        private ExtraPackageMembersProcessor(@NotNull Collection<JavaClass> javaClasses) {
            if (javaClasses == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/jet/lang/resolve/java/scope/MembersCache$ExtraPackageMembersProcessor", "<init>"));
            }
            this.javaClasses = javaClasses;
        }

        private void process() {
            for (JavaClass javaClass : this.javaClasses) {
                if (javaClass.getOriginKind() == JavaClass.OriginKind.KOTLIN_LIGHT_CLASS || !SingleAbstractMethodUtils.isSamInterface(javaClass)) continue;
                this.processSamInterface(javaClass);
            }
        }

        private void processSamInterface(@NotNull JavaClass javaClass) {
            if (javaClass == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/jet/lang/resolve/java/scope/MembersCache$ExtraPackageMembersProcessor", "processSamInterface"));
            }
            MembersCache.this.getOrCreateEmpty(javaClass).setSamInterface(javaClass);
        }
    }
}

