/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.lang.resolve.lazy.declarations;

import org.jetbrains.annotations.NotNull;
import org.jetbrains.jet.lang.psi.JetClassObject;
import org.jetbrains.jet.lang.psi.JetDeclaration;
import org.jetbrains.jet.lang.psi.JetParameter;
import org.jetbrains.jet.lang.resolve.lazy.data.JetClassLikeInfo;
import org.jetbrains.jet.lang.resolve.lazy.declarations.AbstractPsiBasedDeclarationProvider;
import org.jetbrains.jet.lang.resolve.lazy.declarations.ClassMemberDeclarationProvider;
import org.jetbrains.jet.storage.StorageManager;

public class PsiBasedClassMemberDeclarationProvider
extends AbstractPsiBasedDeclarationProvider
implements ClassMemberDeclarationProvider {
    private final JetClassLikeInfo classInfo;

    public PsiBasedClassMemberDeclarationProvider(@NotNull StorageManager storageManager, @NotNull JetClassLikeInfo classInfo) {
        if (storageManager == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/jet/lang/resolve/lazy/declarations/PsiBasedClassMemberDeclarationProvider", "<init>"));
        }
        if (classInfo == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "org/jetbrains/jet/lang/resolve/lazy/declarations/PsiBasedClassMemberDeclarationProvider", "<init>"));
        }
        super(storageManager);
        this.classInfo = classInfo;
    }

    @Override
    @NotNull
    public JetClassLikeInfo getOwnerInfo() {
        JetClassLikeInfo jetClassLikeInfo = this.classInfo;
        if (jetClassLikeInfo == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/lazy/declarations/PsiBasedClassMemberDeclarationProvider", "getOwnerInfo"));
        }
        return jetClassLikeInfo;
    }

    @Override
    protected void doCreateIndex(@NotNull AbstractPsiBasedDeclarationProvider.Index index) {
        if (index == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/jet/lang/resolve/lazy/declarations/PsiBasedClassMemberDeclarationProvider", "doCreateIndex"));
        }
        for (JetDeclaration jetDeclaration : this.classInfo.getDeclarations()) {
            if (jetDeclaration instanceof JetClassObject) continue;
            index.putToIndex(jetDeclaration);
        }
        for (JetParameter jetParameter : this.classInfo.getPrimaryConstructorParameters()) {
            if (jetParameter.getValOrVarNode() == null) continue;
            index.putToIndex(jetParameter);
        }
    }

    public String toString() {
        return "Declarations for " + this.classInfo;
    }
}

