/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.lang.resolve.lazy.descriptors;

import com.google.common.collect.Iterables;
import com.intellij.psi.NavigatablePsiElement;
import java.util.Collections;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jet.lang.descriptors.DeclarationDescriptor;
import org.jetbrains.jet.lang.descriptors.NamespaceDescriptor;
import org.jetbrains.jet.lang.descriptors.annotations.AnnotationDescriptor;
import org.jetbrains.jet.lang.descriptors.impl.AbstractNamespaceDescriptorImpl;
import org.jetbrains.jet.lang.descriptors.impl.NamespaceDescriptorParent;
import org.jetbrains.jet.lang.resolve.BindingContext;
import org.jetbrains.jet.lang.resolve.DescriptorUtils;
import org.jetbrains.jet.lang.resolve.lazy.ForceResolveUtil;
import org.jetbrains.jet.lang.resolve.lazy.LazyDescriptor;
import org.jetbrains.jet.lang.resolve.lazy.ResolveSession;
import org.jetbrains.jet.lang.resolve.lazy.declarations.PackageMemberDeclarationProvider;
import org.jetbrains.jet.lang.resolve.lazy.descriptors.LazyPackageMemberScope;
import org.jetbrains.jet.lang.resolve.name.FqName;
import org.jetbrains.jet.lang.resolve.name.Name;
import org.jetbrains.jet.lang.resolve.scopes.ChainedScope;
import org.jetbrains.jet.lang.resolve.scopes.JetScope;
import org.jetbrains.jet.lang.resolve.scopes.RedeclarationHandler;
import org.jetbrains.jet.lang.resolve.scopes.WritableScope;
import org.jetbrains.jet.lang.resolve.scopes.WritableScopeImpl;

public class LazyPackageDescriptor
extends AbstractNamespaceDescriptorImpl
implements NamespaceDescriptor,
LazyDescriptor {
    private final JetScope memberScope;
    private final JetScope lazyScope;

    public LazyPackageDescriptor(@NotNull NamespaceDescriptorParent containingDeclaration, @NotNull Name name, @NotNull ResolveSession resolveSession, @NotNull PackageMemberDeclarationProvider declarationProvider) {
        if (containingDeclaration == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/jet/lang/resolve/lazy/descriptors/LazyPackageDescriptor", "<init>"));
        }
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "org/jetbrains/jet/lang/resolve/lazy/descriptors/LazyPackageDescriptor", "<init>"));
        }
        if (resolveSession == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "org/jetbrains/jet/lang/resolve/lazy/descriptors/LazyPackageDescriptor", "<init>"));
        }
        if (declarationProvider == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "3", "org/jetbrains/jet/lang/resolve/lazy/descriptors/LazyPackageDescriptor", "<init>"));
        }
        super(containingDeclaration, Collections.<AnnotationDescriptor>emptyList(), name);
        WritableScopeImpl scope = new WritableScopeImpl(JetScope.EMPTY, this, RedeclarationHandler.DO_NOTHING, "Package scope");
        resolveSession.getRootModuleDescriptor().getModuleConfiguration().extendNamespaceScope(this, scope);
        scope.changeLockLevel(WritableScope.LockLevel.READING);
        this.lazyScope = new LazyPackageMemberScope(resolveSession, declarationProvider, this);
        this.memberScope = new ChainedScope((DeclarationDescriptor)this, "Lazy package members scope: " + name, this.lazyScope, scope);
        NavigatablePsiElement declaration = Iterables.getFirst(declarationProvider.getPackageDeclarations(this.getFqName()), null);
        if (declaration != null) {
            resolveSession.getTrace().record(BindingContext.NAMESPACE, declaration, this);
        }
    }

    @Override
    @NotNull
    public JetScope getMemberScope() {
        JetScope jetScope = this.memberScope;
        if (jetScope == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/lazy/descriptors/LazyPackageDescriptor", "getMemberScope"));
        }
        return jetScope;
    }

    @Override
    @NotNull
    public FqName getFqName() {
        FqName fqName = DescriptorUtils.getFQName(this).toSafe();
        if (fqName == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/lazy/descriptors/LazyPackageDescriptor", "getFqName"));
        }
        return fqName;
    }

    @Override
    public void addNamespace(@NotNull NamespaceDescriptor namespaceDescriptor) {
        if (namespaceDescriptor == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/jet/lang/resolve/lazy/descriptors/LazyPackageDescriptor", "addNamespace"));
        }
        throw new UnsupportedOperationException();
    }

    @Override
    public void forceResolveAllContents() {
        ForceResolveUtil.forceResolveAllContents(this.lazyScope);
    }
}

