/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.lang.resolve.lazy.descriptors;

import java.util.Collection;
import java.util.Set;
import jet.Function1;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jet.lang.descriptors.ClassifierDescriptor;
import org.jetbrains.jet.lang.descriptors.DeclarationDescriptor;
import org.jetbrains.jet.lang.descriptors.FunctionDescriptor;
import org.jetbrains.jet.lang.descriptors.NamespaceDescriptor;
import org.jetbrains.jet.lang.descriptors.ReceiverParameterDescriptor;
import org.jetbrains.jet.lang.descriptors.VariableDescriptor;
import org.jetbrains.jet.lang.descriptors.impl.NamespaceDescriptorParent;
import org.jetbrains.jet.lang.psi.JetDeclaration;
import org.jetbrains.jet.lang.psi.JetFile;
import org.jetbrains.jet.lang.resolve.DescriptorUtils;
import org.jetbrains.jet.lang.resolve.lazy.ResolveSession;
import org.jetbrains.jet.lang.resolve.lazy.declarations.PackageMemberDeclarationProvider;
import org.jetbrains.jet.lang.resolve.lazy.descriptors.AbstractLazyMemberScope;
import org.jetbrains.jet.lang.resolve.lazy.descriptors.LazyPackageDescriptor;
import org.jetbrains.jet.lang.resolve.name.FqName;
import org.jetbrains.jet.lang.resolve.name.Name;
import org.jetbrains.jet.lang.resolve.scopes.JetScope;
import org.jetbrains.jet.storage.MemoizedFunctionToNullable;

public class LazyPackageMemberScope
extends AbstractLazyMemberScope<NamespaceDescriptor, PackageMemberDeclarationProvider> {
    private final MemoizedFunctionToNullable<Name, NamespaceDescriptor> packageDescriptors;

    public LazyPackageMemberScope(@NotNull ResolveSession resolveSession, @NotNull PackageMemberDeclarationProvider declarationProvider, @NotNull NamespaceDescriptor thisPackage) {
        if (resolveSession == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/jet/lang/resolve/lazy/descriptors/LazyPackageMemberScope", "<init>"));
        }
        if (declarationProvider == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "org/jetbrains/jet/lang/resolve/lazy/descriptors/LazyPackageMemberScope", "<init>"));
        }
        if (thisPackage == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "org/jetbrains/jet/lang/resolve/lazy/descriptors/LazyPackageMemberScope", "<init>"));
        }
        super(resolveSession, declarationProvider, thisPackage);
        this.packageDescriptors = resolveSession.getStorageManager().createMemoizedFunctionWithNullableValues(new Function1<Name, NamespaceDescriptor>(){

            @Override
            public NamespaceDescriptor invoke(Name name) {
                return LazyPackageMemberScope.this.createPackageDescriptor(name);
            }
        });
    }

    @Override
    public NamespaceDescriptor getNamespace(@NotNull Name name) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/jet/lang/resolve/lazy/descriptors/LazyPackageMemberScope", "getNamespace"));
        }
        return this.packageDescriptors.invoke(name);
    }

    @Nullable
    public NamespaceDescriptor createPackageDescriptor(@NotNull Name name) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/jet/lang/resolve/lazy/descriptors/LazyPackageMemberScope", "createPackageDescriptor"));
        }
        if (!((PackageMemberDeclarationProvider)this.declarationProvider).isPackageDeclared(name)) {
            return null;
        }
        PackageMemberDeclarationProvider packageMemberDeclarationProvider = this.resolveSession.getDeclarationProviderFactory().getPackageMemberDeclarationProvider(DescriptorUtils.getFQName(this.thisDescriptor).child(name).toSafe());
        assert (packageMemberDeclarationProvider != null) : "Package is declared, but declaration provider is not found: " + name;
        return new LazyPackageDescriptor((NamespaceDescriptorParent)this.thisDescriptor, name, this.resolveSession, packageMemberDeclarationProvider);
    }

    @Override
    public ClassifierDescriptor getClassifier(@NotNull Name name) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/jet/lang/resolve/lazy/descriptors/LazyPackageMemberScope", "getClassifier"));
        }
        Name actualName = this.resolveSession.resolveClassifierAlias(DescriptorUtils.getFQName(this.thisDescriptor).toSafe(), name);
        return super.getClassifier(actualName);
    }

    @Override
    @NotNull
    protected JetScope getScopeForMemberDeclarationResolution(JetDeclaration declaration) {
        JetScope jetScope = this.resolveSession.getInjector().getScopeProvider().getFileScope((JetFile)declaration.getContainingFile());
        if (jetScope == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/lazy/descriptors/LazyPackageMemberScope", "getScopeForMemberDeclarationResolution"));
        }
        return jetScope;
    }

    @Override
    protected ReceiverParameterDescriptor getImplicitReceiver() {
        return ReceiverParameterDescriptor.NO_RECEIVER_PARAMETER;
    }

    @Override
    protected void getNonDeclaredFunctions(@NotNull Name name, @NotNull Set<FunctionDescriptor> result) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/jet/lang/resolve/lazy/descriptors/LazyPackageMemberScope", "getNonDeclaredFunctions"));
        }
        if (result == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "org/jetbrains/jet/lang/resolve/lazy/descriptors/LazyPackageMemberScope", "getNonDeclaredFunctions"));
        }
    }

    @Override
    protected void getNonDeclaredProperties(@NotNull Name name, @NotNull Set<VariableDescriptor> result) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/jet/lang/resolve/lazy/descriptors/LazyPackageMemberScope", "getNonDeclaredProperties"));
        }
        if (result == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "org/jetbrains/jet/lang/resolve/lazy/descriptors/LazyPackageMemberScope", "getNonDeclaredProperties"));
        }
    }

    @Override
    protected void addExtraDescriptors(@NotNull Collection<DeclarationDescriptor> result) {
        if (result == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/jet/lang/resolve/lazy/descriptors/LazyPackageMemberScope", "addExtraDescriptors"));
        }
        for (FqName packageFqName : ((PackageMemberDeclarationProvider)this.declarationProvider).getAllDeclaredPackages()) {
            result.add(this.getNamespace(packageFqName.shortName()));
        }
    }

    @Override
    public String toString() {
        return "lazy scope for package " + ((NamespaceDescriptor)this.thisDescriptor).getName();
    }
}

