/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.lang.resolve.scopes;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jet.lang.descriptors.ClassDescriptor;
import org.jetbrains.jet.lang.descriptors.ClassifierDescriptor;
import org.jetbrains.jet.lang.descriptors.FunctionDescriptor;
import org.jetbrains.jet.lang.descriptors.NamespaceDescriptor;
import org.jetbrains.jet.lang.descriptors.ReceiverParameterDescriptor;
import org.jetbrains.jet.lang.descriptors.VariableDescriptor;
import org.jetbrains.jet.lang.resolve.name.Name;
import org.jetbrains.jet.lang.resolve.scopes.JetScope;
import org.jetbrains.jet.lang.resolve.scopes.JetScopeAdapter;
import org.jetbrains.jet.lang.resolve.scopes.RedeclarationHandler;
import org.jetbrains.jet.lang.resolve.scopes.WritableScope;
import org.jetbrains.jet.lang.resolve.scopes.WritableScopeImpl;

public abstract class WritableScopeWithImports
extends JetScopeAdapter
implements WritableScope {
    @NotNull
    private final String debugName;
    @Nullable
    private List<JetScope> imports;
    private WritableScope currentIndividualImportScope;
    protected final RedeclarationHandler redeclarationHandler;
    private List<ReceiverParameterDescriptor> implicitReceiverHierarchy;
    private WritableScope.LockLevel lockLevel;

    public WritableScopeWithImports(@NotNull JetScope scope, @NotNull RedeclarationHandler redeclarationHandler, @NotNull String debugName) {
        if (scope == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/jet/lang/resolve/scopes/WritableScopeWithImports", "<init>"));
        }
        if (redeclarationHandler == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "org/jetbrains/jet/lang/resolve/scopes/WritableScopeWithImports", "<init>"));
        }
        if (debugName == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "org/jetbrains/jet/lang/resolve/scopes/WritableScopeWithImports", "<init>"));
        }
        super(scope);
        this.lockLevel = WritableScope.LockLevel.WRITING;
        this.redeclarationHandler = redeclarationHandler;
        this.debugName = debugName;
    }

    @Override
    public WritableScope changeLockLevel(WritableScope.LockLevel lockLevel) {
        if (lockLevel.ordinal() < this.lockLevel.ordinal()) {
            throw new IllegalStateException("cannot lower lock level from " + (Object)((Object)this.lockLevel) + " to " + (Object)((Object)lockLevel) + " at " + this.toString());
        }
        this.lockLevel = lockLevel;
        return this;
    }

    protected void checkMayRead() {
        if (this.lockLevel != WritableScope.LockLevel.READING && this.lockLevel != WritableScope.LockLevel.BOTH) {
            throw new IllegalStateException("cannot read with lock level " + (Object)((Object)this.lockLevel) + " at " + this.toString());
        }
    }

    protected void checkMayWrite() {
        if (this.lockLevel != WritableScope.LockLevel.WRITING && this.lockLevel != WritableScope.LockLevel.BOTH) {
            throw new IllegalStateException("cannot write with lock level " + (Object)((Object)this.lockLevel) + " at " + this.toString());
        }
    }

    protected void checkMayNotWrite() {
        if (this.lockLevel == WritableScope.LockLevel.WRITING || this.lockLevel == WritableScope.LockLevel.BOTH) {
            throw new IllegalStateException("cannot write with lock level " + (Object)((Object)this.lockLevel) + " at " + this.toString());
        }
    }

    @NotNull
    protected final List<JetScope> getImports() {
        if (this.imports == null) {
            this.imports = new ArrayList<JetScope>();
        }
        List<JetScope> list2 = this.imports;
        if (list2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/scopes/WritableScopeWithImports", "getImports"));
        }
        return list2;
    }

    @Override
    public void importScope(@NotNull JetScope imported) {
        if (imported == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/jet/lang/resolve/scopes/WritableScopeWithImports", "importScope"));
        }
        if (imported == this) {
            throw new IllegalStateException("cannot import scope into self");
        }
        this.checkMayWrite();
        this.getImports().add(0, imported);
        this.currentIndividualImportScope = null;
    }

    @Override
    @NotNull
    public List<ReceiverParameterDescriptor> getImplicitReceiversHierarchy() {
        this.checkMayRead();
        if (this.implicitReceiverHierarchy == null) {
            this.implicitReceiverHierarchy = this.computeImplicitReceiversHierarchy();
        }
        List<ReceiverParameterDescriptor> list2 = this.implicitReceiverHierarchy;
        if (list2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/scopes/WritableScopeWithImports", "getImplicitReceiversHierarchy"));
        }
        return list2;
    }

    protected List<ReceiverParameterDescriptor> computeImplicitReceiversHierarchy() {
        ArrayList<ReceiverParameterDescriptor> implicitReceiverHierarchy = Lists.newArrayList();
        for (JetScope scope : this.getImports()) {
            implicitReceiverHierarchy.addAll(scope.getImplicitReceiversHierarchy());
        }
        implicitReceiverHierarchy.addAll(super.getImplicitReceiversHierarchy());
        return implicitReceiverHierarchy;
    }

    @NotNull
    public Set<VariableDescriptor> getProperties(@NotNull Name name) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/jet/lang/resolve/scopes/WritableScopeWithImports", "getProperties"));
        }
        this.checkMayRead();
        LinkedHashSet<VariableDescriptor> properties = Sets.newLinkedHashSet();
        for (JetScope imported : this.getImports()) {
            properties.addAll(imported.getProperties(name));
        }
        LinkedHashSet<VariableDescriptor> linkedHashSet = properties;
        if (linkedHashSet == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/scopes/WritableScopeWithImports", "getProperties"));
        }
        return linkedHashSet;
    }

    @Override
    public VariableDescriptor getLocalVariable(@NotNull Name name) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/jet/lang/resolve/scopes/WritableScopeWithImports", "getLocalVariable"));
        }
        this.checkMayRead();
        for (JetScope imported : this.getImports()) {
            VariableDescriptor importedDescriptor = imported.getLocalVariable(name);
            if (importedDescriptor == null) continue;
            return importedDescriptor;
        }
        return null;
    }

    @Override
    @NotNull
    public Collection<FunctionDescriptor> getFunctions(@NotNull Name name) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/jet/lang/resolve/scopes/WritableScopeWithImports", "getFunctions"));
        }
        this.checkMayRead();
        if (this.getImports().isEmpty()) {
            Set<FunctionDescriptor> set = Collections.emptySet();
            if (set == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/scopes/WritableScopeWithImports", "getFunctions"));
            }
            return set;
        }
        LinkedHashSet<FunctionDescriptor> result = Sets.newLinkedHashSet();
        for (JetScope imported : this.getImports()) {
            result.addAll(imported.getFunctions(name));
        }
        LinkedHashSet<FunctionDescriptor> linkedHashSet = result;
        if (linkedHashSet == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/scopes/WritableScopeWithImports", "getFunctions"));
        }
        return linkedHashSet;
    }

    @Override
    public ClassifierDescriptor getClassifier(@NotNull Name name) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/jet/lang/resolve/scopes/WritableScopeWithImports", "getClassifier"));
        }
        this.checkMayRead();
        for (JetScope imported : this.getImports()) {
            ClassifierDescriptor importedClassifier = imported.getClassifier(name);
            if (importedClassifier == null) continue;
            return importedClassifier;
        }
        return null;
    }

    @Override
    public ClassDescriptor getObjectDescriptor(@NotNull Name name) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/jet/lang/resolve/scopes/WritableScopeWithImports", "getObjectDescriptor"));
        }
        this.checkMayRead();
        for (JetScope imported : this.getImports()) {
            ClassDescriptor objectDescriptor = imported.getObjectDescriptor(name);
            if (objectDescriptor == null) continue;
            return objectDescriptor;
        }
        return null;
    }

    @Override
    public NamespaceDescriptor getNamespace(@NotNull Name name) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/jet/lang/resolve/scopes/WritableScopeWithImports", "getNamespace"));
        }
        this.checkMayRead();
        for (JetScope imported : this.getImports()) {
            NamespaceDescriptor importedDescriptor = imported.getNamespace(name);
            if (importedDescriptor == null) continue;
            return importedDescriptor;
        }
        return null;
    }

    private WritableScope getCurrentIndividualImportScope() {
        if (this.currentIndividualImportScope == null) {
            WritableScopeImpl writableScope = new WritableScopeImpl(EMPTY, this.getContainingDeclaration(), RedeclarationHandler.DO_NOTHING, "Individual import scope");
            writableScope.changeLockLevel(WritableScope.LockLevel.BOTH);
            this.importScope(writableScope);
            this.currentIndividualImportScope = writableScope;
        }
        return this.currentIndividualImportScope;
    }

    @Override
    public void importClassifierAlias(@NotNull Name importedClassifierName, @NotNull ClassifierDescriptor classifierDescriptor) {
        if (importedClassifierName == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/jet/lang/resolve/scopes/WritableScopeWithImports", "importClassifierAlias"));
        }
        if (classifierDescriptor == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "org/jetbrains/jet/lang/resolve/scopes/WritableScopeWithImports", "importClassifierAlias"));
        }
        this.checkMayWrite();
        this.getCurrentIndividualImportScope().addClassifierAlias(importedClassifierName, classifierDescriptor);
    }

    @Override
    public void importNamespaceAlias(@NotNull Name aliasName, @NotNull NamespaceDescriptor namespaceDescriptor) {
        if (aliasName == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/jet/lang/resolve/scopes/WritableScopeWithImports", "importNamespaceAlias"));
        }
        if (namespaceDescriptor == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "org/jetbrains/jet/lang/resolve/scopes/WritableScopeWithImports", "importNamespaceAlias"));
        }
        this.checkMayWrite();
        this.getCurrentIndividualImportScope().addNamespaceAlias(aliasName, namespaceDescriptor);
    }

    @Override
    public void importFunctionAlias(@NotNull Name aliasName, @NotNull FunctionDescriptor functionDescriptor) {
        if (aliasName == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/jet/lang/resolve/scopes/WritableScopeWithImports", "importFunctionAlias"));
        }
        if (functionDescriptor == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "org/jetbrains/jet/lang/resolve/scopes/WritableScopeWithImports", "importFunctionAlias"));
        }
        this.checkMayWrite();
        this.getCurrentIndividualImportScope().addFunctionAlias(aliasName, functionDescriptor);
    }

    @Override
    public void importVariableAlias(@NotNull Name aliasName, @NotNull VariableDescriptor variableDescriptor) {
        if (aliasName == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/jet/lang/resolve/scopes/WritableScopeWithImports", "importVariableAlias"));
        }
        if (variableDescriptor == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "org/jetbrains/jet/lang/resolve/scopes/WritableScopeWithImports", "importVariableAlias"));
        }
        this.checkMayWrite();
        this.getCurrentIndividualImportScope().addVariableAlias(aliasName, variableDescriptor);
    }

    @Override
    public void clearImports() {
        this.currentIndividualImportScope = null;
        this.getImports().clear();
    }

    public String toString() {
        return this.getClass().getSimpleName() + "@" + Integer.toHexString(System.identityHashCode(this)) + " " + this.debugName + " for " + this.getContainingDeclaration();
    }
}

