/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.utils;

import java.io.IOException;
import java.util.Collection;
import java.util.Iterator;
import org.jetbrains.annotations.NotNull;

public class Printer {
    private static final String LINE_SEPARATOR = System.getProperty("line.separator");
    private final Appendable out;
    private final int maxBlankLines;
    private String indent;
    private int blankLineCountIncludingCurrent;

    public Printer(@NotNull Appendable out) {
        if (out == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/jet/utils/Printer", "<init>"));
        }
        this(out, Integer.MAX_VALUE);
    }

    public Printer(@NotNull Appendable out, int maxBlankLines) {
        if (out == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/jet/utils/Printer", "<init>"));
        }
        this.indent = "";
        this.blankLineCountIncludingCurrent = 0;
        this.out = out;
        this.maxBlankLines = maxBlankLines;
    }

    private void append(Object o) {
        try {
            this.out.append(o.toString());
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @NotNull
    public Printer println(Object ... objects) {
        this.print(objects);
        this.printLineSeparator();
        Printer printer = this;
        if (printer == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/utils/Printer", "println"));
        }
        return printer;
    }

    private void printLineSeparator() {
        if (this.blankLineCountIncludingCurrent <= this.maxBlankLines) {
            ++this.blankLineCountIncludingCurrent;
            this.append(LINE_SEPARATOR);
        }
    }

    @NotNull
    public Printer print(Object ... objects) {
        this.append(this.indent);
        this.printWithNoIndent(objects);
        Printer printer = this;
        if (printer == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/utils/Printer", "print"));
        }
        return printer;
    }

    @NotNull
    public Printer printWithNoIndent(Object ... objects) {
        for (Object object2 : objects) {
            this.blankLineCountIncludingCurrent = 0;
            this.append(object2);
        }
        Printer printer = this;
        if (printer == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/utils/Printer", "printWithNoIndent"));
        }
        return printer;
    }

    @NotNull
    public Printer printlnWithNoIndent(Object ... objects) {
        this.printWithNoIndent(objects);
        this.printLineSeparator();
        Printer printer = this;
        if (printer == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/utils/Printer", "printlnWithNoIndent"));
        }
        return printer;
    }

    @NotNull
    public Printer pushIndent() {
        this.indent = this.indent + "    ";
        Printer printer = this;
        if (printer == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/utils/Printer", "pushIndent"));
        }
        return printer;
    }

    @NotNull
    public Printer popIndent() {
        if (this.indent.length() < "    ".length()) {
            throw new IllegalStateException("No indentation to pop");
        }
        this.indent = this.indent.substring("    ".length());
        Printer printer = this;
        if (printer == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/utils/Printer", "popIndent"));
        }
        return printer;
    }

    @NotNull
    public Printer separated(Object separator, Object ... items) {
        for (int i = 0; i < items.length; ++i) {
            if (i > 0) {
                this.printlnWithNoIndent(separator);
            }
            this.printlnWithNoIndent(items[i]);
        }
        Printer printer = this;
        if (printer == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/utils/Printer", "separated"));
        }
        return printer;
    }

    @NotNull
    public Printer separated(Object separator, Collection<?> items) {
        Iterator<?> iterator2 = items.iterator();
        while (iterator2.hasNext()) {
            this.printlnWithNoIndent(iterator2.next());
            if (!iterator2.hasNext()) continue;
            this.printlnWithNoIndent(separator);
        }
        Printer printer = this;
        if (printer == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/utils/Printer", "separated"));
        }
        return printer;
    }
}

