/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.k2js.translate.declaration;

import com.google.dart.compiler.backend.js.ast.JsBlock;
import com.google.dart.compiler.backend.js.ast.JsExpressionImpl;
import com.google.dart.compiler.backend.js.ast.JsFunction;
import com.google.dart.compiler.backend.js.ast.JsInvocation;
import com.google.dart.compiler.backend.js.ast.JsName;
import com.google.dart.compiler.backend.js.ast.JsNameRef;
import com.google.dart.compiler.backend.js.ast.JsObjectLiteral;
import com.google.dart.compiler.backend.js.ast.JsPropertyInitializer;
import com.google.dart.compiler.backend.js.ast.JsReturn;
import com.google.dart.compiler.backend.js.ast.JsVars;
import com.intellij.util.SmartList;
import gnu.trove.THashMap;
import gnu.trove.THashSet;
import gnu.trove.TObjectObjectProcedure;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jet.lang.descriptors.ClassDescriptor;
import org.jetbrains.jet.lang.descriptors.DeclarationDescriptor;
import org.jetbrains.jet.lang.descriptors.Modality;
import org.jetbrains.jet.lang.psi.JetClass;
import org.jetbrains.jet.lang.psi.JetClassOrObject;
import org.jetbrains.jet.lang.resolve.DescriptorUtils;
import org.jetbrains.jet.lang.types.JetType;
import org.jetbrains.jet.utils.DFS;
import org.jetbrains.k2js.translate.context.Namer;
import org.jetbrains.k2js.translate.context.TranslationContext;
import org.jetbrains.k2js.translate.declaration.ClassAliasingMap;
import org.jetbrains.k2js.translate.declaration.ClassTranslator;
import org.jetbrains.k2js.translate.general.AbstractTranslator;
import org.jetbrains.k2js.translate.utils.BindingUtils;

public final class ClassDeclarationTranslator
extends AbstractTranslator {
    private final THashSet<String> nameClashGuard;
    @NotNull
    private final THashMap<ClassDescriptor, OpenClassInfo> openClassDescriptorToItem;
    private final LinkedList<OpenClassInfo> openList;
    @NotNull
    private final ClassDescriptorToLabel classDescriptorToLabel;
    private final THashMap<ClassDescriptor, JsNameRef> openClassDescriptorToQualifiedLabel;
    private final ClassAliasingMap classDescriptorToQualifiedLabel;
    @NotNull
    private final JsFunction dummyFunction;
    private final JsNameRef declarationsObjectRef;
    private final JsVars.JsVar classesVar;

    public ClassDeclarationTranslator(@NotNull TranslationContext context) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/k2js/translate/declaration/ClassDeclarationTranslator", "<init>"));
        }
        super(context);
        this.nameClashGuard = new THashSet();
        this.openClassDescriptorToItem = new THashMap();
        this.openList = new LinkedList();
        this.classDescriptorToLabel = new ClassDescriptorToLabel();
        this.openClassDescriptorToQualifiedLabel = new THashMap();
        this.classDescriptorToQualifiedLabel = new ClassAliasingMap(){

            @Override
            @NotNull
            public JsNameRef get(ClassDescriptor descriptor, ClassDescriptor referencedDescriptor) {
                JsNameRef ref = (JsNameRef)ClassDeclarationTranslator.this.openClassDescriptorToQualifiedLabel.get(descriptor);
                if (ref != null) {
                    JsNameRef jsNameRef = ref;
                    if (jsNameRef == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/k2js/translate/declaration/ClassDeclarationTranslator$1", "get"));
                    }
                    return jsNameRef;
                }
                ref = new JsNameRef("<unresolved class>");
                ClassDeclarationTranslator.this.openClassDescriptorToQualifiedLabel.put(descriptor, ref);
                JsNameRef jsNameRef = ref;
                if (jsNameRef == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/k2js/translate/declaration/ClassDeclarationTranslator$1", "get"));
                }
                return jsNameRef;
            }
        };
        this.dummyFunction = new JsFunction(context.scope());
        JsName declarationsObject = this.context().scope().declareName(Namer.nameForClassesVariable());
        this.classesVar = new JsVars.JsVar(declarationsObject);
        this.declarationsObjectRef = declarationsObject.makeRef();
    }

    @NotNull
    public JsVars.JsVar getDeclaration() {
        JsVars.JsVar jsVar = this.classesVar;
        if (jsVar == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/k2js/translate/declaration/ClassDeclarationTranslator", "getDeclaration"));
        }
        return jsVar;
    }

    public void generateDeclarations() {
        SmartList<JsVars.JsVar> vars = new SmartList<JsVars.JsVar>();
        SmartList<JsPropertyInitializer> propertyInitializers = new SmartList<JsPropertyInitializer>();
        this.generateOpenClassDeclarations(vars, propertyInitializers);
        this.fixUnresolvedClassReferences();
        if (vars.isEmpty()) {
            if (!propertyInitializers.isEmpty()) {
                this.classesVar.setInitExpression(new JsObjectLiteral(propertyInitializers, true));
            }
            return;
        }
        this.dummyFunction.setBody(new JsBlock(new JsVars(vars, true), new JsReturn(new JsObjectLiteral(propertyInitializers))));
        this.classesVar.setInitExpression(new JsInvocation(this.dummyFunction));
    }

    private void generateOpenClassDeclarations(@NotNull List<JsVars.JsVar> vars, @NotNull List<JsPropertyInitializer> propertyInitializers) {
        if (vars == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/k2js/translate/declaration/ClassDeclarationTranslator", "generateOpenClassDeclarations"));
        }
        if (propertyInitializers == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "org/jetbrains/k2js/translate/declaration/ClassDeclarationTranslator", "generateOpenClassDeclarations"));
        }
        LinkedList sortedOpenClasses = (LinkedList)DFS.topologicalOrder(this.openList, new DFS.Neighbors<OpenClassInfo>(){

            @Override
            @NotNull
            public Iterable<OpenClassInfo> getNeighbors(OpenClassInfo current) {
                LinkedList<OpenClassInfo> parents = new LinkedList<OpenClassInfo>();
                ClassDescriptor classDescriptor = BindingUtils.getClassDescriptor(ClassDeclarationTranslator.this.context().bindingContext(), current.declaration);
                Collection<JetType> superTypes = classDescriptor.getTypeConstructor().getSupertypes();
                for (JetType type : superTypes) {
                    ClassDescriptor descriptor = DescriptorUtils.getClassDescriptorForType(type);
                    OpenClassInfo item = (OpenClassInfo)ClassDeclarationTranslator.this.openClassDescriptorToItem.get(descriptor);
                    if (item == null) continue;
                    item.referencedFromOpenClass = true;
                    parents.add(item);
                }
                LinkedList<OpenClassInfo> linkedList = parents;
                if (linkedList == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/k2js/translate/declaration/ClassDeclarationTranslator$2", "getNeighbors"));
                }
                return linkedList;
            }
        });
        assert (sortedOpenClasses.size() == this.openList.size());
        Iterator it = sortedOpenClasses.descendingIterator();
        while (it.hasNext()) {
            JsExpressionImpl value;
            OpenClassInfo item = (OpenClassInfo)it.next();
            JsInvocation translatedDeclaration = new ClassTranslator(item.declaration, item.descriptor, this.classDescriptorToLabel, this.context()).translate();
            if (item.referencedFromOpenClass) {
                vars.add(new JsVars.JsVar(item.label.getName(), translatedDeclaration));
                value = item.label;
            } else {
                value = translatedDeclaration;
            }
            propertyInitializers.add(new JsPropertyInitializer(item.label, value));
        }
    }

    private void fixUnresolvedClassReferences() {
        this.openClassDescriptorToQualifiedLabel.forEachEntry(new TObjectObjectProcedure<ClassDescriptor, JsNameRef>(){

            @Override
            public boolean execute(ClassDescriptor descriptor, JsNameRef ref) {
                if (ref.getName() == null) {
                    ref.resolve(ClassDeclarationTranslator.this.context().getNameForDescriptor(descriptor));
                    ref.setQualifier(ClassDeclarationTranslator.this.context().getQualifierForDescriptor(descriptor));
                }
                return true;
            }
        });
    }

    private String createNameForClass(ClassDescriptor descriptor) {
        String suggestedName;
        String name = suggestedName = descriptor.getName().asString();
        DeclarationDescriptor containing = descriptor;
        while (!this.nameClashGuard.add(name)) {
            containing = containing.getContainingDeclaration();
            assert (containing != null);
            name = suggestedName + '_' + containing.getName().asString();
        }
        return name;
    }

    @Nullable
    public JsNameRef getQualifiedReference(ClassDescriptor descriptor) {
        if (descriptor.getModality() != Modality.FINAL) {
            return this.classDescriptorToQualifiedLabel.get(descriptor, null);
        }
        return null;
    }

    @Nullable
    public JsPropertyInitializer translate(@NotNull JetClassOrObject declaration, TranslationContext context) {
        JsExpressionImpl value;
        if (declaration == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/k2js/translate/declaration/ClassDeclarationTranslator", "translate"));
        }
        ClassDescriptor descriptor = BindingUtils.getClassDescriptor(this.context().bindingContext(), declaration);
        if (descriptor.getModality() == Modality.FINAL) {
            value = new ClassTranslator(declaration, this.classDescriptorToQualifiedLabel, context).translate();
        } else {
            String label = this.createNameForClass(descriptor);
            JsName name = this.dummyFunction.getScope().declareName(label);
            JsNameRef qualifiedLabel = this.openClassDescriptorToQualifiedLabel.get(descriptor);
            if (qualifiedLabel == null) {
                qualifiedLabel = new JsNameRef(name);
                this.openClassDescriptorToQualifiedLabel.put(descriptor, qualifiedLabel);
            } else {
                qualifiedLabel.resolve(name);
            }
            qualifiedLabel.setQualifier(this.declarationsObjectRef);
            OpenClassInfo item = new OpenClassInfo((JetClass)declaration, descriptor, name.makeRef());
            this.openList.add(item);
            this.openClassDescriptorToItem.put(descriptor, item);
            value = qualifiedLabel;
            if (!descriptor.getVisibility().isPublicAPI()) {
                return null;
            }
        }
        return new JsPropertyInitializer(context.getNameForDescriptor(descriptor).makeRef(), value);
    }

    private static class OpenClassInfo {
        private final ClassDescriptor descriptor;
        private final JetClass declaration;
        private final JsNameRef label;
        private boolean referencedFromOpenClass = false;

        private OpenClassInfo(JetClass declaration, ClassDescriptor descriptor, JsNameRef label) {
            this.descriptor = descriptor;
            this.declaration = declaration;
            this.label = label;
        }
    }

    private final class ClassDescriptorToLabel
    implements ClassAliasingMap {
        private ClassDescriptorToLabel() {
        }

        @Override
        @Nullable
        public JsNameRef get(ClassDescriptor descriptor, ClassDescriptor referencedDescriptor) {
            OpenClassInfo item = (OpenClassInfo)ClassDeclarationTranslator.this.openClassDescriptorToItem.get(descriptor);
            if (item == null) {
                return null;
            }
            return item.label;
        }
    }
}

