/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.k2js.translate.reference;

import com.google.dart.compiler.backend.js.ast.JsExpression;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jet.lang.psi.JetArrayAccessExpression;
import org.jetbrains.jet.lang.psi.JetExpression;
import org.jetbrains.jet.lang.psi.JetQualifiedExpression;
import org.jetbrains.jet.lang.psi.JetReferenceExpression;
import org.jetbrains.jet.lang.psi.JetSimpleNameExpression;
import org.jetbrains.k2js.translate.context.TranslationContext;
import org.jetbrains.k2js.translate.reference.AccessTranslator;
import org.jetbrains.k2js.translate.reference.ArrayAccessTranslator;
import org.jetbrains.k2js.translate.reference.CachedAccessTranslator;
import org.jetbrains.k2js.translate.reference.QualifiedExpressionTranslator;
import org.jetbrains.k2js.translate.reference.ReferenceTranslator;

public final class AccessTranslationUtils {
    private AccessTranslationUtils() {
    }

    @NotNull
    public static AccessTranslator getAccessTranslator(@NotNull JetExpression referenceExpression, @NotNull TranslationContext context) {
        if (referenceExpression == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/k2js/translate/reference/AccessTranslationUtils", "getAccessTranslator"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "org/jetbrains/k2js/translate/reference/AccessTranslationUtils", "getAccessTranslator"));
        }
        assert (referenceExpression instanceof JetReferenceExpression || referenceExpression instanceof JetQualifiedExpression);
        if (referenceExpression instanceof JetQualifiedExpression) {
            AccessTranslator accessTranslator = QualifiedExpressionTranslator.getAccessTranslator((JetQualifiedExpression)referenceExpression, context);
            if (accessTranslator == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/k2js/translate/reference/AccessTranslationUtils", "getAccessTranslator"));
            }
            return accessTranslator;
        }
        if (referenceExpression instanceof JetSimpleNameExpression) {
            AccessTranslator accessTranslator = ReferenceTranslator.getAccessTranslator((JetSimpleNameExpression)referenceExpression, context);
            if (accessTranslator == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/k2js/translate/reference/AccessTranslationUtils", "getAccessTranslator"));
            }
            return accessTranslator;
        }
        assert (referenceExpression instanceof JetArrayAccessExpression);
        ArrayAccessTranslator arrayAccessTranslator = ArrayAccessTranslator.newInstance((JetArrayAccessExpression)referenceExpression, context);
        if (arrayAccessTranslator == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/k2js/translate/reference/AccessTranslationUtils", "getAccessTranslator"));
        }
        return arrayAccessTranslator;
    }

    @NotNull
    public static CachedAccessTranslator getCachedAccessTranslator(@NotNull JetExpression referenceExpression, @NotNull TranslationContext context) {
        if (referenceExpression == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/k2js/translate/reference/AccessTranslationUtils", "getCachedAccessTranslator"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "org/jetbrains/k2js/translate/reference/AccessTranslationUtils", "getCachedAccessTranslator"));
        }
        CachedAccessTranslator cachedAccessTranslator = AccessTranslationUtils.getAccessTranslator(referenceExpression, context).getCached();
        if (cachedAccessTranslator == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/k2js/translate/reference/AccessTranslationUtils", "getCachedAccessTranslator"));
        }
        return cachedAccessTranslator;
    }

    @NotNull
    public static JsExpression translateAsGet(@NotNull JetExpression expression, @NotNull TranslationContext context) {
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/k2js/translate/reference/AccessTranslationUtils", "translateAsGet"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "org/jetbrains/k2js/translate/reference/AccessTranslationUtils", "translateAsGet"));
        }
        JsExpression jsExpression = AccessTranslationUtils.getAccessTranslator(expression, context).translateAsGet();
        if (jsExpression == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/k2js/translate/reference/AccessTranslationUtils", "translateAsGet"));
        }
        return jsExpression;
    }
}

