/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.k2js.translate.reference;

import com.google.dart.compiler.backend.js.ast.JsExpression;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jet.lang.descriptors.CallableDescriptor;
import org.jetbrains.jet.lang.descriptors.ReceiverParameterDescriptor;
import org.jetbrains.jet.lang.resolve.BindingTraceContext;
import org.jetbrains.jet.lang.resolve.TemporaryBindingTrace;
import org.jetbrains.jet.lang.resolve.calls.model.MutableDataFlowInfoForArguments;
import org.jetbrains.jet.lang.resolve.calls.model.ResolvedCall;
import org.jetbrains.jet.lang.resolve.calls.model.ResolvedCallImpl;
import org.jetbrains.jet.lang.resolve.calls.tasks.ExplicitReceiverKind;
import org.jetbrains.jet.lang.resolve.calls.tasks.ResolutionCandidate;
import org.jetbrains.jet.lang.resolve.calls.tasks.TracingStrategy;
import org.jetbrains.jet.lang.resolve.scopes.receivers.ReceiverValue;
import org.jetbrains.k2js.translate.context.TranslationContext;
import org.jetbrains.k2js.translate.reference.CallTranslator;
import org.jetbrains.k2js.translate.reference.CallType;

public final class CallBuilder {
    @NotNull
    private final TranslationContext context;
    @Nullable
    private JsExpression receiver;
    @NotNull
    private List<JsExpression> args;
    @NotNull
    private CallType callType;
    @Nullable
    private ResolvedCall<?> resolvedCall;
    @Nullable
    private CallableDescriptor descriptor;
    @Nullable
    private JsExpression callee;

    public static CallBuilder build(@NotNull TranslationContext context) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/k2js/translate/reference/CallBuilder", "build"));
        }
        return new CallBuilder(context);
    }

    private CallBuilder(@NotNull TranslationContext context) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/k2js/translate/reference/CallBuilder", "<init>"));
        }
        this.receiver = null;
        this.args = Collections.emptyList();
        this.callType = CallType.NORMAL;
        this.resolvedCall = null;
        this.descriptor = null;
        this.callee = null;
        this.context = context;
    }

    @NotNull
    public CallBuilder receiver(@Nullable JsExpression receiver) {
        this.receiver = receiver;
        CallBuilder callBuilder = this;
        if (callBuilder == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/k2js/translate/reference/CallBuilder", "receiver"));
        }
        return callBuilder;
    }

    @NotNull
    public CallBuilder args(@NotNull List<JsExpression> args) {
        if (args == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/k2js/translate/reference/CallBuilder", "args"));
        }
        assert (this.args == Collections.EMPTY_LIST);
        this.args = args;
        CallBuilder callBuilder = this;
        if (callBuilder == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/k2js/translate/reference/CallBuilder", "args"));
        }
        return callBuilder;
    }

    @NotNull
    public CallBuilder args(JsExpression ... args) {
        if (args == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/k2js/translate/reference/CallBuilder", "args"));
        }
        CallBuilder callBuilder = this.args(Arrays.asList(args));
        if (callBuilder == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/k2js/translate/reference/CallBuilder", "args"));
        }
        return callBuilder;
    }

    @NotNull
    public CallBuilder descriptor(@NotNull CallableDescriptor descriptor) {
        if (descriptor == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/k2js/translate/reference/CallBuilder", "descriptor"));
        }
        this.descriptor = descriptor;
        CallBuilder callBuilder = this;
        if (callBuilder == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/k2js/translate/reference/CallBuilder", "descriptor"));
        }
        return callBuilder;
    }

    @NotNull
    public CallBuilder callee(@Nullable JsExpression callee) {
        this.callee = callee;
        CallBuilder callBuilder = this;
        if (callBuilder == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/k2js/translate/reference/CallBuilder", "callee"));
        }
        return callBuilder;
    }

    @NotNull
    public CallBuilder resolvedCall(@NotNull ResolvedCall<?> call) {
        if (call == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/k2js/translate/reference/CallBuilder", "resolvedCall"));
        }
        this.resolvedCall = call;
        CallBuilder callBuilder = this;
        if (callBuilder == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/k2js/translate/reference/CallBuilder", "resolvedCall"));
        }
        return callBuilder;
    }

    @NotNull
    public CallBuilder type(@NotNull CallType type) {
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/k2js/translate/reference/CallBuilder", "type"));
        }
        this.callType = type;
        CallBuilder callBuilder = this;
        if (callBuilder == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/k2js/translate/reference/CallBuilder", "type"));
        }
        return callBuilder;
    }

    @NotNull
    private CallTranslator finish() {
        if (this.resolvedCall == null) {
            assert (this.descriptor != null);
            this.resolvedCall = ResolvedCallImpl.create(ResolutionCandidate.create(this.descriptor, CallBuilder.safeGetValue(this.descriptor.getExpectedThisObject()), CallBuilder.safeGetValue(this.descriptor.getReceiverParameter()), ExplicitReceiverKind.THIS_OBJECT, false), TemporaryBindingTrace.create(new BindingTraceContext(), "trace to resolve call (in js)"), TracingStrategy.EMPTY, MutableDataFlowInfoForArguments.WITHOUT_ARGUMENTS_CHECK);
        }
        if (this.descriptor == null) {
            this.descriptor = this.resolvedCall.getCandidateDescriptor().getOriginal();
        }
        assert (this.resolvedCall != null);
        CallTranslator callTranslator = new CallTranslator(this.receiver, this.callee, this.args, this.resolvedCall, this.descriptor, this.callType, this.context);
        if (callTranslator == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/k2js/translate/reference/CallBuilder", "finish"));
        }
        return callTranslator;
    }

    @NotNull
    private static ReceiverValue safeGetValue(@Nullable ReceiverParameterDescriptor descriptor) {
        ReceiverValue receiverValue = descriptor == null ? ReceiverValue.NO_RECEIVER : descriptor.getValue();
        if (receiverValue == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/k2js/translate/reference/CallBuilder", "safeGetValue"));
        }
        return receiverValue;
    }

    @NotNull
    public JsExpression translate() {
        JsExpression jsExpression = this.finish().translate();
        if (jsExpression == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/k2js/translate/reference/CallBuilder", "translate"));
        }
        return jsExpression;
    }
}

