/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.k2js.translate.reference;

import com.google.dart.compiler.backend.js.ast.JsExpression;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jet.lang.descriptors.DeclarationDescriptor;
import org.jetbrains.jet.lang.descriptors.PropertyDescriptor;
import org.jetbrains.jet.lang.psi.JetExpression;
import org.jetbrains.jet.lang.psi.JetPsiUtil;
import org.jetbrains.jet.lang.psi.JetQualifiedExpression;
import org.jetbrains.jet.lang.psi.JetSimpleNameExpression;
import org.jetbrains.jet.lang.resolve.calls.model.ResolvedCall;
import org.jetbrains.k2js.translate.context.TranslationContext;
import org.jetbrains.k2js.translate.general.AbstractTranslator;
import org.jetbrains.k2js.translate.reference.AccessTranslator;
import org.jetbrains.k2js.translate.reference.CallType;
import org.jetbrains.k2js.translate.reference.KotlinPropertyAccessTranslator;
import org.jetbrains.k2js.translate.reference.NativePropertyAccessTranslator;
import org.jetbrains.k2js.translate.utils.AnnotationsUtils;
import org.jetbrains.k2js.translate.utils.BindingUtils;
import org.jetbrains.k2js.translate.utils.PsiUtils;

public abstract class PropertyAccessTranslator
extends AbstractTranslator
implements AccessTranslator {
    private CallType callType;

    @NotNull
    public static PropertyAccessTranslator newInstance(@NotNull JetSimpleNameExpression expression, @Nullable JsExpression qualifier, @NotNull CallType callType, @NotNull TranslationContext context) {
        PropertyAccessTranslator result;
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/k2js/translate/reference/PropertyAccessTranslator", "newInstance"));
        }
        if (callType == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "org/jetbrains/k2js/translate/reference/PropertyAccessTranslator", "newInstance"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "3", "org/jetbrains/k2js/translate/reference/PropertyAccessTranslator", "newInstance"));
        }
        PropertyDescriptor propertyDescriptor = PropertyAccessTranslator.getPropertyDescriptor(expression, context);
        if (AnnotationsUtils.isNativeObject(propertyDescriptor) || JetPsiUtil.isBackingFieldReference(expression)) {
            result = new NativePropertyAccessTranslator(propertyDescriptor, qualifier, context);
        } else {
            ResolvedCall<?> resolvedCall = BindingUtils.getResolvedCallForProperty(context.bindingContext(), expression);
            result = new KotlinPropertyAccessTranslator(propertyDescriptor, qualifier, resolvedCall, context);
        }
        result.setCallType(callType);
        NativePropertyAccessTranslator nativePropertyAccessTranslator = result;
        if (nativePropertyAccessTranslator == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/k2js/translate/reference/PropertyAccessTranslator", "newInstance"));
        }
        return nativePropertyAccessTranslator;
    }

    @NotNull
    private static PropertyDescriptor getPropertyDescriptor(@NotNull JetSimpleNameExpression expression, @NotNull TranslationContext context) {
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/k2js/translate/reference/PropertyAccessTranslator", "getPropertyDescriptor"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "org/jetbrains/k2js/translate/reference/PropertyAccessTranslator", "getPropertyDescriptor"));
        }
        DeclarationDescriptor descriptor = BindingUtils.getDescriptorForReferenceExpression(context.bindingContext(), expression);
        assert (descriptor instanceof PropertyDescriptor) : "Must be a property descriptor.";
        PropertyDescriptor propertyDescriptor = (PropertyDescriptor)descriptor;
        if (propertyDescriptor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/k2js/translate/reference/PropertyAccessTranslator", "getPropertyDescriptor"));
        }
        return propertyDescriptor;
    }

    @NotNull
    public static JsExpression translateAsPropertyGetterCall(@NotNull JetSimpleNameExpression expression, @Nullable JsExpression qualifier, @NotNull CallType callType, @NotNull TranslationContext context) {
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/k2js/translate/reference/PropertyAccessTranslator", "translateAsPropertyGetterCall"));
        }
        if (callType == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "org/jetbrains/k2js/translate/reference/PropertyAccessTranslator", "translateAsPropertyGetterCall"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "3", "org/jetbrains/k2js/translate/reference/PropertyAccessTranslator", "translateAsPropertyGetterCall"));
        }
        JsExpression jsExpression = PropertyAccessTranslator.newInstance(expression, qualifier, callType, context).translateAsGet();
        if (jsExpression == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/k2js/translate/reference/PropertyAccessTranslator", "translateAsPropertyGetterCall"));
        }
        return jsExpression;
    }

    private static boolean canBePropertyGetterCall(@NotNull JetQualifiedExpression expression, @NotNull TranslationContext context) {
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/k2js/translate/reference/PropertyAccessTranslator", "canBePropertyGetterCall"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "org/jetbrains/k2js/translate/reference/PropertyAccessTranslator", "canBePropertyGetterCall"));
        }
        JetSimpleNameExpression selector = PsiUtils.getSelectorAsSimpleName(expression);
        assert (selector != null) : "Only names are allowed after the dot";
        return PropertyAccessTranslator.canBePropertyGetterCall(selector, context);
    }

    private static boolean canBePropertyGetterCall(@NotNull JetSimpleNameExpression expression, @NotNull TranslationContext context) {
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/k2js/translate/reference/PropertyAccessTranslator", "canBePropertyGetterCall"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "org/jetbrains/k2js/translate/reference/PropertyAccessTranslator", "canBePropertyGetterCall"));
        }
        return BindingUtils.getDescriptorForReferenceExpression(context.bindingContext(), expression) instanceof PropertyDescriptor;
    }

    public static boolean canBePropertyGetterCall(@NotNull JetExpression expression, @NotNull TranslationContext context) {
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/k2js/translate/reference/PropertyAccessTranslator", "canBePropertyGetterCall"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "org/jetbrains/k2js/translate/reference/PropertyAccessTranslator", "canBePropertyGetterCall"));
        }
        if (expression instanceof JetQualifiedExpression) {
            return PropertyAccessTranslator.canBePropertyGetterCall((JetQualifiedExpression)expression, context);
        }
        if (expression instanceof JetSimpleNameExpression) {
            return PropertyAccessTranslator.canBePropertyGetterCall((JetSimpleNameExpression)expression, context);
        }
        return false;
    }

    public static boolean canBePropertyAccess(@NotNull JetExpression expression, @NotNull TranslationContext context) {
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/k2js/translate/reference/PropertyAccessTranslator", "canBePropertyAccess"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "org/jetbrains/k2js/translate/reference/PropertyAccessTranslator", "canBePropertyAccess"));
        }
        return PropertyAccessTranslator.canBePropertyGetterCall(expression, context);
    }

    protected PropertyAccessTranslator(@NotNull TranslationContext context) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/k2js/translate/reference/PropertyAccessTranslator", "<init>"));
        }
        super(context);
        this.callType = CallType.NORMAL;
    }

    public void setCallType(@NotNull CallType callType) {
        if (callType == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/k2js/translate/reference/PropertyAccessTranslator", "setCallType"));
        }
        this.callType = callType;
    }

    @NotNull
    protected CallType getCallType() {
        assert (this.callType != null) : "CallType not set";
        CallType callType = this.callType;
        if (callType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/k2js/translate/reference/PropertyAccessTranslator", "getCallType"));
        }
        return callType;
    }

    @NotNull
    protected abstract JsExpression translateAsGet(@Nullable JsExpression var1);

    @NotNull
    protected abstract JsExpression translateAsSet(@Nullable JsExpression var1, @NotNull JsExpression var2);
}

