/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.k2js.translate.utils.dangerous;

import com.google.common.collect.Lists;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jet.lang.psi.JetBlockExpression;
import org.jetbrains.jet.lang.psi.JetElement;
import org.jetbrains.jet.lang.psi.JetExpression;
import org.jetbrains.k2js.translate.context.TranslationContext;
import org.jetbrains.k2js.translate.utils.dangerous.FindDangerousVisitor;
import org.jetbrains.k2js.translate.utils.dangerous.FindPreviousVisitor;

public class DangerousData {
    @NotNull
    private final List<JetExpression> nodesToBeGeneratedBefore = Lists.newArrayList();
    private static final DangerousData EMPTY = new DangerousData(){

        @Override
        public boolean exists() {
            return false;
        }

        @Override
        public boolean shouldBeTranslated() {
            return false;
        }
    };
    @Nullable
    private JetExpression dangerousNode = null;
    @Nullable
    private JetExpression rootNode = null;

    @NotNull
    public static DangerousData collect(@NotNull JetExpression expression, @NotNull TranslationContext context) {
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/k2js/translate/utils/dangerous/DangerousData", "collect"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "org/jetbrains/k2js/translate/utils/dangerous/DangerousData", "collect"));
        }
        if (DangerousData.cantContainDangerousElements(expression)) {
            DangerousData dangerousData = DangerousData.emptyData();
            if (dangerousData == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/k2js/translate/utils/dangerous/DangerousData", "collect"));
            }
            return dangerousData;
        }
        DangerousData dangerousData = DangerousData.doCollectData(expression, context);
        if (dangerousData == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/k2js/translate/utils/dangerous/DangerousData", "collect"));
        }
        return dangerousData;
    }

    private static boolean cantContainDangerousElements(@NotNull JetElement element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/k2js/translate/utils/dangerous/DangerousData", "cantContainDangerousElements"));
        }
        return element instanceof JetBlockExpression;
    }

    @NotNull
    private static DangerousData doCollectData(@NotNull JetExpression expression, @NotNull TranslationContext context) {
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/k2js/translate/utils/dangerous/DangerousData", "doCollectData"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "org/jetbrains/k2js/translate/utils/dangerous/DangerousData", "doCollectData"));
        }
        DangerousData data2 = new DangerousData();
        FindDangerousVisitor visitor = new FindDangerousVisitor(context);
        expression.accept(visitor, data2);
        if (!data2.exists()) {
            DangerousData dangerousData = DangerousData.emptyData();
            if (dangerousData == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/k2js/translate/utils/dangerous/DangerousData", "doCollectData"));
            }
            return dangerousData;
        }
        data2.setRootNode(expression);
        FindPreviousVisitor findPreviousVisitor = new FindPreviousVisitor(data2);
        expression.accept(findPreviousVisitor, data2);
        DangerousData dangerousData = data2;
        if (dangerousData == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/k2js/translate/utils/dangerous/DangerousData", "doCollectData"));
        }
        return dangerousData;
    }

    @NotNull
    public static DangerousData emptyData() {
        DangerousData dangerousData = EMPTY;
        if (dangerousData == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/k2js/translate/utils/dangerous/DangerousData", "emptyData"));
        }
        return dangerousData;
    }

    public void setDangerousNode(@NotNull JetExpression dangerousNode) {
        if (dangerousNode == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/k2js/translate/utils/dangerous/DangerousData", "setDangerousNode"));
        }
        assert (this.dangerousNode == null) : "Should be assigned only once";
        this.dangerousNode = dangerousNode;
    }

    @NotNull
    public List<JetExpression> getNodesToBeGeneratedBefore() {
        List<JetExpression> list2 = this.nodesToBeGeneratedBefore;
        if (list2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/k2js/translate/utils/dangerous/DangerousData", "getNodesToBeGeneratedBefore"));
        }
        return list2;
    }

    public boolean exists() {
        return this.dangerousNode != null;
    }

    public boolean shouldBeTranslated() {
        return this.exists() && !this.nodesToBeGeneratedBefore.isEmpty();
    }

    @NotNull
    public JetExpression getDangerousNode() {
        assert (this.dangerousNode != null);
        JetExpression jetExpression = this.dangerousNode;
        if (jetExpression == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/k2js/translate/utils/dangerous/DangerousData", "getDangerousNode"));
        }
        return jetExpression;
    }

    @NotNull
    public JetExpression getRootNode() {
        assert (this.rootNode != null);
        JetExpression jetExpression = this.rootNode;
        if (jetExpression == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/k2js/translate/utils/dangerous/DangerousData", "getRootNode"));
        }
        return jetExpression;
    }

    public void setRootNode(@NotNull JetExpression rootNode) {
        if (rootNode == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/k2js/translate/utils/dangerous/DangerousData", "setRootNode"));
        }
        this.rootNode = rootNode;
    }
}

