/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.k2js.translate.utils.dangerous;

import org.jetbrains.annotations.NotNull;
import org.jetbrains.jet.lang.psi.JetBlockExpression;
import org.jetbrains.jet.lang.psi.JetCallExpression;
import org.jetbrains.jet.lang.psi.JetDeclaration;
import org.jetbrains.jet.lang.psi.JetElement;
import org.jetbrains.jet.lang.psi.JetExpression;
import org.jetbrains.jet.lang.psi.JetIfExpression;
import org.jetbrains.jet.lang.psi.JetTreeVisitor;
import org.jetbrains.jet.lang.psi.JetWhenExpression;
import org.jetbrains.k2js.translate.context.TranslationContext;
import org.jetbrains.k2js.translate.reference.InlinedCallExpressionTranslator;
import org.jetbrains.k2js.translate.utils.BindingUtils;
import org.jetbrains.k2js.translate.utils.dangerous.DangerousData;

public final class FindDangerousVisitor
extends JetTreeVisitor<DangerousData> {
    @NotNull
    private final TranslationContext context;

    public FindDangerousVisitor(@NotNull TranslationContext context) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/k2js/translate/utils/dangerous/FindDangerousVisitor", "<init>"));
        }
        this.context = context;
    }

    @Override
    public Void visitDeclaration(@NotNull JetDeclaration dcl, DangerousData data2) {
        if (dcl == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/k2js/translate/utils/dangerous/FindDangerousVisitor", "visitDeclaration"));
        }
        return null;
    }

    @Override
    public Void visitJetElement(@NotNull JetElement element, DangerousData data2) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/k2js/translate/utils/dangerous/FindDangerousVisitor", "visitJetElement"));
        }
        if (data2.exists()) {
            return null;
        }
        return super.visitJetElement(element, data2);
    }

    @Override
    public Void visitWhenExpression(@NotNull JetWhenExpression expression, DangerousData data2) {
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/k2js/translate/utils/dangerous/FindDangerousVisitor", "visitWhenExpression"));
        }
        if (this.expressionFound(expression, data2)) {
            return null;
        }
        return (Void)super.visitWhenExpression(expression, data2);
    }

    @Override
    public Void visitIfExpression(@NotNull JetIfExpression expression, DangerousData data2) {
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/k2js/translate/utils/dangerous/FindDangerousVisitor", "visitIfExpression"));
        }
        if (this.expressionFound(expression, data2)) {
            return null;
        }
        return (Void)super.visitIfExpression(expression, data2);
    }

    @Override
    public Void visitBlockExpression(@NotNull JetBlockExpression expression, DangerousData data2) {
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/k2js/translate/utils/dangerous/FindDangerousVisitor", "visitBlockExpression"));
        }
        if (BindingUtils.isStatement(this.context.bindingContext(), expression)) {
            return null;
        }
        return (Void)super.visitBlockExpression(expression, data2);
    }

    @Override
    public Void visitCallExpression(@NotNull JetCallExpression expression, DangerousData data2) {
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/k2js/translate/utils/dangerous/FindDangerousVisitor", "visitCallExpression"));
        }
        if (InlinedCallExpressionTranslator.shouldBeInlined(expression, this.context) && this.expressionFound(expression, data2)) {
            return null;
        }
        return (Void)super.visitCallExpression(expression, data2);
    }

    private boolean expressionFound(@NotNull JetExpression expression, @NotNull DangerousData data2) {
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/k2js/translate/utils/dangerous/FindDangerousVisitor", "expressionFound"));
        }
        if (data2 == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "org/jetbrains/k2js/translate/utils/dangerous/FindDangerousVisitor", "expressionFound"));
        }
        if (data2.exists()) {
            return true;
        }
        if (!BindingUtils.isStatement(this.context.bindingContext(), expression)) {
            data2.setDangerousNode(expression);
            return true;
        }
        return false;
    }
}

