/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.k2js.utils;

import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiFileFactory;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jet.lang.psi.JetFile;
import org.jetbrains.jet.plugin.JetLanguage;

public final class JetFileUtils {
    private JetFileUtils() {
    }

    @NotNull
    public static JetFile createJetFile(@NotNull String name, @NotNull String text, @NotNull Project project) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/k2js/utils/JetFileUtils", "createJetFile"));
        }
        if (text == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "org/jetbrains/k2js/utils/JetFileUtils", "createJetFile"));
        }
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "org/jetbrains/k2js/utils/JetFileUtils", "createJetFile"));
        }
        JetFile jetFile = (JetFile)PsiFileFactory.getInstance(project).createFileFromText(name.endsWith(".kt") ? name : name + ".kt", JetLanguage.INSTANCE, (CharSequence)text, true, false);
        if (jetFile == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/k2js/utils/JetFileUtils", "createJetFile"));
        }
        return jetFile;
    }
}

