/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.projectRoots;

import com.intellij.pom.java.LanguageLevel;
import org.jetbrains.annotations.NotNull;

public enum JavaSdkVersion {
    JDK_1_0(LanguageLevel.JDK_1_3, "1.0"),
    JDK_1_1(LanguageLevel.JDK_1_3, "1.1"),
    JDK_1_2(LanguageLevel.JDK_1_3, "1.2"),
    JDK_1_3(LanguageLevel.JDK_1_3, "1.3"),
    JDK_1_4(LanguageLevel.JDK_1_4, "1.4"),
    JDK_1_5(LanguageLevel.JDK_1_5, "1.5"),
    JDK_1_6(LanguageLevel.JDK_1_6, "1.6"),
    JDK_1_7(LanguageLevel.JDK_1_7, "1.7"),
    JDK_1_8(LanguageLevel.JDK_1_8, "1.8"),
    JDK_1_9(LanguageLevel.JDK_1_9, "1.9");

    private final LanguageLevel myMaxLanguageLevel;
    private final String myDescription;

    private JavaSdkVersion(@NotNull LanguageLevel maxLanguageLevel, @NotNull String description) {
        if (maxLanguageLevel == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/projectRoots/JavaSdkVersion", "<init>"));
        }
        if (description == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/openapi/projectRoots/JavaSdkVersion", "<init>"));
        }
        this.myMaxLanguageLevel = maxLanguageLevel;
        this.myDescription = description;
    }

    @NotNull
    public LanguageLevel getMaxLanguageLevel() {
        LanguageLevel languageLevel = this.myMaxLanguageLevel;
        if (languageLevel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/projectRoots/JavaSdkVersion", "getMaxLanguageLevel"));
        }
        return languageLevel;
    }

    public String toString() {
        return super.toString() + ", description: " + this.myDescription;
    }
}

