/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.asJava;

import com.intellij.psi.PsiElement;
import com.intellij.psi.impl.compiled.InnerClassSourceStrategy;
import com.intellij.psi.impl.compiled.StubBuildingVisitor;
import com.intellij.psi.stubs.StubBase;
import com.intellij.psi.stubs.StubElement;
import com.intellij.util.containers.Stack;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jet.asJava.ClsWrapperStubPsiFactory;
import org.jetbrains.jet.codegen.AbstractClassBuilder;
import org.jetbrains.jet.lang.psi.JetFile;
import org.jetbrains.jet.lang.resolve.java.PackageClassUtils;
import org.jetbrains.jet.lang.resolve.name.FqName;
import org.jetbrains.org.objectweb.asm.ClassVisitor;
import org.jetbrains.org.objectweb.asm.FieldVisitor;
import org.jetbrains.org.objectweb.asm.MethodVisitor;

public class StubClassBuilder
extends AbstractClassBuilder {
    private static final InnerClassSourceStrategy<Object> EMPTY_STRATEGY = new InnerClassSourceStrategy<Object>(){

        @Override
        public Object findInnerClass(String s, Object o) {
            return null;
        }

        @Override
        public void accept(Object innerClass, StubBuildingVisitor<Object> visitor) {
            throw new UnsupportedOperationException("Shall not be called!");
        }
    };
    private final StubElement parent;
    private StubBuildingVisitor v;
    private final Stack<StubElement> parentStack;
    private boolean isPackageClass;

    public StubClassBuilder(@NotNull Stack<StubElement> parentStack) {
        if (parentStack == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parentStack", "org/jetbrains/jet/asJava/StubClassBuilder", "<init>"));
        }
        this.isPackageClass = false;
        this.parentStack = parentStack;
        this.parent = parentStack.peek();
    }

    @Override
    @NotNull
    public ClassVisitor getVisitor() {
        assert (this.v != null) : "Called before class is defined";
        StubBuildingVisitor stubBuildingVisitor = this.v;
        if (stubBuildingVisitor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/asJava/StubClassBuilder", "getVisitor"));
        }
        return stubBuildingVisitor;
    }

    @Override
    public void defineClass(PsiElement origin, int version, int access, @NotNull String name, @Nullable String signature, @NotNull String superName, @NotNull String[] interfaces) {
        FqName packageName;
        String packageClassName;
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "org/jetbrains/jet/asJava/StubClassBuilder", "defineClass"));
        }
        if (superName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "superName", "org/jetbrains/jet/asJava/StubClassBuilder", "defineClass"));
        }
        if (interfaces == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "interfaces", "org/jetbrains/jet/asJava/StubClassBuilder", "defineClass"));
        }
        assert (this.v == null) : "defineClass() called twice?";
        this.v = new StubBuildingVisitor<Object>(null, EMPTY_STRATEGY, this.parent, access, null);
        super.defineClass(origin, version, access, name, signature, superName, interfaces);
        if (origin instanceof JetFile && (name.equals(packageClassName = PackageClassUtils.getPackageClassName(packageName = ((JetFile)origin).getPackageFqName())) || name.endsWith("/" + packageClassName))) {
            this.isPackageClass = true;
        }
        if (!this.isPackageClass) {
            this.parentStack.push(this.v.getResult());
        }
        ((StubBase)((Object)this.v.getResult())).putUserData(ClsWrapperStubPsiFactory.ORIGIN_ELEMENT, origin);
    }

    @Override
    @NotNull
    public MethodVisitor newMethod(@Nullable PsiElement origin, int access, @NotNull String name, @NotNull String desc, @Nullable String signature, @Nullable String[] exceptions) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "org/jetbrains/jet/asJava/StubClassBuilder", "newMethod"));
        }
        if (desc == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "desc", "org/jetbrains/jet/asJava/StubClassBuilder", "newMethod"));
        }
        MethodVisitor internalVisitor = super.newMethod(origin, access, name, desc, signature, exceptions);
        if (internalVisitor != EMPTY_METHOD_VISITOR) {
            this.markLastChild(origin);
        }
        MethodVisitor methodVisitor = internalVisitor;
        if (methodVisitor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/asJava/StubClassBuilder", "newMethod"));
        }
        return methodVisitor;
    }

    @Override
    @NotNull
    public FieldVisitor newField(@Nullable PsiElement origin, int access, @NotNull String name, @NotNull String desc, @Nullable String signature, @Nullable Object value) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "org/jetbrains/jet/asJava/StubClassBuilder", "newField"));
        }
        if (desc == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "desc", "org/jetbrains/jet/asJava/StubClassBuilder", "newField"));
        }
        FieldVisitor internalVisitor = super.newField(origin, access, name, desc, signature, value);
        if (internalVisitor != EMPTY_FIELD_VISITOR) {
            this.markLastChild(origin);
        }
        FieldVisitor fieldVisitor = internalVisitor;
        if (fieldVisitor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/asJava/StubClassBuilder", "newField"));
        }
        return fieldVisitor;
    }

    private void markLastChild(@Nullable PsiElement origin) {
        List<StubElement> children = this.v.getResult().getChildrenStubs();
        StubBase last = (StubBase)children.get(children.size() - 1);
        PsiElement oldOrigin = last.getUserData(ClsWrapperStubPsiFactory.ORIGIN_ELEMENT);
        if (oldOrigin != null) {
            throw new IllegalStateException("Rewriting origin element: " + oldOrigin.getText() + " for stub " + last.toString());
        }
        last.putUserData(ClsWrapperStubPsiFactory.ORIGIN_ELEMENT, origin);
    }

    @Override
    public void done() {
        if (!this.isPackageClass) {
            StubElement pop = this.parentStack.pop();
            assert (pop == this.v.getResult());
        }
        super.done();
    }
}

