/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.codegen.binding;

import com.intellij.psi.PsiElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.util.containers.Stack;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jet.codegen.JvmCodegenUtil;
import org.jetbrains.jet.codegen.JvmFunctionImplTypes;
import org.jetbrains.jet.codegen.SamCodegenUtil;
import org.jetbrains.jet.codegen.SamType;
import org.jetbrains.jet.codegen.binding.CodegenBinding;
import org.jetbrains.jet.codegen.state.GenerationState;
import org.jetbrains.jet.lang.descriptors.ClassDescriptor;
import org.jetbrains.jet.lang.descriptors.ConstructorDescriptor;
import org.jetbrains.jet.lang.descriptors.DeclarationDescriptor;
import org.jetbrains.jet.lang.descriptors.FunctionDescriptor;
import org.jetbrains.jet.lang.descriptors.Modality;
import org.jetbrains.jet.lang.descriptors.PackageFragmentDescriptor;
import org.jetbrains.jet.lang.descriptors.ValueParameterDescriptor;
import org.jetbrains.jet.lang.descriptors.impl.ClassDescriptorImpl;
import org.jetbrains.jet.lang.psi.JetArrayAccessExpression;
import org.jetbrains.jet.lang.psi.JetBinaryExpression;
import org.jetbrains.jet.lang.psi.JetCallExpression;
import org.jetbrains.jet.lang.psi.JetCallableReferenceExpression;
import org.jetbrains.jet.lang.psi.JetClass;
import org.jetbrains.jet.lang.psi.JetClassObject;
import org.jetbrains.jet.lang.psi.JetDelegatorToSuperCall;
import org.jetbrains.jet.lang.psi.JetElement;
import org.jetbrains.jet.lang.psi.JetEnumEntry;
import org.jetbrains.jet.lang.psi.JetExpression;
import org.jetbrains.jet.lang.psi.JetFile;
import org.jetbrains.jet.lang.psi.JetFunctionLiteral;
import org.jetbrains.jet.lang.psi.JetFunctionLiteralExpression;
import org.jetbrains.jet.lang.psi.JetNamedFunction;
import org.jetbrains.jet.lang.psi.JetObjectDeclaration;
import org.jetbrains.jet.lang.psi.JetObjectLiteralExpression;
import org.jetbrains.jet.lang.psi.JetProperty;
import org.jetbrains.jet.lang.psi.JetPsiUtil;
import org.jetbrains.jet.lang.psi.JetVisitorVoid;
import org.jetbrains.jet.lang.psi.ValueArgument;
import org.jetbrains.jet.lang.resolve.BindingContext;
import org.jetbrains.jet.lang.resolve.BindingTrace;
import org.jetbrains.jet.lang.resolve.DescriptorUtils;
import org.jetbrains.jet.lang.resolve.calls.model.ExpressionValueArgument;
import org.jetbrains.jet.lang.resolve.calls.model.ResolvedCall;
import org.jetbrains.jet.lang.resolve.calls.model.ResolvedValueArgument;
import org.jetbrains.jet.lang.resolve.java.JvmClassName;
import org.jetbrains.jet.lang.resolve.java.PackageClassUtils;
import org.jetbrains.jet.lang.resolve.name.FqName;
import org.jetbrains.jet.lang.resolve.name.Name;
import org.jetbrains.jet.lang.resolve.scopes.JetScope;
import org.jetbrains.jet.lang.types.JetType;
import org.jetbrains.jet.lexer.JetTokens;
import org.jetbrains.org.objectweb.asm.Type;

class CodegenAnnotatingVisitor
extends JetVisitorVoid {
    private static final TokenSet BINARY_OPERATIONS = TokenSet.orSet(JetTokens.AUGMENTED_ASSIGNMENTS, TokenSet.create(JetTokens.PLUS, JetTokens.MINUS, JetTokens.MUL, JetTokens.DIV, JetTokens.PERC, JetTokens.RANGE, JetTokens.LT, JetTokens.GT, JetTokens.LTEQ, JetTokens.GTEQ, JetTokens.IDENTIFIER));
    private final Map<String, Integer> anonymousSubclassesCount;
    private final Stack<ClassDescriptorWithState> classStack;
    private final Stack<String> nameStack;
    private final BindingTrace bindingTrace;
    private final BindingContext bindingContext;
    private final GenerationState.GenerateClassFilter filter;
    private final JvmFunctionImplTypes functionImplTypes;

    public CodegenAnnotatingVisitor(@NotNull GenerationState state) {
        if (state == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "state", "org/jetbrains/jet/codegen/binding/CodegenAnnotatingVisitor", "<init>"));
        }
        this.anonymousSubclassesCount = new HashMap<String, Integer>();
        this.classStack = new Stack();
        this.nameStack = new Stack();
        this.bindingTrace = state.getBindingTrace();
        this.bindingContext = state.getBindingContext();
        this.filter = state.getGenerateDeclaredClassFilter();
        this.functionImplTypes = state.getJvmFunctionImplTypes();
    }

    @NotNull
    private ClassDescriptor recordClassForFunction(@NotNull FunctionDescriptor funDescriptor, @NotNull Collection<JetType> supertypes) {
        if (funDescriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "funDescriptor", "org/jetbrains/jet/codegen/binding/CodegenAnnotatingVisitor", "recordClassForFunction"));
        }
        if (supertypes == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "supertypes", "org/jetbrains/jet/codegen/binding/CodegenAnnotatingVisitor", "recordClassForFunction"));
        }
        ClassDescriptorImpl classDescriptor = new ClassDescriptorImpl(funDescriptor.getContainingDeclaration(), Name.special("<closure>"), Modality.FINAL, supertypes);
        classDescriptor.initialize(JetScope.EMPTY, Collections.<ConstructorDescriptor>emptySet(), null);
        this.bindingTrace.record(CodegenBinding.CLASS_FOR_FUNCTION, funDescriptor, classDescriptor);
        ClassDescriptorImpl classDescriptorImpl = classDescriptor;
        if (classDescriptorImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/codegen/binding/CodegenAnnotatingVisitor", "recordClassForFunction"));
        }
        return classDescriptorImpl;
    }

    private String inventAnonymousClassName(JetElement declaration) {
        String top = JvmCodegenUtil.peekFromStack(this.nameStack);
        Integer cnt = this.anonymousSubclassesCount.get(top);
        if (cnt == null) {
            cnt = 0;
        }
        String name = top + "$" + (cnt + 1);
        ClassDescriptor descriptor = this.bindingContext.get(BindingContext.CLASS, declaration);
        if (!(descriptor != null || declaration instanceof JetFunctionLiteralExpression || declaration instanceof JetNamedFunction || declaration instanceof JetObjectLiteralExpression || declaration instanceof JetCallableReferenceExpression)) {
            throw new IllegalStateException("Class-less declaration which is not JetFunctionLiteralExpression|JetNamedFunction|JetObjectLiteralExpression|JetCallableReferenceExpression : " + declaration.getClass().getName());
        }
        this.anonymousSubclassesCount.put(top, cnt + 1);
        return name;
    }

    @Override
    public void visitJetElement(@NotNull JetElement element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/jetbrains/jet/codegen/binding/CodegenAnnotatingVisitor", "visitJetElement"));
        }
        super.visitJetElement(element);
        element.acceptChildren(this);
    }

    @Override
    public void visitJetFile(@NotNull JetFile file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "org/jetbrains/jet/codegen/binding/CodegenAnnotatingVisitor", "visitJetFile"));
        }
        if (file.isScript()) {
            ClassDescriptor classDescriptor = this.bindingContext.get(CodegenBinding.CLASS_FOR_SCRIPT, this.bindingContext.get(BindingContext.SCRIPT, file.getScript()));
            this.pushClassDescriptor(classDescriptor);
            this.nameStack.push(CodegenBinding.asmTypeForScriptPsi(this.bindingContext, file.getScript()).getInternalName());
        } else {
            this.nameStack.push(JvmClassName.byFqNameWithoutInnerClasses(file.getPackageFqName()).getInternalName());
        }
        file.acceptChildren(this);
        this.nameStack.pop();
        if (file.isScript()) {
            this.popClassDescriptor();
        }
    }

    @Override
    public void visitEnumEntry(@NotNull JetEnumEntry enumEntry) {
        if (enumEntry == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "enumEntry", "org/jetbrains/jet/codegen/binding/CodegenAnnotatingVisitor", "visitEnumEntry"));
        }
        ClassDescriptor descriptor = this.bindingContext.get(BindingContext.CLASS, enumEntry);
        assert (descriptor != null) : String.format("No descriptor for enum entry \n---\n%s\n---\n", JetPsiUtil.getElementTextWithContext(enumEntry));
        if (!enumEntry.getDeclarations().isEmpty()) {
            this.bindingTrace.record(CodegenBinding.ENUM_ENTRY_CLASS_NEED_SUBCLASS, descriptor);
            super.visitEnumEntry(enumEntry);
        }
    }

    @Override
    public void visitClassObject(@NotNull JetClassObject classObject) {
        if (classObject == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "classObject", "org/jetbrains/jet/codegen/binding/CodegenAnnotatingVisitor", "visitClassObject"));
        }
        ClassDescriptor classDescriptor = this.bindingContext.get(BindingContext.CLASS, classObject.getObjectDeclaration());
        assert (classDescriptor != null) : String.format("No class found in binding context for: \n---\n%s\n---\n", JetPsiUtil.getElementTextWithContext(classObject));
        String name = JvmCodegenUtil.peekFromStack(this.nameStack) + "$object";
        this.recordClosure(classObject, classDescriptor, name);
        this.pushClassDescriptor(classDescriptor);
        this.nameStack.push(name);
        super.visitClassObject(classObject);
        this.nameStack.pop();
        this.popClassDescriptor();
    }

    @Override
    public void visitObjectDeclaration(@NotNull JetObjectDeclaration declaration) {
        if (declaration == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "declaration", "org/jetbrains/jet/codegen/binding/CodegenAnnotatingVisitor", "visitObjectDeclaration"));
        }
        if (declaration.getParent() instanceof JetObjectLiteralExpression || declaration.getParent() instanceof JetClassObject) {
            super.visitObjectDeclaration(declaration);
        } else {
            if (!this.filter.shouldProcess(declaration)) {
                return;
            }
            ClassDescriptor classDescriptor = this.bindingContext.get(BindingContext.CLASS, declaration);
            if (classDescriptor == null) {
                return;
            }
            String name = this.getName(classDescriptor);
            this.recordClosure(declaration, classDescriptor, name);
            this.pushClassDescriptor(classDescriptor);
            this.nameStack.push(name);
            super.visitObjectDeclaration(declaration);
            this.nameStack.pop();
            this.popClassDescriptor();
        }
    }

    @Override
    public void visitClass(@NotNull JetClass klass) {
        if (klass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "klass", "org/jetbrains/jet/codegen/binding/CodegenAnnotatingVisitor", "visitClass"));
        }
        if (!this.filter.shouldProcess(klass)) {
            return;
        }
        ClassDescriptor classDescriptor = this.bindingContext.get(BindingContext.CLASS, klass);
        if (classDescriptor == null) {
            return;
        }
        String name = this.getName(classDescriptor);
        this.recordClosure(klass, classDescriptor, name);
        this.pushClassDescriptor(classDescriptor);
        this.nameStack.push(name);
        super.visitClass(klass);
        this.nameStack.pop();
        this.popClassDescriptor();
    }

    private String getName(ClassDescriptor classDescriptor) {
        String base = JvmCodegenUtil.peekFromStack(this.nameStack);
        return DescriptorUtils.isTopLevelDeclaration(classDescriptor) ? (base.isEmpty() ? classDescriptor.getName().asString() : base + '/' + classDescriptor.getName()) : base + '$' + classDescriptor.getName();
    }

    @Override
    public void visitObjectLiteralExpression(@NotNull JetObjectLiteralExpression expression) {
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/jet/codegen/binding/CodegenAnnotatingVisitor", "visitObjectLiteralExpression"));
        }
        ClassDescriptor classDescriptor = this.bindingContext.get(BindingContext.CLASS, expression.getObjectDeclaration());
        if (classDescriptor == null) {
            super.visitObjectLiteralExpression(expression);
            return;
        }
        String name = this.inventAnonymousClassName(expression.getObjectDeclaration());
        this.recordClosure(expression.getObjectDeclaration(), classDescriptor, name);
        this.pushClassDescriptor(classDescriptor);
        this.nameStack.push(this.bindingContext.get(CodegenBinding.ASM_TYPE, classDescriptor).getInternalName());
        super.visitObjectLiteralExpression(expression);
        this.nameStack.pop();
        this.popClassDescriptor();
    }

    @Override
    public void visitFunctionLiteralExpression(@NotNull JetFunctionLiteralExpression expression) {
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/jet/codegen/binding/CodegenAnnotatingVisitor", "visitFunctionLiteralExpression"));
        }
        JetFunctionLiteral functionLiteral = expression.getFunctionLiteral();
        FunctionDescriptor functionDescriptor = (FunctionDescriptor)this.bindingContext.get(BindingContext.DECLARATION_TO_DESCRIPTOR, functionLiteral);
        if (functionDescriptor == null) {
            return;
        }
        String name = this.inventAnonymousClassName(expression);
        Collection<JetType> supertypes = this.functionImplTypes.getSupertypesForClosure(functionDescriptor);
        ClassDescriptor classDescriptor = this.recordClassForFunction(functionDescriptor, supertypes);
        this.recordClosure(functionLiteral, classDescriptor, name);
        this.pushClassDescriptor(classDescriptor);
        this.nameStack.push(name);
        super.visitFunctionLiteralExpression(expression);
        this.nameStack.pop();
        this.popClassDescriptor();
    }

    private void pushClassDescriptor(ClassDescriptor classDescriptor) {
        this.classStack.push(new ClassDescriptorWithState(classDescriptor));
    }

    private void popClassDescriptor() {
        this.classStack.pop();
    }

    private ClassDescriptor getOuterClassDescriptor() {
        ListIterator iterator2 = this.classStack.listIterator(this.classStack.size());
        while (iterator2.hasPrevious()) {
            ClassDescriptorWithState previous = (ClassDescriptorWithState)iterator2.previous();
            if (previous.isDelegationToSuperCall()) continue;
            return previous.getDescriptor();
        }
        return null;
    }

    @Override
    public void visitDelegationToSuperCallSpecifier(@NotNull JetDelegatorToSuperCall call) {
        if (call == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "call", "org/jetbrains/jet/codegen/binding/CodegenAnnotatingVisitor", "visitDelegationToSuperCallSpecifier"));
        }
        ClassDescriptorWithState state = JvmCodegenUtil.peekFromStack(this.classStack);
        if (state == null) {
            return;
        }
        state.setDelegationToSuperCall(true);
        super.visitDelegationToSuperCallSpecifier(call);
        state.setDelegationToSuperCall(false);
    }

    @Override
    public void visitCallableReferenceExpression(@NotNull JetCallableReferenceExpression expression) {
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/jet/codegen/binding/CodegenAnnotatingVisitor", "visitCallableReferenceExpression"));
        }
        FunctionDescriptor functionDescriptor = this.bindingContext.get(BindingContext.FUNCTION, expression);
        if (functionDescriptor == null) {
            return;
        }
        ResolvedCall<?> referencedFunction = this.bindingContext.get(BindingContext.RESOLVED_CALL, expression.getCallableReference());
        if (referencedFunction == null) {
            return;
        }
        Collection<JetType> supertypes = this.functionImplTypes.getSupertypesForCallableReference((FunctionDescriptor)referencedFunction.getResultingDescriptor());
        String name = this.inventAnonymousClassName(expression);
        ClassDescriptor classDescriptor = this.recordClassForFunction(functionDescriptor, supertypes);
        this.recordClosure(expression, classDescriptor, name);
        this.pushClassDescriptor(classDescriptor);
        this.nameStack.push(name);
        super.visitCallableReferenceExpression(expression);
        this.nameStack.pop();
        this.popClassDescriptor();
    }

    private void recordClosure(@NotNull JetElement element, @NotNull ClassDescriptor classDescriptor, @NotNull String name) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/jetbrains/jet/codegen/binding/CodegenAnnotatingVisitor", "recordClosure"));
        }
        if (classDescriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "classDescriptor", "org/jetbrains/jet/codegen/binding/CodegenAnnotatingVisitor", "recordClosure"));
        }
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "org/jetbrains/jet/codegen/binding/CodegenAnnotatingVisitor", "recordClosure"));
        }
        CodegenBinding.recordClosure(this.bindingTrace, element, classDescriptor, this.getOuterClassDescriptor(), Type.getObjectType(name));
    }

    @Override
    public void visitProperty(@NotNull JetProperty property2) {
        if (property2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "property", "org/jetbrains/jet/codegen/binding/CodegenAnnotatingVisitor", "visitProperty"));
        }
        DeclarationDescriptor propertyDescriptor = this.bindingContext.get(BindingContext.DECLARATION_TO_DESCRIPTOR, property2);
        if (propertyDescriptor == null) {
            return;
        }
        String nameForClassOrPackageMember = this.getNameForClassOrPackageMember(propertyDescriptor);
        if (nameForClassOrPackageMember != null) {
            this.nameStack.push(nameForClassOrPackageMember);
        } else {
            this.nameStack.push(JvmCodegenUtil.peekFromStack(this.nameStack) + '$' + property2.getName());
        }
        super.visitProperty(property2);
        this.nameStack.pop();
    }

    @Override
    public void visitNamedFunction(@NotNull JetNamedFunction function) {
        if (function == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "function", "org/jetbrains/jet/codegen/binding/CodegenAnnotatingVisitor", "visitNamedFunction"));
        }
        FunctionDescriptor functionDescriptor = (FunctionDescriptor)this.bindingContext.get(BindingContext.DECLARATION_TO_DESCRIPTOR, function);
        if (functionDescriptor == null) {
            return;
        }
        String nameForClassOrPackageMember = this.getNameForClassOrPackageMember(functionDescriptor);
        if (nameForClassOrPackageMember != null) {
            this.nameStack.push(nameForClassOrPackageMember);
            super.visitNamedFunction(function);
            this.nameStack.pop();
        } else {
            String name = this.inventAnonymousClassName(function);
            Collection<JetType> supertypes = this.functionImplTypes.getSupertypesForClosure(functionDescriptor);
            ClassDescriptor classDescriptor = this.recordClassForFunction(functionDescriptor, supertypes);
            this.recordClosure(function, classDescriptor, name);
            this.pushClassDescriptor(classDescriptor);
            this.nameStack.push(name);
            super.visitNamedFunction(function);
            this.nameStack.pop();
            this.popClassDescriptor();
        }
    }

    @Nullable
    private String getNameForClassOrPackageMember(@NotNull DeclarationDescriptor descriptor) {
        if (descriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "org/jetbrains/jet/codegen/binding/CodegenAnnotatingVisitor", "getNameForClassOrPackageMember"));
        }
        DeclarationDescriptor containingDeclaration = descriptor.getContainingDeclaration();
        String peek = JvmCodegenUtil.peekFromStack(this.nameStack);
        String name = descriptor.getName().asString();
        if (containingDeclaration instanceof ClassDescriptor) {
            return peek + '$' + name;
        }
        if (containingDeclaration instanceof PackageFragmentDescriptor) {
            FqName qualifiedName = ((PackageFragmentDescriptor)containingDeclaration).getFqName();
            String packageClassShortName = PackageClassUtils.getPackageClassName(qualifiedName);
            String packageClassName = peek.isEmpty() ? packageClassShortName : peek + "/" + packageClassShortName;
            return packageClassName + '$' + name;
        }
        return null;
    }

    @Override
    public void visitCallExpression(@NotNull JetCallExpression expression) {
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/jet/codegen/binding/CodegenAnnotatingVisitor", "visitCallExpression"));
        }
        super.visitCallExpression(expression);
        ResolvedCall<?> call = this.bindingContext.get(BindingContext.RESOLVED_CALL, expression.getCalleeExpression());
        if (call == null) {
            return;
        }
        Object descriptor = call.getResultingDescriptor();
        if (!(descriptor instanceof FunctionDescriptor)) {
            return;
        }
        FunctionDescriptor original = SamCodegenUtil.getOriginalIfSamAdapter((FunctionDescriptor)descriptor);
        if (original == null) {
            return;
        }
        List<ResolvedValueArgument> valueArguments = call.getValueArgumentsByIndex();
        if (valueArguments == null) {
            throw new IllegalStateException("Failed to arrange value arguments by index: " + descriptor);
        }
        for (ValueParameterDescriptor valueParameter : original.getValueParameters()) {
            SamType samType = SamType.create(valueParameter.getType());
            if (samType == null) continue;
            ResolvedValueArgument resolvedValueArgument = valueArguments.get(valueParameter.getIndex());
            assert (resolvedValueArgument instanceof ExpressionValueArgument) : resolvedValueArgument;
            ValueArgument valueArgument = ((ExpressionValueArgument)resolvedValueArgument).getValueArgument();
            assert (valueArgument != null);
            JetExpression argumentExpression = valueArgument.getArgumentExpression();
            assert (argumentExpression != null) : valueArgument.asElement().getText();
            this.bindingTrace.record(CodegenBinding.SAM_VALUE, argumentExpression, samType);
        }
    }

    @Override
    public void visitBinaryExpression(@NotNull JetBinaryExpression expression) {
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/jet/codegen/binding/CodegenAnnotatingVisitor", "visitBinaryExpression"));
        }
        super.visitBinaryExpression(expression);
        DeclarationDescriptor operationDescriptor = this.bindingContext.get(BindingContext.REFERENCE_TARGET, expression.getOperationReference());
        if (!(operationDescriptor instanceof FunctionDescriptor)) {
            return;
        }
        FunctionDescriptor original = SamCodegenUtil.getOriginalIfSamAdapter((FunctionDescriptor)operationDescriptor);
        if (original == null) {
            return;
        }
        SamType samType = SamType.create(original.getValueParameters().get(0).getType());
        if (samType == null) {
            return;
        }
        IElementType token = expression.getOperationToken();
        if (BINARY_OPERATIONS.contains(token)) {
            this.bindingTrace.record(CodegenBinding.SAM_VALUE, expression.getRight(), samType);
        } else if (token == JetTokens.IN_KEYWORD || token == JetTokens.NOT_IN) {
            this.bindingTrace.record(CodegenBinding.SAM_VALUE, expression.getLeft(), samType);
        }
    }

    @Override
    public void visitArrayAccessExpression(@NotNull JetArrayAccessExpression expression) {
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/jet/codegen/binding/CodegenAnnotatingVisitor", "visitArrayAccessExpression"));
        }
        super.visitArrayAccessExpression(expression);
        DeclarationDescriptor operationDescriptor = this.bindingContext.get(BindingContext.REFERENCE_TARGET, expression);
        if (!(operationDescriptor instanceof FunctionDescriptor)) {
            return;
        }
        boolean isSetter = operationDescriptor.getName().asString().equals("set");
        FunctionDescriptor original = SamCodegenUtil.getOriginalIfSamAdapter((FunctionDescriptor)operationDescriptor);
        if (original == null) {
            return;
        }
        List<JetExpression> indexExpressions = expression.getIndexExpressions();
        List<ValueParameterDescriptor> parameters = original.getValueParameters();
        for (ValueParameterDescriptor valueParameter : parameters) {
            SamType samType = SamType.create(valueParameter.getType());
            if (samType == null) continue;
            if (isSetter && valueParameter.getIndex() == parameters.size() - 1) {
                PsiElement parent = expression.getParent();
                if (!(parent instanceof JetBinaryExpression) || ((JetBinaryExpression)parent).getOperationToken() != JetTokens.EQ) continue;
                JetExpression right = ((JetBinaryExpression)parent).getRight();
                this.bindingTrace.record(CodegenBinding.SAM_VALUE, right, samType);
                continue;
            }
            JetExpression indexExpression = indexExpressions.get(valueParameter.getIndex());
            this.bindingTrace.record(CodegenBinding.SAM_VALUE, indexExpression, samType);
        }
    }

    private static class ClassDescriptorWithState {
        private boolean isDelegationToSuperCall;
        private final ClassDescriptor descriptor;

        public ClassDescriptorWithState(ClassDescriptor descriptor) {
            this.descriptor = descriptor;
        }

        public boolean isDelegationToSuperCall() {
            return this.isDelegationToSuperCall;
        }

        public void setDelegationToSuperCall(boolean isDelegationToSuperCall) {
            this.isDelegationToSuperCall = isDelegationToSuperCall;
        }

        public ClassDescriptor getDescriptor() {
            return this.descriptor;
        }
    }
}

