/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.lang.cfg;

import kotlin.Function1;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jet.lang.cfg.pseudocode.AbstractJumpInstruction;
import org.jetbrains.jet.lang.cfg.pseudocode.Instruction;
import org.jetbrains.jet.lang.cfg.pseudocode.InstructionVisitorWithResult;
import org.jetbrains.jet.lang.cfg.pseudocode.MagicInstruction;
import org.jetbrains.jet.lang.cfg.pseudocode.MarkInstruction;
import org.jetbrains.jet.lang.cfg.pseudocode.SubroutineExitInstruction;
import org.jetbrains.jet.lang.cfg.pseudocode.SubroutineSinkInstruction;
import org.jetbrains.jet.lang.cfg.pseudocode.ThrowExceptionInstruction;
import org.jetbrains.jet.lang.psi.JetElement;

public class TailRecursionDetector
extends InstructionVisitorWithResult<Boolean>
implements Function1<Instruction, Boolean> {
    private final JetElement subroutine;
    private final Instruction start;

    public TailRecursionDetector(@NotNull JetElement subroutine, @NotNull Instruction start) {
        if (subroutine == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "subroutine", "org/jetbrains/jet/lang/cfg/TailRecursionDetector", "<init>"));
        }
        if (start == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "start", "org/jetbrains/jet/lang/cfg/TailRecursionDetector", "<init>"));
        }
        this.subroutine = subroutine;
        this.start = start;
    }

    @Override
    public Boolean invoke(@NotNull Instruction instruction) {
        if (instruction == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "instruction", "org/jetbrains/jet/lang/cfg/TailRecursionDetector", "invoke"));
        }
        return instruction == this.start || instruction.accept(this) != false;
    }

    @Override
    public Boolean visitInstruction(Instruction instruction) {
        return false;
    }

    @Override
    public Boolean visitSubroutineExit(SubroutineExitInstruction instruction) {
        return !instruction.isError() && instruction.getSubroutine() == this.subroutine;
    }

    @Override
    public Boolean visitSubroutineSink(SubroutineSinkInstruction instruction) {
        return instruction.getSubroutine() == this.subroutine;
    }

    @Override
    public Boolean visitJump(AbstractJumpInstruction instruction) {
        return true;
    }

    @Override
    public Boolean visitThrowExceptionInstruction(ThrowExceptionInstruction instruction) {
        return false;
    }

    @Override
    public Boolean visitMarkInstruction(MarkInstruction instruction) {
        return true;
    }

    @Override
    public Boolean visitMagic(MagicInstruction instruction) {
        return instruction.getSynthetic();
    }
}

