/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.lang.cfg.pseudocode;

import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jet.lang.cfg.pseudocode.Instruction;
import org.jetbrains.jet.lang.cfg.pseudocode.InstructionVisitor;
import org.jetbrains.jet.lang.cfg.pseudocode.InstructionVisitorWithResult;
import org.jetbrains.jet.lang.cfg.pseudocode.InstructionWithReceiver;
import org.jetbrains.jet.lang.cfg.pseudocode.LexicalScope;
import org.jetbrains.jet.lang.cfg.pseudocode.PseudoValue;
import org.jetbrains.jet.lang.cfg.pseudocode.PseudoValueFactory;
import org.jetbrains.jet.lang.psi.JetElement;

public class ReadValueInstruction
extends InstructionWithReceiver {
    private final PseudoValue resultValue;

    private ReadValueInstruction(@NotNull JetElement element, @NotNull LexicalScope lexicalScope, @Nullable PseudoValue receiverValue, @NotNull PseudoValue resultValue) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/jetbrains/jet/lang/cfg/pseudocode/ReadValueInstruction", "<init>"));
        }
        if (lexicalScope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "lexicalScope", "org/jetbrains/jet/lang/cfg/pseudocode/ReadValueInstruction", "<init>"));
        }
        if (resultValue == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "resultValue", "org/jetbrains/jet/lang/cfg/pseudocode/ReadValueInstruction", "<init>"));
        }
        super(element, lexicalScope, receiverValue);
        this.resultValue = resultValue;
    }

    public ReadValueInstruction(@NotNull JetElement element, @NotNull LexicalScope lexicalScope, @Nullable PseudoValue receiverValue, @NotNull PseudoValueFactory valueFactory) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/jetbrains/jet/lang/cfg/pseudocode/ReadValueInstruction", "<init>"));
        }
        if (lexicalScope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "lexicalScope", "org/jetbrains/jet/lang/cfg/pseudocode/ReadValueInstruction", "<init>"));
        }
        if (valueFactory == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "valueFactory", "org/jetbrains/jet/lang/cfg/pseudocode/ReadValueInstruction", "<init>"));
        }
        super(element, lexicalScope, receiverValue);
        this.resultValue = valueFactory.newValue(element, this);
    }

    @Override
    @NotNull
    public PseudoValue getOutputValue() {
        PseudoValue pseudoValue = this.resultValue;
        if (pseudoValue == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/cfg/pseudocode/ReadValueInstruction", "getOutputValue"));
        }
        return pseudoValue;
    }

    @Override
    public void accept(@NotNull InstructionVisitor visitor) {
        if (visitor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "visitor", "org/jetbrains/jet/lang/cfg/pseudocode/ReadValueInstruction", "accept"));
        }
        visitor.visitReadValue(this);
    }

    @Override
    public <R> R accept(@NotNull InstructionVisitorWithResult<R> visitor) {
        if (visitor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "visitor", "org/jetbrains/jet/lang/cfg/pseudocode/ReadValueInstruction", "accept"));
        }
        return visitor.visitReadValue(this);
    }

    public String toString() {
        return "r(" + this.render(this.element) + (this.receiverValue != null ? "|" + this.receiverValue : "") + ") -> " + this.resultValue;
    }

    @Override
    @NotNull
    protected Instruction createCopy() {
        ReadValueInstruction readValueInstruction = new ReadValueInstruction(this.element, this.lexicalScope, this.receiverValue, this.resultValue);
        if (readValueInstruction == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/cfg/pseudocode/ReadValueInstruction", "createCopy"));
        }
        return readValueInstruction;
    }
}

