/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.lang.psi;

import com.intellij.lang.ASTNode;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jet.JetNodeTypes;
import org.jetbrains.jet.lang.psi.JetAnnotated;
import org.jetbrains.jet.lang.psi.JetAnnotation;
import org.jetbrains.jet.lang.psi.JetAnnotationEntry;
import org.jetbrains.jet.lang.psi.JetExpression;
import org.jetbrains.jet.lang.psi.JetExpressionImpl;
import org.jetbrains.jet.lang.psi.JetVisitor;

public class JetAnnotatedExpression
extends JetExpressionImpl
implements JetAnnotated {
    public JetAnnotatedExpression(@NotNull ASTNode node) {
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "org/jetbrains/jet/lang/psi/JetAnnotatedExpression", "<init>"));
        }
        super(node);
    }

    @Override
    public <R, D> R accept(@NotNull JetVisitor<R, D> visitor, D data2) {
        if (visitor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "visitor", "org/jetbrains/jet/lang/psi/JetAnnotatedExpression", "accept"));
        }
        return visitor.visitAnnotatedExpression(this, data2);
    }

    @Nullable
    public JetExpression getBaseExpression() {
        return this.findChildByClass(JetExpression.class);
    }

    @Override
    @NotNull
    public List<JetAnnotation> getAnnotations() {
        List<JetAnnotation> list = this.findChildrenByType(JetNodeTypes.ANNOTATION);
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/psi/JetAnnotatedExpression", "getAnnotations"));
        }
        return list;
    }

    @Override
    @NotNull
    public List<JetAnnotationEntry> getAnnotationEntries() {
        List<JetAnnotationEntry> answer = null;
        for (JetAnnotation annotation : this.getAnnotations()) {
            if (answer == null) {
                answer = new ArrayList<JetAnnotationEntry>();
            }
            answer.addAll(annotation.getEntries());
        }
        List<JetAnnotationEntry> list = answer != null ? answer : Collections.emptyList();
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/psi/JetAnnotatedExpression", "getAnnotationEntries"));
        }
        return list;
    }
}

