/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.lang.psi;

import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jet.lang.psi.JetClass;
import org.jetbrains.jet.lang.psi.JetClassBody;
import org.jetbrains.jet.lang.psi.JetClassObject;
import org.jetbrains.jet.lang.psi.JetClassOrObject;
import org.jetbrains.jet.lang.psi.JetFile;
import org.jetbrains.jet.lang.psi.JetNamedDeclaration;
import org.jetbrains.jet.lang.psi.JetNamedFunction;
import org.jetbrains.jet.lang.psi.JetObjectDeclaration;
import org.jetbrains.jet.lang.psi.JetParameter;
import org.jetbrains.jet.lang.psi.JetPsiUtil;
import org.jetbrains.jet.lang.resolve.name.FqName;
import org.jetbrains.jet.lang.resolve.name.FqNameUnsafe;
import org.jetbrains.jet.lang.resolve.name.Name;

public final class JetNamedDeclarationUtil {
    @Nullable
    public static FqNameUnsafe getUnsafeFQName(@NotNull JetNamedDeclaration namedDeclaration) {
        if (namedDeclaration == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "namedDeclaration", "org/jetbrains/jet/lang/psi/JetNamedDeclarationUtil", "getUnsafeFQName"));
        }
        FqName fqName = namedDeclaration.getFqName();
        return fqName != null ? fqName.toUnsafe() : null;
    }

    @Nullable
    static FqName getFQName(@NotNull JetNamedDeclaration namedDeclaration) {
        if (namedDeclaration == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "namedDeclaration", "org/jetbrains/jet/lang/psi/JetNamedDeclarationUtil", "getFQName"));
        }
        Name name = namedDeclaration.getNameAsName();
        if (name == null) {
            return null;
        }
        FqName parentFqName = JetNamedDeclarationUtil.getParentFqName(namedDeclaration);
        if (parentFqName == null) {
            return null;
        }
        return parentFqName.child(name);
    }

    @Nullable
    public static FqName getParentFqName(@NotNull JetNamedDeclaration namedDeclaration) {
        if (namedDeclaration == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "namedDeclaration", "org/jetbrains/jet/lang/psi/JetNamedDeclarationUtil", "getParentFqName"));
        }
        PsiElement parent = namedDeclaration.getParent();
        if (parent instanceof JetClassBody) {
            parent = parent.getParent();
        }
        if (parent instanceof JetFile) {
            return ((JetFile)parent).getPackageFqName();
        }
        if (parent instanceof JetNamedFunction || parent instanceof JetClass) {
            return JetNamedDeclarationUtil.getFQName((JetNamedDeclaration)parent);
        }
        if (namedDeclaration instanceof JetParameter) {
            JetClass constructorClass = JetPsiUtil.getClassIfParameterIsProperty((JetParameter)namedDeclaration);
            if (constructorClass != null) {
                return JetNamedDeclarationUtil.getFQName(constructorClass);
            }
        } else if (parent instanceof JetObjectDeclaration) {
            if (parent.getParent() instanceof JetClassObject) {
                JetClassOrObject classOrObject = PsiTreeUtil.getParentOfType(parent, JetClassOrObject.class);
                if (classOrObject != null) {
                    return JetNamedDeclarationUtil.getFQName(classOrObject);
                }
            } else {
                return JetNamedDeclarationUtil.getFQName((JetNamedDeclaration)parent);
            }
        }
        return null;
    }

    private JetNamedDeclarationUtil() {
    }
}

