/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.lang.resolve.calls.autocasts;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jet.lang.diagnostics.Errors;
import org.jetbrains.jet.lang.psi.JetExpression;
import org.jetbrains.jet.lang.resolve.BindingContext;
import org.jetbrains.jet.lang.resolve.BindingTrace;
import org.jetbrains.jet.lang.resolve.calls.ArgumentTypeResolver;
import org.jetbrains.jet.lang.resolve.calls.autocasts.DataFlowInfo;
import org.jetbrains.jet.lang.resolve.calls.autocasts.DataFlowValue;
import org.jetbrains.jet.lang.resolve.calls.autocasts.DataFlowValueFactory;
import org.jetbrains.jet.lang.resolve.calls.context.ResolutionContext;
import org.jetbrains.jet.lang.resolve.scopes.receivers.ExpressionReceiver;
import org.jetbrains.jet.lang.resolve.scopes.receivers.ReceiverValue;
import org.jetbrains.jet.lang.resolve.scopes.receivers.ThisReceiver;
import org.jetbrains.jet.lang.types.JetType;
import org.jetbrains.jet.lang.types.TypeUtils;
import org.jetbrains.jet.lang.types.checker.JetTypeChecker;

public class AutoCastUtils {
    private AutoCastUtils() {
    }

    public static List<JetType> getAutoCastVariants(@NotNull ReceiverValue receiverToCast, @NotNull ResolutionContext context) {
        if (receiverToCast == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "receiverToCast", "org/jetbrains/jet/lang/resolve/calls/autocasts/AutoCastUtils", "getAutoCastVariants"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/jet/lang/resolve/calls/autocasts/AutoCastUtils", "getAutoCastVariants"));
        }
        return AutoCastUtils.getAutoCastVariants(receiverToCast, context.trace.getBindingContext(), context.dataFlowInfo);
    }

    public static List<JetType> getAutoCastVariants(@NotNull ReceiverValue receiverToCast, @NotNull BindingContext bindingContext, @NotNull DataFlowInfo dataFlowInfo) {
        if (receiverToCast == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "receiverToCast", "org/jetbrains/jet/lang/resolve/calls/autocasts/AutoCastUtils", "getAutoCastVariants"));
        }
        if (bindingContext == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "bindingContext", "org/jetbrains/jet/lang/resolve/calls/autocasts/AutoCastUtils", "getAutoCastVariants"));
        }
        if (dataFlowInfo == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataFlowInfo", "org/jetbrains/jet/lang/resolve/calls/autocasts/AutoCastUtils", "getAutoCastVariants"));
        }
        ArrayList<JetType> variants = Lists.newArrayList();
        variants.add(receiverToCast.getType());
        variants.addAll(AutoCastUtils.getAutoCastVariantsExcludingReceiver(bindingContext, dataFlowInfo, receiverToCast));
        return variants;
    }

    @NotNull
    public static List<JetType> getAutoCastVariantsExcludingReceiver(@NotNull BindingContext bindingContext, @NotNull DataFlowInfo dataFlowInfo, @NotNull ReceiverValue receiverToCast) {
        if (bindingContext == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "bindingContext", "org/jetbrains/jet/lang/resolve/calls/autocasts/AutoCastUtils", "getAutoCastVariantsExcludingReceiver"));
        }
        if (dataFlowInfo == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataFlowInfo", "org/jetbrains/jet/lang/resolve/calls/autocasts/AutoCastUtils", "getAutoCastVariantsExcludingReceiver"));
        }
        if (receiverToCast == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "receiverToCast", "org/jetbrains/jet/lang/resolve/calls/autocasts/AutoCastUtils", "getAutoCastVariantsExcludingReceiver"));
        }
        if (receiverToCast instanceof ThisReceiver) {
            ThisReceiver receiver = (ThisReceiver)receiverToCast;
            assert (receiver.exists());
            DataFlowValue dataFlowValue = DataFlowValueFactory.createDataFlowValue(receiver);
            List<JetType> list = AutoCastUtils.collectAutoCastReceiverValues(dataFlowInfo, dataFlowValue);
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/calls/autocasts/AutoCastUtils", "getAutoCastVariantsExcludingReceiver"));
            }
            return list;
        }
        if (receiverToCast instanceof ExpressionReceiver) {
            ExpressionReceiver receiver = (ExpressionReceiver)receiverToCast;
            DataFlowValue dataFlowValue = DataFlowValueFactory.createDataFlowValue(receiver.getExpression(), receiver.getType(), bindingContext);
            List<JetType> list = AutoCastUtils.collectAutoCastReceiverValues(dataFlowInfo, dataFlowValue);
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/calls/autocasts/AutoCastUtils", "getAutoCastVariantsExcludingReceiver"));
            }
            return list;
        }
        List<JetType> list = Collections.emptyList();
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/calls/autocasts/AutoCastUtils", "getAutoCastVariantsExcludingReceiver"));
        }
        return list;
    }

    @NotNull
    private static List<JetType> collectAutoCastReceiverValues(@NotNull DataFlowInfo dataFlowInfo, @NotNull DataFlowValue dataFlowValue) {
        if (dataFlowInfo == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataFlowInfo", "org/jetbrains/jet/lang/resolve/calls/autocasts/AutoCastUtils", "collectAutoCastReceiverValues"));
        }
        if (dataFlowValue == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataFlowValue", "org/jetbrains/jet/lang/resolve/calls/autocasts/AutoCastUtils", "collectAutoCastReceiverValues"));
        }
        ArrayList<JetType> arrayList = Lists.newArrayList(dataFlowInfo.getPossibleTypes(dataFlowValue));
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/calls/autocasts/AutoCastUtils", "collectAutoCastReceiverValues"));
        }
        return arrayList;
    }

    public static boolean isSubTypeByAutoCastIgnoringNullability(@NotNull ReceiverValue receiverArgument2, @NotNull JetType receiverParameterType, @NotNull ResolutionContext context) {
        if (receiverArgument2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "receiverArgument", "org/jetbrains/jet/lang/resolve/calls/autocasts/AutoCastUtils", "isSubTypeByAutoCastIgnoringNullability"));
        }
        if (receiverParameterType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "receiverParameterType", "org/jetbrains/jet/lang/resolve/calls/autocasts/AutoCastUtils", "isSubTypeByAutoCastIgnoringNullability"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/jet/lang/resolve/calls/autocasts/AutoCastUtils", "isSubTypeByAutoCastIgnoringNullability"));
        }
        List<JetType> autoCastTypes = AutoCastUtils.getAutoCastVariants(receiverArgument2, context);
        return AutoCastUtils.getAutoCastSubType(TypeUtils.makeNullable(receiverParameterType), autoCastTypes) != null;
    }

    @Nullable
    private static JetType getAutoCastSubType(@NotNull JetType receiverParameterType, @NotNull List<JetType> autoCastTypes) {
        if (receiverParameterType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "receiverParameterType", "org/jetbrains/jet/lang/resolve/calls/autocasts/AutoCastUtils", "getAutoCastSubType"));
        }
        if (autoCastTypes == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "autoCastTypes", "org/jetbrains/jet/lang/resolve/calls/autocasts/AutoCastUtils", "getAutoCastSubType"));
        }
        HashSet<JetType> subTypes = Sets.newHashSet();
        for (JetType autoCastType : autoCastTypes) {
            if (!ArgumentTypeResolver.isSubtypeOfForArgumentType(autoCastType, receiverParameterType)) continue;
            subTypes.add(autoCastType);
        }
        if (subTypes.isEmpty()) {
            return null;
        }
        JetType intersection = TypeUtils.intersect(JetTypeChecker.INSTANCE, subTypes);
        if (intersection == null || !intersection.getConstructor().isDenotable()) {
            return receiverParameterType;
        }
        return intersection;
    }

    public static boolean recordAutoCastIfNecessary(@NotNull ReceiverValue receiver, @NotNull JetType receiverParameterType, @NotNull ResolutionContext context, boolean safeAccess) {
        if (receiver == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "receiver", "org/jetbrains/jet/lang/resolve/calls/autocasts/AutoCastUtils", "recordAutoCastIfNecessary"));
        }
        if (receiverParameterType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "receiverParameterType", "org/jetbrains/jet/lang/resolve/calls/autocasts/AutoCastUtils", "recordAutoCastIfNecessary"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/jet/lang/resolve/calls/autocasts/AutoCastUtils", "recordAutoCastIfNecessary"));
        }
        if (!(receiver instanceof ExpressionReceiver)) {
            return false;
        }
        JetType jetType = receiverParameterType = safeAccess ? TypeUtils.makeNullable(receiverParameterType) : receiverParameterType;
        if (ArgumentTypeResolver.isSubtypeOfForArgumentType(receiver.getType(), receiverParameterType)) {
            return false;
        }
        List<JetType> autoCastTypesExcludingReceiver = AutoCastUtils.getAutoCastVariantsExcludingReceiver(context.trace.getBindingContext(), context.dataFlowInfo, receiver);
        JetType autoCastSubType = AutoCastUtils.getAutoCastSubType(receiverParameterType, autoCastTypesExcludingReceiver);
        if (autoCastSubType == null) {
            return false;
        }
        JetExpression expression = ((ExpressionReceiver)receiver).getExpression();
        DataFlowValue dataFlowValue = DataFlowValueFactory.createDataFlowValue(receiver, context.trace.getBindingContext());
        AutoCastUtils.recordCastOrError(expression, autoCastSubType, context.trace, dataFlowValue.isStableIdentifier(), true);
        return true;
    }

    public static void recordCastOrError(@NotNull JetExpression expression, @NotNull JetType type, @NotNull BindingTrace trace, boolean canBeCasted, boolean recordExpressionType) {
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/jet/lang/resolve/calls/autocasts/AutoCastUtils", "recordCastOrError"));
        }
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "org/jetbrains/jet/lang/resolve/calls/autocasts/AutoCastUtils", "recordCastOrError"));
        }
        if (trace == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "trace", "org/jetbrains/jet/lang/resolve/calls/autocasts/AutoCastUtils", "recordCastOrError"));
        }
        if (canBeCasted) {
            trace.record(BindingContext.AUTOCAST, expression, type);
            if (recordExpressionType) {
                trace.record(BindingContext.EXPRESSION_TYPE, expression, type);
            }
        } else {
            trace.report(Errors.AUTOCAST_IMPOSSIBLE.on(expression, type, expression.getText()));
        }
    }

    public static boolean isNotNull(@NotNull ReceiverValue receiver, @NotNull BindingContext bindingContext, @NotNull DataFlowInfo dataFlowInfo) {
        if (receiver == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "receiver", "org/jetbrains/jet/lang/resolve/calls/autocasts/AutoCastUtils", "isNotNull"));
        }
        if (bindingContext == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "bindingContext", "org/jetbrains/jet/lang/resolve/calls/autocasts/AutoCastUtils", "isNotNull"));
        }
        if (dataFlowInfo == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataFlowInfo", "org/jetbrains/jet/lang/resolve/calls/autocasts/AutoCastUtils", "isNotNull"));
        }
        if (!receiver.getType().isNullable()) {
            return true;
        }
        List<JetType> autoCastVariants = AutoCastUtils.getAutoCastVariants(receiver, bindingContext, dataFlowInfo);
        for (JetType autoCastVariant : autoCastVariants) {
            if (autoCastVariant.isNullable()) continue;
            return true;
        }
        return false;
    }
}

