/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.lang.resolve.java;

import java.util.HashMap;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jet.lang.types.lang.KotlinBuiltIns;
import org.jetbrains.org.objectweb.asm.Type;

public class AsmTypeConstants {
    private static final Map<Class<?>, Type> TYPES_MAP = new HashMap();
    public static final Type OBJECT_TYPE = AsmTypeConstants.getType(Object.class);
    public static final Type JAVA_STRING_TYPE = AsmTypeConstants.getType(String.class);
    public static final Type JAVA_THROWABLE_TYPE = AsmTypeConstants.getType(Throwable.class);
    public static final Type UNIT_TYPE = Type.getObjectType(KotlinBuiltIns.BUILT_INS_PACKAGE_FQ_NAME + "/Unit");
    public static final Type FUNCTION0_TYPE = Type.getObjectType(KotlinBuiltIns.BUILT_INS_PACKAGE_FQ_NAME + "/Function0");
    public static final Type FUNCTION1_TYPE = Type.getObjectType(KotlinBuiltIns.BUILT_INS_PACKAGE_FQ_NAME + "/Function1");
    public static final Type INT_RANGE_TYPE = Type.getObjectType(KotlinBuiltIns.BUILT_INS_PACKAGE_FQ_NAME + "/IntRange");
    public static final Type PROPERTY_METADATA_TYPE = Type.getObjectType(KotlinBuiltIns.BUILT_INS_PACKAGE_FQ_NAME + "/PropertyMetadata");
    public static final Type PROPERTY_METADATA_IMPL_TYPE = Type.getObjectType(KotlinBuiltIns.BUILT_INS_PACKAGE_FQ_NAME + "/PropertyMetadataImpl");
    public static final Type OBJECT_REF_TYPE = Type.getObjectType("kotlin/jvm/internal/Ref$ObjectRef");

    public static Type getType(@NotNull Class<?> javaClass) {
        if (javaClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "javaClass", "org/jetbrains/jet/lang/resolve/java/AsmTypeConstants", "getType"));
        }
        Type type = TYPES_MAP.get(javaClass);
        if (type == null) {
            type = Type.getType(javaClass);
            TYPES_MAP.put(javaClass, type);
        }
        return type;
    }

    private AsmTypeConstants() {
    }
}

