/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.lang.resolve.scopes;

import com.google.common.base.Function;
import com.google.common.collect.Collections2;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jet.lang.descriptors.CallableDescriptor;
import org.jetbrains.jet.lang.descriptors.DeclarationDescriptor;
import org.jetbrains.jet.lang.descriptors.PropertyDescriptor;
import org.jetbrains.jet.lang.descriptors.ReceiverParameterDescriptor;
import org.jetbrains.jet.lang.descriptors.TypeParameterDescriptor;
import org.jetbrains.jet.lang.resolve.BindingTrace;
import org.jetbrains.jet.lang.resolve.TraceBasedRedeclarationHandler;
import org.jetbrains.jet.lang.resolve.scopes.JetScope;
import org.jetbrains.jet.lang.resolve.scopes.WritableScope;
import org.jetbrains.jet.lang.resolve.scopes.WritableScopeImpl;
import org.jetbrains.jet.lang.resolve.scopes.receivers.ReceiverValue;
import org.jetbrains.jet.utils.Printer;

public final class JetScopeUtils {
    private JetScopeUtils() {
    }

    public static List<ReceiverValue> getImplicitReceiversHierarchyValues(@NotNull JetScope scope) {
        if (scope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "org/jetbrains/jet/lang/resolve/scopes/JetScopeUtils", "getImplicitReceiversHierarchyValues"));
        }
        List<ReceiverParameterDescriptor> hierarchy = scope.getImplicitReceiversHierarchy();
        return Lists.newArrayList(Collections2.transform(hierarchy, new Function<ReceiverParameterDescriptor, ReceiverValue>(){

            @Override
            public ReceiverValue apply(ReceiverParameterDescriptor receiverParameterDescriptor) {
                return receiverParameterDescriptor.getValue();
            }
        }));
    }

    public static Collection<CallableDescriptor> getAllExtensions(@NotNull JetScope scope) {
        if (scope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "org/jetbrains/jet/lang/resolve/scopes/JetScopeUtils", "getAllExtensions"));
        }
        HashSet<CallableDescriptor> result2 = Sets.newHashSet();
        for (DeclarationDescriptor descriptor : scope.getAllDescriptors()) {
            CallableDescriptor callDescriptor;
            if (!(descriptor instanceof CallableDescriptor) || (callDescriptor = (CallableDescriptor)descriptor).getReceiverParameter() == null) continue;
            result2.add(callDescriptor);
        }
        return result2;
    }

    public static JetScope makeScopeForPropertyAccessor(@NotNull PropertyDescriptor propertyDescriptor, @NotNull JetScope parentScope, @NotNull BindingTrace trace) {
        if (propertyDescriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "propertyDescriptor", "org/jetbrains/jet/lang/resolve/scopes/JetScopeUtils", "makeScopeForPropertyAccessor"));
        }
        if (parentScope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parentScope", "org/jetbrains/jet/lang/resolve/scopes/JetScopeUtils", "makeScopeForPropertyAccessor"));
        }
        if (trace == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "trace", "org/jetbrains/jet/lang/resolve/scopes/JetScopeUtils", "makeScopeForPropertyAccessor"));
        }
        JetScope propertyDeclarationInnerScope = JetScopeUtils.getPropertyDeclarationInnerScope(propertyDescriptor, parentScope, propertyDescriptor.getTypeParameters(), propertyDescriptor.getReceiverParameter(), trace);
        WritableScopeImpl accessorScope = new WritableScopeImpl(propertyDeclarationInnerScope, parentScope.getContainingDeclaration(), new TraceBasedRedeclarationHandler(trace), "Accessor Scope");
        accessorScope.changeLockLevel(WritableScope.LockLevel.READING);
        return accessorScope;
    }

    public static JetScope getPropertyDeclarationInnerScope(@NotNull PropertyDescriptor propertyDescriptor, @NotNull JetScope outerScope, @NotNull List<? extends TypeParameterDescriptor> typeParameters, @Nullable ReceiverParameterDescriptor receiver, BindingTrace trace) {
        if (propertyDescriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "propertyDescriptor", "org/jetbrains/jet/lang/resolve/scopes/JetScopeUtils", "getPropertyDeclarationInnerScope"));
        }
        if (outerScope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "outerScope", "org/jetbrains/jet/lang/resolve/scopes/JetScopeUtils", "getPropertyDeclarationInnerScope"));
        }
        if (typeParameters == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "typeParameters", "org/jetbrains/jet/lang/resolve/scopes/JetScopeUtils", "getPropertyDeclarationInnerScope"));
        }
        return JetScopeUtils.getPropertyDeclarationInnerScope(propertyDescriptor, outerScope, typeParameters, receiver, trace, true);
    }

    public static JetScope getPropertyDeclarationInnerScopeForInitializer(@NotNull JetScope outerScope, @NotNull List<? extends TypeParameterDescriptor> typeParameters, @Nullable ReceiverParameterDescriptor receiver, BindingTrace trace) {
        if (outerScope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "outerScope", "org/jetbrains/jet/lang/resolve/scopes/JetScopeUtils", "getPropertyDeclarationInnerScopeForInitializer"));
        }
        if (typeParameters == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "typeParameters", "org/jetbrains/jet/lang/resolve/scopes/JetScopeUtils", "getPropertyDeclarationInnerScopeForInitializer"));
        }
        return JetScopeUtils.getPropertyDeclarationInnerScope(null, outerScope, typeParameters, receiver, trace, false);
    }

    private static JetScope getPropertyDeclarationInnerScope(@Nullable PropertyDescriptor propertyDescriptor, @NotNull JetScope outerScope, @NotNull List<? extends TypeParameterDescriptor> typeParameters, @Nullable ReceiverParameterDescriptor receiver, BindingTrace trace, boolean addLabelForProperty) {
        if (outerScope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "outerScope", "org/jetbrains/jet/lang/resolve/scopes/JetScopeUtils", "getPropertyDeclarationInnerScope"));
        }
        if (typeParameters == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "typeParameters", "org/jetbrains/jet/lang/resolve/scopes/JetScopeUtils", "getPropertyDeclarationInnerScope"));
        }
        WritableScopeImpl result2 = new WritableScopeImpl(outerScope, outerScope.getContainingDeclaration(), new TraceBasedRedeclarationHandler(trace), "Property declaration inner scope");
        if (addLabelForProperty) {
            assert (propertyDescriptor != null) : "PropertyDescriptor can be null for property scope which hasn't label to property";
            result2.addLabeledDeclaration(propertyDescriptor);
        }
        for (TypeParameterDescriptor typeParameterDescriptor : typeParameters) {
            result2.addTypeParameterDescriptor(typeParameterDescriptor);
        }
        if (receiver != null) {
            result2.setImplicitReceiver(receiver);
        }
        result2.changeLockLevel(WritableScope.LockLevel.READING);
        return result2;
    }

    @NotNull
    public static String printStructure(@Nullable JetScope scope) {
        StringBuilder out = new StringBuilder();
        Printer p = new Printer(out);
        if (scope == null) {
            p.println("null");
        } else {
            scope.printScopeStructure(p);
        }
        String string = out.toString();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/scopes/JetScopeUtils", "printStructure"));
        }
        return string;
    }
}

