/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.lang.types;

import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jet.lang.descriptors.annotations.Annotations;
import org.jetbrains.jet.lang.resolve.name.Name;
import org.jetbrains.jet.lang.resolve.scopes.JetScope;
import org.jetbrains.jet.lang.resolve.scopes.receivers.ReceiverValue;
import org.jetbrains.jet.lang.types.JetType;
import org.jetbrains.jet.lang.types.TypeConstructor;
import org.jetbrains.jet.lang.types.TypeProjection;

public class PackageType
implements JetType {
    private final Name name;
    private final JetScope memberScope;
    private final ReceiverValue receiver;

    public PackageType(@NotNull Name name, @NotNull JetScope memberScope, @NotNull ReceiverValue receiver) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "org/jetbrains/jet/lang/types/PackageType", "<init>"));
        }
        if (memberScope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "memberScope", "org/jetbrains/jet/lang/types/PackageType", "<init>"));
        }
        if (receiver == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "receiver", "org/jetbrains/jet/lang/types/PackageType", "<init>"));
        }
        this.name = name;
        this.memberScope = memberScope;
        this.receiver = receiver;
    }

    @Override
    @NotNull
    public JetScope getMemberScope() {
        JetScope jetScope = this.memberScope;
        if (jetScope == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/types/PackageType", "getMemberScope"));
        }
        return jetScope;
    }

    @Override
    public boolean isError() {
        return false;
    }

    @NotNull
    public ReceiverValue getReceiverValue() {
        ReceiverValue receiverValue = this.receiver;
        if (receiverValue == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/types/PackageType", "getReceiverValue"));
        }
        return receiverValue;
    }

    @Override
    @NotNull
    public TypeConstructor getConstructor() {
        TypeConstructor typeConstructor = this.throwException();
        if (typeConstructor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/types/PackageType", "getConstructor"));
        }
        return typeConstructor;
    }

    private TypeConstructor throwException() {
        throw new UnsupportedOperationException("Only member lookup is allowed on a package type " + this.name);
    }

    @Override
    @NotNull
    public List<TypeProjection> getArguments() {
        this.throwException();
        if (null == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/types/PackageType", "getArguments"));
        }
        return null;
    }

    @Override
    public boolean isNullable() {
        this.throwException();
        return false;
    }

    @Override
    @NotNull
    public Annotations getAnnotations() {
        this.throwException();
        if (null == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/types/PackageType", "getAnnotations"));
        }
        return null;
    }

    public String toString() {
        return "[Package-type " + this.name + "]";
    }
}

