/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.scope.conflictResolvers;

import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiLocalVariable;
import com.intellij.psi.infos.CandidateInfo;
import com.intellij.psi.scope.PsiConflictResolver;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class JavaVariableConflictResolver
implements PsiConflictResolver {
    @Override
    public CandidateInfo resolveConflict(@NotNull List<CandidateInfo> conflicts) {
        if (conflicts == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/psi/scope/conflictResolvers/JavaVariableConflictResolver", "resolveConflict"));
        }
        int size = conflicts.size();
        if (size == 1) {
            return conflicts.get(0);
        }
        if (size == 0) {
            return null;
        }
        CandidateInfo[] uncheckedResult = conflicts.toArray(new CandidateInfo[size]);
        CandidateInfo currentResult = uncheckedResult[0];
        PsiElement currentElement = currentResult.getElement();
        if (currentElement instanceof PsiField) {
            for (int i = 1; i < uncheckedResult.length; ++i) {
                CandidateInfo candidate = uncheckedResult[i];
                PsiElement otherElement = candidate.getElement();
                if (otherElement == null) continue;
                if (!(otherElement instanceof PsiField)) {
                    if (otherElement instanceof PsiLocalVariable) {
                        return candidate;
                    }
                    if (!currentResult.isAccessible()) {
                        return candidate;
                    }
                    conflicts.remove(candidate);
                    continue;
                }
                PsiClass newClass = ((PsiField)otherElement).getContainingClass();
                PsiClass oldClass = ((PsiField)currentElement).getContainingClass();
                PsiElement scope = currentResult.getCurrentFileResolveScope();
                Boolean oldClassIsInheritor = null;
                if (newClass != null && oldClass != null) {
                    if (newClass.isInheritor(oldClass, true)) {
                        if (!(scope instanceof PsiClass) || scope.equals(oldClass) || scope.equals(newClass) || !((PsiClass)scope).isInheritorDeep(oldClass, newClass)) {
                            conflicts.remove(currentResult);
                            currentResult = candidate;
                            currentElement = currentResult.getElement();
                            continue;
                        }
                    } else {
                        oldClassIsInheritor = oldClass.isInheritor(newClass, true);
                        if (oldClassIsInheritor.booleanValue() && (!(scope instanceof PsiClass) || scope.equals(oldClass) || scope.equals(newClass) || !((PsiClass)scope).isInheritorDeep(newClass, oldClass))) {
                            conflicts.remove(candidate);
                            continue;
                        }
                    }
                }
                if (!candidate.isAccessible()) {
                    conflicts.remove(candidate);
                    continue;
                }
                if (!currentResult.isAccessible()) {
                    conflicts.remove(currentResult);
                    currentResult = candidate;
                    currentElement = currentResult.getElement();
                    continue;
                }
                if (otherElement == currentElement) {
                    conflicts.remove(candidate);
                    continue;
                }
                if (oldClassIsInheritor == null) {
                    oldClassIsInheritor = oldClass != null && newClass != null && oldClass.isInheritor(newClass, true);
                }
                if (oldClassIsInheritor.booleanValue()) {
                    conflicts.remove(candidate);
                    continue;
                }
                return null;
            }
        }
        return currentResult;
    }
}

