/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.codegen;

import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.asm4.Type;
import org.jetbrains.jet.lang.descriptors.ClassDescriptor;
import org.jetbrains.jet.lang.descriptors.ClassKind;
import org.jetbrains.jet.lang.descriptors.FunctionDescriptor;
import org.jetbrains.jet.lang.descriptors.Modality;
import org.jetbrains.jet.lang.descriptors.ModuleDescriptorImpl;
import org.jetbrains.jet.lang.descriptors.PackageFragmentDescriptor;
import org.jetbrains.jet.lang.descriptors.ReceiverParameterDescriptor;
import org.jetbrains.jet.lang.descriptors.ValueParameterDescriptor;
import org.jetbrains.jet.lang.descriptors.Visibilities;
import org.jetbrains.jet.lang.descriptors.impl.MutableClassDescriptor;
import org.jetbrains.jet.lang.descriptors.impl.MutablePackageFragmentDescriptor;
import org.jetbrains.jet.lang.resolve.ImportPath;
import org.jetbrains.jet.lang.resolve.java.mapping.JavaToKotlinClassMap;
import org.jetbrains.jet.lang.resolve.name.FqName;
import org.jetbrains.jet.lang.resolve.name.Name;
import org.jetbrains.jet.lang.types.JetType;
import org.jetbrains.jet.lang.types.JetTypeImpl;
import org.jetbrains.jet.lang.types.TypeProjectionImpl;
import org.jetbrains.jet.lang.types.lang.KotlinBuiltIns;

public class FunctionTypesUtil {
    private static final List<ClassDescriptor> FUNCTIONS;
    private static final List<ClassDescriptor> EXTENSION_FUNCTIONS;
    private static final List<ClassDescriptor> K_FUNCTIONS;
    private static final List<ClassDescriptor> K_MEMBER_FUNCTIONS;
    private static final List<ClassDescriptor> K_EXTENSION_FUNCTIONS;
    private static final ImmutableMap<ClassDescriptor, ClassDescriptor> FUNCTION_TO_IMPL;

    private FunctionTypesUtil() {
    }

    @Nullable
    public static ClassDescriptor functionTypeToImpl(@NotNull JetType functionType) {
        if (functionType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "functionType", "org/jetbrains/jet/codegen/FunctionTypesUtil", "functionTypeToImpl"));
        }
        return FUNCTION_TO_IMPL.get(functionType.getConstructor().getDeclarationDescriptor());
    }

    @NotNull
    public static JetType getSuperTypeForClosure(@NotNull FunctionDescriptor descriptor, boolean kFunction) {
        if (descriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "org/jetbrains/jet/codegen/FunctionTypesUtil", "getSuperTypeForClosure"));
        }
        int arity = descriptor.getValueParameters().size();
        ReceiverParameterDescriptor receiverParameter = descriptor.getReceiverParameter();
        ReceiverParameterDescriptor expectedThisObject = descriptor.getExpectedThisObject();
        ArrayList<TypeProjectionImpl> typeArguments = new ArrayList<TypeProjectionImpl>(arity + 2);
        if (receiverParameter != null) {
            typeArguments.add(new TypeProjectionImpl(receiverParameter.getType()));
        } else if (kFunction && expectedThisObject != null) {
            typeArguments.add(new TypeProjectionImpl(expectedThisObject.getType()));
        }
        for (ValueParameterDescriptor parameter : descriptor.getValueParameters()) {
            typeArguments.add(new TypeProjectionImpl(parameter.getType()));
        }
        typeArguments.add(new TypeProjectionImpl(descriptor.getReturnType()));
        ClassDescriptor classDescriptor = kFunction ? (expectedThisObject != null ? K_MEMBER_FUNCTIONS.get(arity) : (receiverParameter != null ? K_EXTENSION_FUNCTIONS.get(arity) : K_FUNCTIONS.get(arity))) : (receiverParameter != null ? EXTENSION_FUNCTIONS.get(arity) : FUNCTIONS.get(arity));
        JetTypeImpl jetTypeImpl = new JetTypeImpl(classDescriptor.getDefaultType().getAnnotations(), classDescriptor.getTypeConstructor(), false, typeArguments, classDescriptor.getMemberScope(typeArguments));
        if (jetTypeImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/codegen/FunctionTypesUtil", "getSuperTypeForClosure"));
        }
        return jetTypeImpl;
    }

    private static void createFunctionImpl(@NotNull List<ClassDescriptor> result2, @NotNull PackageFragmentDescriptor containingDeclaration, @NotNull String name, @NotNull ClassDescriptor functionInterface) {
        if (result2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "org/jetbrains/jet/codegen/FunctionTypesUtil", "createFunctionImpl"));
        }
        if (containingDeclaration == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "containingDeclaration", "org/jetbrains/jet/codegen/FunctionTypesUtil", "createFunctionImpl"));
        }
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "org/jetbrains/jet/codegen/FunctionTypesUtil", "createFunctionImpl"));
        }
        if (functionInterface == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "functionInterface", "org/jetbrains/jet/codegen/FunctionTypesUtil", "createFunctionImpl"));
        }
        MutableClassDescriptor functionImpl = new MutableClassDescriptor(containingDeclaration, containingDeclaration.getMemberScope(), ClassKind.CLASS, false, Name.identifier(name));
        functionImpl.setModality(Modality.FINAL);
        functionImpl.setVisibility(Visibilities.PUBLIC);
        functionImpl.setTypeParameterDescriptors(functionInterface.getDefaultType().getConstructor().getParameters());
        functionImpl.createTypeConstructor();
        result2.add(functionImpl);
    }

    @NotNull
    public static Type getFunctionTraitClassName(@NotNull FunctionDescriptor descriptor) {
        if (descriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "org/jetbrains/jet/codegen/FunctionTypesUtil", "getFunctionTraitClassName"));
        }
        int paramCount = descriptor.getValueParameters().size();
        if (descriptor.getReceiverParameter() != null) {
            Type type = Type.getObjectType(KotlinBuiltIns.BUILT_INS_PACKAGE_FQ_NAME + "/ExtensionFunction" + paramCount);
            if (type == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/codegen/FunctionTypesUtil", "getFunctionTraitClassName"));
            }
            return type;
        }
        Type type = Type.getObjectType(KotlinBuiltIns.BUILT_INS_PACKAGE_FQ_NAME + "/Function" + paramCount);
        if (type == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/codegen/FunctionTypesUtil", "getFunctionTraitClassName"));
        }
        return type;
    }

    @NotNull
    public static Type getFunctionImplType(@NotNull FunctionDescriptor descriptor) {
        if (descriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "org/jetbrains/jet/codegen/FunctionTypesUtil", "getFunctionImplType"));
        }
        int paramCount = descriptor.getValueParameters().size();
        if (descriptor.getReceiverParameter() != null) {
            Type type = Type.getObjectType("kotlin/ExtensionFunctionImpl" + paramCount);
            if (type == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/codegen/FunctionTypesUtil", "getFunctionImplType"));
            }
            return type;
        }
        Type type = Type.getObjectType("kotlin/FunctionImpl" + paramCount);
        if (type == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/codegen/FunctionTypesUtil", "getFunctionImplType"));
        }
        return type;
    }

    static {
        int n = 23;
        FUNCTIONS = new ArrayList<ClassDescriptor>(n);
        EXTENSION_FUNCTIONS = new ArrayList<ClassDescriptor>(n);
        K_FUNCTIONS = new ArrayList<ClassDescriptor>(n);
        K_MEMBER_FUNCTIONS = new ArrayList<ClassDescriptor>(n);
        K_EXTENSION_FUNCTIONS = new ArrayList<ClassDescriptor>(n);
        ModuleDescriptorImpl module = new ModuleDescriptorImpl(Name.special("<fake module for functions impl>"), Collections.<ImportPath>emptyList(), JavaToKotlinClassMap.getInstance());
        MutablePackageFragmentDescriptor kotlin = new MutablePackageFragmentDescriptor(module, new FqName("kotlin"));
        MutablePackageFragmentDescriptor reflect = new MutablePackageFragmentDescriptor(module, new FqName("kotlin.reflect"));
        KotlinBuiltIns builtIns = KotlinBuiltIns.getInstance();
        for (int i = 0; i < n; ++i) {
            FunctionTypesUtil.createFunctionImpl(FUNCTIONS, kotlin, "FunctionImpl" + i, builtIns.getFunction(i));
            FunctionTypesUtil.createFunctionImpl(EXTENSION_FUNCTIONS, kotlin, "ExtensionFunctionImpl" + i, builtIns.getExtensionFunction(i));
            FunctionTypesUtil.createFunctionImpl(K_FUNCTIONS, reflect, "KFunctionImpl" + i, builtIns.getKFunction(i));
            FunctionTypesUtil.createFunctionImpl(K_MEMBER_FUNCTIONS, reflect, "KMemberFunctionImpl" + i, builtIns.getKMemberFunction(i));
            FunctionTypesUtil.createFunctionImpl(K_EXTENSION_FUNCTIONS, reflect, "KExtensionFunctionImpl" + i, builtIns.getKExtensionFunction(i));
        }
        ImmutableMap.Builder<ClassDescriptor, ClassDescriptor> builder = ImmutableMap.builder();
        for (int i = 0; i < n; ++i) {
            builder.put(builtIns.getKFunction(i), K_FUNCTIONS.get(i));
            builder.put(builtIns.getKMemberFunction(i), K_MEMBER_FUNCTIONS.get(i));
            builder.put(builtIns.getKExtensionFunction(i), K_EXTENSION_FUNCTIONS.get(i));
        }
        FUNCTION_TO_IMPL = builder.build();
    }
}

