/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.codegen;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.util.Pair;
import com.intellij.psi.PsiElement;
import com.intellij.util.ArrayUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.asm4.AnnotationVisitor;
import org.jetbrains.asm4.FieldVisitor;
import org.jetbrains.asm4.Label;
import org.jetbrains.asm4.MethodVisitor;
import org.jetbrains.asm4.Type;
import org.jetbrains.asm4.commons.InstructionAdapter;
import org.jetbrains.asm4.commons.Method;
import org.jetbrains.jet.codegen.AnnotationCodegen;
import org.jetbrains.jet.codegen.AsmUtil;
import org.jetbrains.jet.codegen.CallableMethod;
import org.jetbrains.jet.codegen.ClassBodyCodegen;
import org.jetbrains.jet.codegen.ClassBuilder;
import org.jetbrains.jet.codegen.ClassBuilderMode;
import org.jetbrains.jet.codegen.ClosureCodegen;
import org.jetbrains.jet.codegen.CodegenUtil;
import org.jetbrains.jet.codegen.CompilationException;
import org.jetbrains.jet.codegen.ConstructorFrameMap;
import org.jetbrains.jet.codegen.DefaultParameterValueLoader;
import org.jetbrains.jet.codegen.ExpressionCodegen;
import org.jetbrains.jet.codegen.FieldInfo;
import org.jetbrains.jet.codegen.FrameMap;
import org.jetbrains.jet.codegen.FunctionCodegen;
import org.jetbrains.jet.codegen.FunctionGenerationStrategy;
import org.jetbrains.jet.codegen.JavaSerializerExtension;
import org.jetbrains.jet.codegen.MemberCodegen;
import org.jetbrains.jet.codegen.MethodKind;
import org.jetbrains.jet.codegen.OwnerKind;
import org.jetbrains.jet.codegen.PackageCodegen;
import org.jetbrains.jet.codegen.PropertyCodegen;
import org.jetbrains.jet.codegen.StackValue;
import org.jetbrains.jet.codegen.binding.CalculatedClosure;
import org.jetbrains.jet.codegen.binding.CodegenBinding;
import org.jetbrains.jet.codegen.binding.MutableClosure;
import org.jetbrains.jet.codegen.context.ClassContext;
import org.jetbrains.jet.codegen.context.ConstructorContext;
import org.jetbrains.jet.codegen.context.MethodContext;
import org.jetbrains.jet.codegen.signature.BothSignatureWriter;
import org.jetbrains.jet.codegen.signature.JvmClassSignature;
import org.jetbrains.jet.codegen.signature.JvmMethodParameterKind;
import org.jetbrains.jet.codegen.signature.JvmMethodParameterSignature;
import org.jetbrains.jet.codegen.signature.JvmMethodSignature;
import org.jetbrains.jet.codegen.state.GenerationState;
import org.jetbrains.jet.codegen.state.JetTypeMapper;
import org.jetbrains.jet.descriptors.serialization.BitEncoding;
import org.jetbrains.jet.descriptors.serialization.ClassData;
import org.jetbrains.jet.descriptors.serialization.DescriptorSerializer;
import org.jetbrains.jet.descriptors.serialization.NameSerializationUtil;
import org.jetbrains.jet.descriptors.serialization.ProtoBuf;
import org.jetbrains.jet.lang.descriptors.CallableDescriptor;
import org.jetbrains.jet.lang.descriptors.CallableMemberDescriptor;
import org.jetbrains.jet.lang.descriptors.ClassDescriptor;
import org.jetbrains.jet.lang.descriptors.ClassKind;
import org.jetbrains.jet.lang.descriptors.ClassifierDescriptor;
import org.jetbrains.jet.lang.descriptors.ConstructorDescriptor;
import org.jetbrains.jet.lang.descriptors.DeclarationDescriptor;
import org.jetbrains.jet.lang.descriptors.FunctionDescriptor;
import org.jetbrains.jet.lang.descriptors.Modality;
import org.jetbrains.jet.lang.descriptors.PackageFragmentDescriptor;
import org.jetbrains.jet.lang.descriptors.PropertyAccessorDescriptor;
import org.jetbrains.jet.lang.descriptors.PropertyDescriptor;
import org.jetbrains.jet.lang.descriptors.PropertyGetterDescriptor;
import org.jetbrains.jet.lang.descriptors.PropertySetterDescriptor;
import org.jetbrains.jet.lang.descriptors.ReceiverParameterDescriptor;
import org.jetbrains.jet.lang.descriptors.SimpleFunctionDescriptor;
import org.jetbrains.jet.lang.descriptors.TypeParameterDescriptor;
import org.jetbrains.jet.lang.descriptors.ValueParameterDescriptor;
import org.jetbrains.jet.lang.descriptors.VariableDescriptor;
import org.jetbrains.jet.lang.psi.JetCallElement;
import org.jetbrains.jet.lang.psi.JetClass;
import org.jetbrains.jet.lang.psi.JetClassInitializer;
import org.jetbrains.jet.lang.psi.JetClassObject;
import org.jetbrains.jet.lang.psi.JetClassOrObject;
import org.jetbrains.jet.lang.psi.JetDeclaration;
import org.jetbrains.jet.lang.psi.JetDelegationSpecifier;
import org.jetbrains.jet.lang.psi.JetDelegatorByExpressionSpecifier;
import org.jetbrains.jet.lang.psi.JetDelegatorToSuperCall;
import org.jetbrains.jet.lang.psi.JetDelegatorToSuperClass;
import org.jetbrains.jet.lang.psi.JetElement;
import org.jetbrains.jet.lang.psi.JetEnumEntry;
import org.jetbrains.jet.lang.psi.JetExpression;
import org.jetbrains.jet.lang.psi.JetFile;
import org.jetbrains.jet.lang.psi.JetParameter;
import org.jetbrains.jet.lang.psi.JetProperty;
import org.jetbrains.jet.lang.psi.JetPsiUtil;
import org.jetbrains.jet.lang.psi.JetSimpleNameExpression;
import org.jetbrains.jet.lang.psi.JetThisExpression;
import org.jetbrains.jet.lang.psi.JetValueArgumentList;
import org.jetbrains.jet.lang.psi.JetVisitorVoid;
import org.jetbrains.jet.lang.resolve.BindingContext;
import org.jetbrains.jet.lang.resolve.BindingContextUtils;
import org.jetbrains.jet.lang.resolve.DescriptorUtils;
import org.jetbrains.jet.lang.resolve.OverridingUtil;
import org.jetbrains.jet.lang.resolve.calls.CallResolverUtil;
import org.jetbrains.jet.lang.resolve.calls.model.ResolvedCall;
import org.jetbrains.jet.lang.resolve.constants.CompileTimeConstant;
import org.jetbrains.jet.lang.resolve.java.AsmTypeConstants;
import org.jetbrains.jet.lang.resolve.java.JvmAbi;
import org.jetbrains.jet.lang.resolve.java.JvmAnnotationNames;
import org.jetbrains.jet.lang.resolve.name.Name;
import org.jetbrains.jet.lang.types.JetType;
import org.jetbrains.jet.lang.types.SubstitutionUtils;
import org.jetbrains.jet.lang.types.TypeProjection;
import org.jetbrains.jet.lang.types.TypeProjectionImpl;
import org.jetbrains.jet.lang.types.TypeSubstitutor;
import org.jetbrains.jet.lang.types.TypeUtils;
import org.jetbrains.jet.lang.types.checker.JetTypeChecker;
import org.jetbrains.jet.lang.types.lang.KotlinBuiltIns;
import org.jetbrains.jet.lexer.JetTokens;

public class ImplementationBodyCodegen
extends ClassBodyCodegen {
    private JetDelegationSpecifier superCall;
    private Type superClassAsmType;
    @Nullable
    private JetType superClassType;
    private final Type classAsmType;
    private final FunctionCodegen functionCodegen;
    private final PropertyCodegen propertyCodegen;
    private List<PropertyAndDefaultValue> classObjectPropertiesToCopy;
    private final List<JetEnumEntry> myEnumConstants;

    public ImplementationBodyCodegen(@NotNull JetClassOrObject aClass, @NotNull ClassContext context, @NotNull ClassBuilder v, @NotNull GenerationState state, @Nullable MemberCodegen parentCodegen) {
        if (aClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "aClass", "org/jetbrains/jet/codegen/ImplementationBodyCodegen", "<init>"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/jet/codegen/ImplementationBodyCodegen", "<init>"));
        }
        if (v == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "v", "org/jetbrains/jet/codegen/ImplementationBodyCodegen", "<init>"));
        }
        if (state == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "state", "org/jetbrains/jet/codegen/ImplementationBodyCodegen", "<init>"));
        }
        super(aClass, context, v, state, parentCodegen);
        this.myEnumConstants = new ArrayList<JetEnumEntry>();
        this.classAsmType = this.typeMapper.mapClass(this.descriptor);
        this.functionCodegen = new FunctionCodegen(context, v, state, this);
        this.propertyCodegen = new PropertyCodegen(context, v, this.functionCodegen, this);
    }

    @Override
    protected void generateDeclaration() {
        boolean isStatic;
        this.getSuperClass();
        JvmClassSignature signature = this.signature();
        boolean isAbstract = false;
        boolean isInterface = false;
        boolean isFinal = false;
        boolean isAnnotation = false;
        boolean isEnum = false;
        if (this.myClass instanceof JetClass) {
            JetClass jetClass = (JetClass)this.myClass;
            if (jetClass.hasModifier(JetTokens.ABSTRACT_KEYWORD)) {
                isAbstract = true;
            }
            if (jetClass.isTrait()) {
                isAbstract = true;
                isInterface = true;
            } else if (jetClass.isAnnotation()) {
                isAbstract = true;
                isInterface = true;
                isAnnotation = true;
                signature.getInterfaces().add("java/lang/annotation/Annotation");
            } else if (jetClass.isEnum()) {
                isAbstract = CodegenUtil.hasAbstractMembers(this.descriptor);
                isEnum = true;
            }
            if (this.descriptor.getKind() == ClassKind.OBJECT || this.descriptor.getKind() == ClassKind.CLASS_OBJECT) {
                isFinal = true;
            }
            if (!jetClass.hasModifier(JetTokens.OPEN_KEYWORD) && !isAbstract) {
                isFinal = true;
            }
            isStatic = !jetClass.isInner();
        } else {
            isStatic = this.myClass.getParent() instanceof JetClassObject;
            isFinal = true;
        }
        int access = 0;
        if (this.state.getClassBuilderMode() == ClassBuilderMode.LIGHT_CLASSES && !DescriptorUtils.isTopLevelDeclaration(this.descriptor)) {
            access |= AsmUtil.getVisibilityAccessFlag(this.descriptor);
            if (isStatic) {
                access |= 8;
            }
        } else {
            access |= AsmUtil.getVisibilityAccessFlagForClass(this.descriptor);
        }
        if (isAbstract) {
            access |= 0x400;
        }
        access = isInterface ? (access |= 0x200) : (access |= 0x20);
        if (isFinal) {
            access |= 0x10;
        }
        if (isAnnotation) {
            access |= 0x2000;
        }
        if (KotlinBuiltIns.getInstance().isDeprecated(this.descriptor)) {
            access |= 0x20000;
        }
        if (isEnum) {
            for (JetDeclaration declaration : this.myClass.getDeclarations()) {
                if (!(declaration instanceof JetEnumEntry) || !CodegenBinding.enumEntryNeedSubclass(this.state.getBindingContext(), (JetEnumEntry)declaration)) continue;
                access &= 0xFFFFFFEF;
            }
            access |= 0x4000;
        }
        List<String> interfaces = signature.getInterfaces();
        this.v.defineClass(this.myClass, 50, access, signature.getName(), signature.getJavaGenericSignature(), signature.getSuperclassName(), ArrayUtil.toStringArray(interfaces));
        this.v.visitSource(this.myClass.getContainingFile().getName(), null);
        this.writeEnclosingMethod();
        this.writeOuterClasses();
        this.writeInnerClasses();
        AnnotationCodegen.forClass(this.v.getVisitor(), this.typeMapper).genAnnotations(this.descriptor);
    }

    @Override
    protected void generateKotlinAnnotation() {
        if (DescriptorUtils.isAnonymousObject(this.descriptor)) {
            AsmUtil.writeKotlinSyntheticClassAnnotation(this.v, JvmAnnotationNames.KotlinSyntheticClass.Kind.ANONYMOUS_OBJECT);
            return;
        }
        if (!DescriptorUtils.isTopLevelOrInnerClass(this.descriptor)) {
            AsmUtil.writeKotlinSyntheticClassAnnotation(this.v, JvmAnnotationNames.KotlinSyntheticClass.Kind.LOCAL_CLASS);
            return;
        }
        if (this.state.getClassBuilderMode() != ClassBuilderMode.FULL) {
            return;
        }
        DescriptorSerializer serializer2 = new DescriptorSerializer(new JavaSerializerExtension(this.v.getSerializationBindings()));
        ProtoBuf.Class classProto = serializer2.classProto(this.descriptor).build();
        ClassData data2 = new ClassData(NameSerializationUtil.createNameResolver(serializer2.getNameTable()), classProto);
        AnnotationVisitor av = this.v.getVisitor().visitAnnotation(AsmUtil.asmDescByFqNameWithoutInnerClasses(JvmAnnotationNames.KOTLIN_CLASS), true);
        av.visit("abiVersion", 15);
        AnnotationVisitor array = av.visitArray("data");
        for (String string : BitEncoding.encodeBytes(data2.toBytes())) {
            array.visit(null, string);
        }
        array.visitEnd();
        av.visitEnd();
    }

    private void writeEnclosingMethod() {
        boolean isLocalOrAnonymousClass;
        DeclarationDescriptor parentDescriptor = this.descriptor.getContainingDeclaration();
        boolean isObjectLiteral = DescriptorUtils.isAnonymousObject(this.descriptor);
        boolean bl = isLocalOrAnonymousClass = isObjectLiteral || !(parentDescriptor instanceof PackageFragmentDescriptor) && !(parentDescriptor instanceof ClassDescriptor);
        if (isLocalOrAnonymousClass && this.getState().getClassBuilderMode() != ClassBuilderMode.LIGHT_CLASSES) {
            String outerClassName = ImplementationBodyCodegen.getOuterClassName(this.descriptor, this.typeMapper);
            FunctionDescriptor function = DescriptorUtils.getParentOfType(this.descriptor, FunctionDescriptor.class);
            if (function != null) {
                Method method = this.typeMapper.mapSignature(function).getAsmMethod();
                this.v.visitOuterClass(outerClassName, method.getName(), method.getDescriptor());
            } else {
                assert (isObjectLiteral) : "Function descriptor could be null only for object literal in package: " + this.descriptor.getName();
                this.v.visitOuterClass(outerClassName, null, null);
            }
        }
    }

    @NotNull
    private static String getOuterClassName(@NotNull ClassDescriptor classDescriptor, @NotNull JetTypeMapper typeMapper) {
        if (classDescriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "classDescriptor", "org/jetbrains/jet/codegen/ImplementationBodyCodegen", "getOuterClassName"));
        }
        if (typeMapper == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "typeMapper", "org/jetbrains/jet/codegen/ImplementationBodyCodegen", "getOuterClassName"));
        }
        ClassDescriptor container = DescriptorUtils.getParentOfType(classDescriptor, ClassDescriptor.class);
        if (container != null) {
            String string = typeMapper.mapClass(container).getInternalName();
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/codegen/ImplementationBodyCodegen", "getOuterClassName"));
            }
            return string;
        }
        JetFile containingFile = BindingContextUtils.getContainingFile(typeMapper.getBindingContext(), classDescriptor);
        assert (containingFile != null) : "Containing file should be present for " + classDescriptor;
        String string = PackageCodegen.getPackagePartInternalName(containingFile);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/codegen/ImplementationBodyCodegen", "getOuterClassName"));
        }
        return string;
    }

    private void writeInnerClasses() {
        Collection<ClassDescriptor> result2 = this.bindingContext.get(CodegenBinding.INNER_CLASSES, this.descriptor);
        if (result2 != null) {
            for (ClassDescriptor innerClass : result2) {
                this.writeInnerClass(innerClass);
            }
        }
    }

    private void writeOuterClasses() {
        for (DeclarationDescriptor inner = this.descriptor; inner != null && !DescriptorUtils.isTopLevelDeclaration(inner); inner = inner.getContainingDeclaration()) {
            if (!(inner instanceof ClassDescriptor)) continue;
            this.writeInnerClass((ClassDescriptor)inner);
        }
    }

    private void writeInnerClass(@NotNull ClassDescriptor innerClass) {
        String innerClassInternalName;
        String innerName;
        DeclarationDescriptor containing;
        String outerClassInternalName;
        if (innerClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "innerClass", "org/jetbrains/jet/codegen/ImplementationBodyCodegen", "writeInnerClass"));
        }
        int innerClassAccess = AsmUtil.getVisibilityAccessFlag(innerClass);
        if (innerClass.getModality() == Modality.FINAL) {
            innerClassAccess |= 0x10;
        } else if (innerClass.getModality() == Modality.ABSTRACT) {
            innerClassAccess |= 0x400;
        }
        if (innerClass.getKind() == ClassKind.TRAIT) {
            innerClassAccess |= 0x200;
        } else if (innerClass.getKind() == ClassKind.ENUM_CLASS) {
            innerClassAccess |= 0x4000;
        }
        if (!innerClass.isInner()) {
            innerClassAccess |= 8;
        }
        String string = outerClassInternalName = (containing = innerClass.getContainingDeclaration()) instanceof ClassDescriptor ? this.getInternalNameForImpl((ClassDescriptor)containing) : null;
        if (DescriptorUtils.isClassObject(innerClass)) {
            innerName = "object";
            innerClassInternalName = outerClassInternalName + "$object";
        } else {
            innerName = innerClass.getName().isSpecial() ? null : innerClass.getName().asString();
            innerClassInternalName = this.getInternalNameForImpl(innerClass);
        }
        this.v.visitInnerClass(innerClassInternalName, outerClassInternalName, innerName, innerClassAccess);
    }

    @NotNull
    private String getInternalNameForImpl(@NotNull ClassDescriptor descriptor) {
        if (descriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "org/jetbrains/jet/codegen/ImplementationBodyCodegen", "getInternalNameForImpl"));
        }
        String string = this.typeMapper.mapClass(descriptor).getInternalName();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/codegen/ImplementationBodyCodegen", "getInternalNameForImpl"));
        }
        return string;
    }

    @NotNull
    private JvmClassSignature signature() {
        BothSignatureWriter sw = new BothSignatureWriter(BothSignatureWriter.Mode.CLASS);
        this.typeMapper.writeFormalTypeParameters(this.descriptor.getTypeConstructor().getParameters(), sw);
        sw.writeSuperclass();
        if (this.superClassType == null) {
            sw.writeClassBegin(this.superClassAsmType);
            sw.writeClassEnd();
        } else {
            this.typeMapper.mapSupertype(this.superClassType, sw);
        }
        sw.writeSuperclassEnd();
        ArrayList<JetType> interfaceSupertypes = Lists.newArrayList();
        boolean explicitKObject = false;
        for (JetDelegationSpecifier specifier : this.myClass.getDelegationSpecifiers()) {
            JetType superType = this.bindingContext.get(BindingContext.TYPE, specifier.getTypeReference());
            assert (superType != null) : "No supertype for class: " + this.myClass.getText();
            ClassDescriptor superClassDescriptor = (ClassDescriptor)superType.getConstructor().getDeclarationDescriptor();
            if (!CodegenUtil.isInterface(superClassDescriptor)) continue;
            interfaceSupertypes.add(superType);
            assert (superClassDescriptor != null) : "should be already checked by isInterface()";
            if (!JvmAbi.K_OBJECT.equalsTo(DescriptorUtils.getFqName(superClassDescriptor))) continue;
            explicitKObject = true;
        }
        LinkedHashSet<String> superInterfaces = new LinkedHashSet<String>();
        if (!explicitKObject) {
            Type kObject = AsmUtil.asmTypeByFqNameWithoutInnerClasses(JvmAbi.K_OBJECT);
            sw.writeInterface();
            sw.writeClassBegin(kObject);
            sw.writeClassEnd();
            sw.writeInterfaceEnd();
            superInterfaces.add(kObject.getInternalName());
        }
        for (JetType supertype : interfaceSupertypes) {
            sw.writeInterface();
            Type jvmName = this.typeMapper.mapSupertype(supertype, sw);
            sw.writeInterfaceEnd();
            superInterfaces.add(jvmName.getInternalName());
        }
        JvmClassSignature jvmClassSignature = new JvmClassSignature(this.classAsmType.getInternalName(), this.superClassAsmType.getInternalName(), new ArrayList<String>(superInterfaces), sw.makeJavaGenericSignature());
        if (jvmClassSignature == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/codegen/ImplementationBodyCodegen", "signature"));
        }
        return jvmClassSignature;
    }

    protected void getSuperClass() {
        this.superClassAsmType = AsmTypeConstants.OBJECT_TYPE;
        this.superClassType = null;
        List<JetDelegationSpecifier> delegationSpecifiers = this.myClass.getDelegationSpecifiers();
        if (this.myClass instanceof JetClass && ((JetClass)this.myClass).isTrait()) {
            return;
        }
        if (this.kind != OwnerKind.IMPLEMENTATION) {
            throw new IllegalStateException("must be impl to reach this code: " + (Object)((Object)this.kind));
        }
        for (JetDelegationSpecifier specifier : delegationSpecifiers) {
            if (!(specifier instanceof JetDelegatorToSuperClass) && !(specifier instanceof JetDelegatorToSuperCall)) continue;
            JetType superType = this.bindingContext.get(BindingContext.TYPE, specifier.getTypeReference());
            assert (superType != null) : String.format("No type recorded for \n---\n%s\n---\n", JetPsiUtil.getElementTextWithContext(specifier));
            ClassDescriptor superClassDescriptor = (ClassDescriptor)superType.getConstructor().getDeclarationDescriptor();
            assert (superClassDescriptor != null);
            if (CodegenUtil.isInterface(superClassDescriptor)) continue;
            this.superClassType = superType;
            this.superClassAsmType = this.typeMapper.mapClass(superClassDescriptor);
            this.superCall = specifier;
        }
        if (this.superClassType == null) {
            if (this.descriptor.getKind() == ClassKind.ENUM_CLASS) {
                this.superClassType = KotlinBuiltIns.getInstance().getEnumType(this.descriptor.getDefaultType());
                this.superClassAsmType = this.typeMapper.mapType(this.superClassType);
            }
            if (this.descriptor.getKind() == ClassKind.ENUM_ENTRY) {
                this.superClassType = this.descriptor.getTypeConstructor().getSupertypes().iterator().next();
                this.superClassAsmType = this.typeMapper.mapType(this.superClassType);
            }
        }
    }

    @Override
    protected void generateSyntheticParts() {
        this.generateFieldForSingleton();
        this.generateClassObjectBackingFieldCopies();
        try {
            this.generatePrimaryConstructor();
        }
        catch (CompilationException e) {
            throw e;
        }
        catch (ProcessCanceledException e) {
            throw e;
        }
        catch (RuntimeException e) {
            throw new RuntimeException("Error generating primary constructor of class " + this.myClass.getName() + " with kind " + (Object)((Object)this.kind), e);
        }
        this.generateTraitMethods();
        this.generateSyntheticAccessors();
        this.generateEnumMethodsAndConstInitializers();
        this.generateFunctionsForDataClasses();
        this.generateBuiltinMethodStubs();
        this.generateToArray();
        AsmUtil.genClosureFields(this.context.closure, this.v, this.state.getTypeMapper());
    }

    private boolean isGenericToArrayPresent() {
        Collection<FunctionDescriptor> functions2 = this.descriptor.getDefaultType().getMemberScope().getFunctions(Name.identifier("toArray"));
        for (FunctionDescriptor function : functions2) {
            if (CallResolverUtil.isOrOverridesSynthesized(function) || function.getValueParameters().size() != 1 || function.getTypeParameters().size() != 1) continue;
            JetType arrayType = KotlinBuiltIns.getInstance().getArrayType(function.getTypeParameters().get(0).getDefaultType());
            JetType returnType = function.getReturnType();
            assert (returnType != null) : function.toString();
            JetType paramType = function.getValueParameters().get(0).getType();
            if (!JetTypeChecker.INSTANCE.equalTypes(arrayType, returnType) || !JetTypeChecker.INSTANCE.equalTypes(arrayType, paramType)) continue;
            return true;
        }
        return false;
    }

    private void generateToArray() {
        InstructionAdapter iv;
        MethodVisitor mv;
        int access;
        KotlinBuiltIns builtIns = KotlinBuiltIns.getInstance();
        if (!DescriptorUtils.isSubclass(this.descriptor, builtIns.getCollection())) {
            return;
        }
        int n = access = this.descriptor.getKind() == ClassKind.TRAIT ? 1025 : 1;
        if (CodegenUtil.getDeclaredFunctionByRawSignature(this.descriptor, Name.identifier("toArray"), builtIns.getArray(), new ClassifierDescriptor[0]) == null) {
            mv = this.v.getVisitor().visitMethod(access, "toArray", "()[Ljava/lang/Object;", null, null);
            if (this.descriptor.getKind() != ClassKind.TRAIT) {
                iv = new InstructionAdapter(mv);
                mv.visitCode();
                iv.load(0, this.classAsmType);
                iv.invokestatic("kotlin/jvm/internal/CollectionToArray", "toArray", "(Ljava/util/Collection;)[Ljava/lang/Object;");
                iv.areturn(Type.getObjectType("[Ljava/lang/Object;"));
                FunctionCodegen.endVisit(mv, "toArray", this.myClass);
            }
        }
        if (!this.isGenericToArrayPresent()) {
            mv = this.v.getVisitor().visitMethod(access, "toArray", "([Ljava/lang/Object;)[Ljava/lang/Object;", null, null);
            if (this.descriptor.getKind() != ClassKind.TRAIT) {
                iv = new InstructionAdapter(mv);
                mv.visitCode();
                iv.load(0, this.classAsmType);
                iv.load(1, Type.getObjectType("[Ljava/lang/Object;"));
                iv.invokestatic("kotlin/jvm/internal/CollectionToArray", "toArray", "(Ljava/util/Collection;[Ljava/lang/Object;)[Ljava/lang/Object;");
                iv.areturn(Type.getObjectType("[Ljava/lang/Object;"));
                FunctionCodegen.endVisit(mv, "toArray", this.myClass);
            }
        }
    }

    private void generateMethodStub(@NotNull String name, @NotNull String desc, @NotNull ClassifierDescriptor returnedClassifier, ClassifierDescriptor ... valueParameterClassifiers) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "org/jetbrains/jet/codegen/ImplementationBodyCodegen", "generateMethodStub"));
        }
        if (desc == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "desc", "org/jetbrains/jet/codegen/ImplementationBodyCodegen", "generateMethodStub"));
        }
        if (returnedClassifier == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "returnedClassifier", "org/jetbrains/jet/codegen/ImplementationBodyCodegen", "generateMethodStub"));
        }
        if (valueParameterClassifiers == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "valueParameterClassifiers", "org/jetbrains/jet/codegen/ImplementationBodyCodegen", "generateMethodStub"));
        }
        if (CodegenUtil.getDeclaredFunctionByRawSignature(this.descriptor, Name.identifier(name), returnedClassifier, valueParameterClassifiers) == null) {
            int access = this.descriptor.getKind() == ClassKind.TRAIT ? 1025 : 1;
            MethodVisitor mv = this.v.getVisitor().visitMethod(access, name, desc, null, null);
            if (this.descriptor.getKind() != ClassKind.TRAIT) {
                mv.visitCode();
                AsmUtil.genThrow(mv, "java/lang/UnsupportedOperationException", "Mutating immutable collection");
                FunctionCodegen.endVisit(mv, "built-in stub for " + name + desc, null);
            }
        }
    }

    private void generateBuiltinMethodStubs() {
        ClassifierDescriptor classifier2;
        KotlinBuiltIns builtIns = KotlinBuiltIns.getInstance();
        if (DescriptorUtils.isSubclass(this.descriptor, builtIns.getCollection())) {
            classifier2 = this.getSubstituteForTypeParameterOf(builtIns.getCollection(), 0);
            this.generateMethodStub("add", "(Ljava/lang/Object;)Z", builtIns.getBoolean(), classifier2);
            this.generateMethodStub("remove", "(Ljava/lang/Object;)Z", builtIns.getBoolean(), builtIns.getAny());
            this.generateMethodStub("addAll", "(Ljava/util/Collection;)Z", builtIns.getBoolean(), builtIns.getCollection());
            this.generateMethodStub("removeAll", "(Ljava/util/Collection;)Z", builtIns.getBoolean(), builtIns.getCollection());
            this.generateMethodStub("retainAll", "(Ljava/util/Collection;)Z", builtIns.getBoolean(), builtIns.getCollection());
            this.generateMethodStub("clear", "()V", builtIns.getUnit(), new ClassifierDescriptor[0]);
        }
        if (DescriptorUtils.isSubclass(this.descriptor, builtIns.getList())) {
            classifier2 = this.getSubstituteForTypeParameterOf(builtIns.getList(), 0);
            this.generateMethodStub("set", "(ILjava/lang/Object;)Ljava/lang/Object;", classifier2, builtIns.getInt(), classifier2);
            this.generateMethodStub("add", "(ILjava/lang/Object;)V", builtIns.getUnit(), builtIns.getInt(), classifier2);
            this.generateMethodStub("remove", "(I)Ljava/lang/Object;", classifier2, builtIns.getInt());
        }
        if (DescriptorUtils.isSubclass(this.descriptor, builtIns.getMap())) {
            ClassifierDescriptor keyClassifier = this.getSubstituteForTypeParameterOf(builtIns.getMap(), 0);
            ClassifierDescriptor valueClassifier = this.getSubstituteForTypeParameterOf(builtIns.getMap(), 1);
            this.generateMethodStub("put", "(Ljava/lang/Object;Ljava/lang/Object;)Ljava/lang/Object;", valueClassifier, keyClassifier, valueClassifier);
            this.generateMethodStub("remove", "(Ljava/lang/Object;)Ljava/lang/Object;", valueClassifier, builtIns.getAny());
            this.generateMethodStub("putAll", "(Ljava/util/Map;)V", builtIns.getUnit(), builtIns.getMap());
            this.generateMethodStub("clear", "()V", builtIns.getUnit(), new ClassifierDescriptor[0]);
        }
        if (DescriptorUtils.isSubclass(this.descriptor, builtIns.getMapEntry())) {
            ClassifierDescriptor valueClassifier = this.getSubstituteForTypeParameterOf(builtIns.getMapEntry(), 1);
            this.generateMethodStub("setValue", "(Ljava/lang/Object;)Ljava/lang/Object;", valueClassifier, valueClassifier);
        }
        if (DescriptorUtils.isSubclass(this.descriptor, builtIns.getIterator())) {
            this.generateMethodStub("remove", "()V", builtIns.getUnit(), new ClassifierDescriptor[0]);
        }
    }

    @NotNull
    private ClassifierDescriptor getSubstituteForTypeParameterOf(@NotNull ClassDescriptor trait, int index) {
        if (trait == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "trait", "org/jetbrains/jet/codegen/ImplementationBodyCodegen", "getSubstituteForTypeParameterOf"));
        }
        TypeParameterDescriptor listTypeParameter = trait.getTypeConstructor().getParameters().get(index);
        TypeSubstitutor deepSubstitutor = SubstitutionUtils.buildDeepSubstitutor(this.descriptor.getDefaultType());
        TypeProjection substitute = deepSubstitutor.substitute(new TypeProjectionImpl(listTypeParameter.getDefaultType()));
        assert (substitute != null) : "Couldn't substitute: " + this.descriptor;
        ClassifierDescriptor classifier2 = substitute.getType().getConstructor().getDeclarationDescriptor();
        assert (classifier2 != null) : "No classifier: " + substitute.getType();
        ClassifierDescriptor classifierDescriptor = classifier2;
        if (classifierDescriptor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/codegen/ImplementationBodyCodegen", "getSubstituteForTypeParameterOf"));
        }
        return classifierDescriptor;
    }

    private List<PropertyDescriptor> getDataProperties() {
        ArrayList<PropertyDescriptor> result2 = Lists.newArrayList();
        for (JetParameter parameter : this.getPrimaryConstructorParameters()) {
            if (parameter.getValOrVarNode() == null) continue;
            result2.add(this.bindingContext.get(BindingContext.PRIMARY_CONSTRUCTOR_PARAMETER, parameter));
        }
        return result2;
    }

    private void generateFunctionsForDataClasses() {
        if (!KotlinBuiltIns.getInstance().isData(this.descriptor)) {
            return;
        }
        this.generateComponentFunctionsForDataClasses();
        this.generateCopyFunctionForDataClasses();
        List<PropertyDescriptor> properties = this.getDataProperties();
        if (!properties.isEmpty()) {
            this.generateDataClassToStringIfNeeded(properties);
            this.generateDataClassHashCodeIfNeeded(properties);
            this.generateDataClassEqualsIfNeeded(properties);
        }
    }

    private void generateCopyFunctionForDataClasses() {
        FunctionDescriptor copyFunction = this.bindingContext.get(BindingContext.DATA_CLASS_COPY_FUNCTION, this.descriptor);
        if (copyFunction != null) {
            this.generateCopyFunction(copyFunction);
        }
    }

    private void generateDataClassToStringIfNeeded(@NotNull List<PropertyDescriptor> properties) {
        if (properties == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "properties", "org/jetbrains/jet/codegen/ImplementationBodyCodegen", "generateDataClassToStringIfNeeded"));
        }
        ClassDescriptor stringClass = KotlinBuiltIns.getInstance().getString();
        if (!this.hasDeclaredNonTrivialMember("toString", stringClass, new ClassDescriptor[0])) {
            this.generateDataClassToStringMethod(properties);
        }
    }

    private void generateDataClassHashCodeIfNeeded(@NotNull List<PropertyDescriptor> properties) {
        if (properties == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "properties", "org/jetbrains/jet/codegen/ImplementationBodyCodegen", "generateDataClassHashCodeIfNeeded"));
        }
        ClassDescriptor intClass = KotlinBuiltIns.getInstance().getInt();
        if (!this.hasDeclaredNonTrivialMember("hashCode", intClass, new ClassDescriptor[0])) {
            this.generateDataClassHashCodeMethod(properties);
        }
    }

    private void generateDataClassEqualsIfNeeded(@NotNull List<PropertyDescriptor> properties) {
        if (properties == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "properties", "org/jetbrains/jet/codegen/ImplementationBodyCodegen", "generateDataClassEqualsIfNeeded"));
        }
        ClassDescriptor booleanClass = KotlinBuiltIns.getInstance().getBoolean();
        ClassDescriptor anyClass = KotlinBuiltIns.getInstance().getAny();
        if (!this.hasDeclaredNonTrivialMember("equals", booleanClass, anyClass)) {
            this.generateDataClassEqualsMethod(properties);
        }
    }

    private boolean hasDeclaredNonTrivialMember(@NotNull String name, @NotNull ClassDescriptor returnedClassifier, ClassDescriptor ... valueParameterClassifiers) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "org/jetbrains/jet/codegen/ImplementationBodyCodegen", "hasDeclaredNonTrivialMember"));
        }
        if (returnedClassifier == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "returnedClassifier", "org/jetbrains/jet/codegen/ImplementationBodyCodegen", "hasDeclaredNonTrivialMember"));
        }
        if (valueParameterClassifiers == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "valueParameterClassifiers", "org/jetbrains/jet/codegen/ImplementationBodyCodegen", "hasDeclaredNonTrivialMember"));
        }
        FunctionDescriptor function = CodegenUtil.getDeclaredFunctionByRawSignature(this.descriptor, Name.identifier(name), returnedClassifier, valueParameterClassifiers);
        if (function == null) {
            return false;
        }
        if (function.getKind() == CallableMemberDescriptor.Kind.DECLARATION) {
            return true;
        }
        for (CallableMemberDescriptor overridden : OverridingUtil.getOverriddenDeclarations(function)) {
            if (!(overridden instanceof CallableMemberDescriptor) || overridden.getKind() != CallableMemberDescriptor.Kind.DECLARATION || overridden.getContainingDeclaration().equals(KotlinBuiltIns.getInstance().getAny())) continue;
            return true;
        }
        return false;
    }

    private void generateDataClassEqualsMethod(@NotNull List<PropertyDescriptor> properties) {
        if (properties == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "properties", "org/jetbrains/jet/codegen/ImplementationBodyCodegen", "generateDataClassEqualsMethod"));
        }
        MethodVisitor mv = this.v.getVisitor().visitMethod(1, "equals", "(Ljava/lang/Object;)Z", null, null);
        InstructionAdapter iv = new InstructionAdapter(mv);
        mv.visitCode();
        Label eq = new Label();
        Label ne = new Label();
        iv.load(0, AsmTypeConstants.OBJECT_TYPE);
        iv.load(1, AsmTypeConstants.OBJECT_TYPE);
        iv.ifacmpeq(eq);
        iv.load(1, AsmTypeConstants.OBJECT_TYPE);
        iv.instanceOf(this.classAsmType);
        iv.ifeq(ne);
        iv.load(1, AsmTypeConstants.OBJECT_TYPE);
        iv.checkcast(this.classAsmType);
        iv.store(2, AsmTypeConstants.OBJECT_TYPE);
        for (PropertyDescriptor propertyDescriptor : properties) {
            Type asmType = this.typeMapper.mapType(propertyDescriptor);
            this.genPropertyOnStack(iv, propertyDescriptor, 0);
            this.genPropertyOnStack(iv, propertyDescriptor, 2);
            if (asmType.getSort() == 9) {
                Type elementType = AsmUtil.correctElementType(asmType);
                if (elementType.getSort() == 10 || elementType.getSort() == 9) {
                    iv.invokestatic("java/util/Arrays", "equals", "([Ljava/lang/Object;[Ljava/lang/Object;)Z");
                } else {
                    iv.invokestatic("java/util/Arrays", "equals", "([" + elementType.getDescriptor() + "[" + elementType.getDescriptor() + ")Z");
                }
            } else {
                StackValue value = AsmUtil.genEqualsForExpressionsOnStack(iv, JetTokens.EQEQ, asmType, asmType);
                value.put(Type.BOOLEAN_TYPE, iv);
            }
            iv.ifeq(ne);
        }
        iv.mark(eq);
        iv.iconst(1);
        iv.areturn(Type.INT_TYPE);
        iv.mark(ne);
        iv.iconst(0);
        iv.areturn(Type.INT_TYPE);
        FunctionCodegen.endVisit(mv, "equals", this.myClass);
    }

    private void generateDataClassHashCodeMethod(@NotNull List<PropertyDescriptor> properties) {
        if (properties == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "properties", "org/jetbrains/jet/codegen/ImplementationBodyCodegen", "generateDataClassHashCodeMethod"));
        }
        MethodVisitor mv = this.v.getVisitor().visitMethod(1, "hashCode", "()I", null, null);
        InstructionAdapter iv = new InstructionAdapter(mv);
        mv.visitCode();
        boolean first = true;
        for (PropertyDescriptor propertyDescriptor : properties) {
            if (!first) {
                iv.iconst(31);
                iv.mul(Type.INT_TYPE);
            }
            this.genPropertyOnStack(iv, propertyDescriptor, 0);
            Label ifNull = null;
            Type asmType = this.typeMapper.mapType(propertyDescriptor);
            if (!AsmUtil.isPrimitive(asmType)) {
                ifNull = new Label();
                iv.dup();
                iv.ifnull(ifNull);
            }
            AsmUtil.genHashCode(mv, iv, asmType);
            if (ifNull != null) {
                Label end = new Label();
                iv.goTo(end);
                iv.mark(ifNull);
                iv.pop();
                iv.iconst(0);
                iv.mark(end);
            }
            if (first) {
                first = false;
                continue;
            }
            iv.add(Type.INT_TYPE);
        }
        mv.visitInsn(172);
        FunctionCodegen.endVisit(mv, "hashCode", this.myClass);
    }

    private void generateDataClassToStringMethod(@NotNull List<PropertyDescriptor> properties) {
        if (properties == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "properties", "org/jetbrains/jet/codegen/ImplementationBodyCodegen", "generateDataClassToStringMethod"));
        }
        MethodVisitor mv = this.v.getVisitor().visitMethod(1, "toString", "()Ljava/lang/String;", null, null);
        InstructionAdapter iv = new InstructionAdapter(mv);
        mv.visitCode();
        AsmUtil.genStringBuilderConstructor(iv);
        boolean first = true;
        for (PropertyDescriptor propertyDescriptor : properties) {
            if (first) {
                iv.aconst(this.descriptor.getName() + "(" + propertyDescriptor.getName().asString() + "=");
                first = false;
            } else {
                iv.aconst(", " + propertyDescriptor.getName().asString() + "=");
            }
            AsmUtil.genInvokeAppendMethod(iv, AsmTypeConstants.JAVA_STRING_TYPE);
            Type type = this.genPropertyOnStack(iv, propertyDescriptor, 0);
            if (type.getSort() == 9) {
                Type elementType = AsmUtil.correctElementType(type);
                if (elementType.getSort() == 10 || elementType.getSort() == 9) {
                    iv.invokestatic("java/util/Arrays", "toString", "([Ljava/lang/Object;)Ljava/lang/String;");
                    type = AsmTypeConstants.JAVA_STRING_TYPE;
                } else if (elementType.getSort() != 2) {
                    iv.invokestatic("java/util/Arrays", "toString", "(" + type.getDescriptor() + ")Ljava/lang/String;");
                    type = AsmTypeConstants.JAVA_STRING_TYPE;
                }
            }
            AsmUtil.genInvokeAppendMethod(iv, type);
        }
        iv.aconst(")");
        AsmUtil.genInvokeAppendMethod(iv, AsmTypeConstants.JAVA_STRING_TYPE);
        iv.invokevirtual("java/lang/StringBuilder", "toString", "()Ljava/lang/String;");
        iv.areturn(AsmTypeConstants.JAVA_STRING_TYPE);
        FunctionCodegen.endVisit(mv, "toString", this.myClass);
    }

    private Type genPropertyOnStack(InstructionAdapter iv, PropertyDescriptor propertyDescriptor, int index) {
        iv.load(index, this.classAsmType);
        Method method = this.typeMapper.mapSignature(propertyDescriptor.getGetter()).getAsmMethod();
        iv.invokevirtual(this.classAsmType.getInternalName(), method.getName(), method.getDescriptor());
        return method.getReturnType();
    }

    private void generateComponentFunctionsForDataClasses() {
        if (!this.myClass.hasPrimaryConstructor() || !KotlinBuiltIns.getInstance().isData(this.descriptor)) {
            return;
        }
        ConstructorDescriptor constructor = this.descriptor.getConstructors().iterator().next();
        for (ValueParameterDescriptor parameter : constructor.getValueParameters()) {
            FunctionDescriptor function = this.bindingContext.get(BindingContext.DATA_CLASS_COMPONENT_FUNCTION, parameter);
            if (function == null) continue;
            this.generateComponentFunction(function, parameter);
        }
    }

    private void generateComponentFunction(@NotNull FunctionDescriptor function, final @NotNull ValueParameterDescriptor parameter) {
        if (function == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "function", "org/jetbrains/jet/codegen/ImplementationBodyCodegen", "generateComponentFunction"));
        }
        if (parameter == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parameter", "org/jetbrains/jet/codegen/ImplementationBodyCodegen", "generateComponentFunction"));
        }
        this.functionCodegen.generateMethod(this.myClass, this.typeMapper.mapSignature(function), function, new FunctionGenerationStrategy(){

            @Override
            public void generateBody(@NotNull MethodVisitor mv, @NotNull JvmMethodSignature signature, @NotNull MethodContext context, @Nullable MemberCodegen parentCodegen) {
                if (mv == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "mv", "org/jetbrains/jet/codegen/ImplementationBodyCodegen$1", "generateBody"));
                }
                if (signature == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "signature", "org/jetbrains/jet/codegen/ImplementationBodyCodegen$1", "generateBody"));
                }
                if (context == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/jet/codegen/ImplementationBodyCodegen$1", "generateBody"));
                }
                Type componentType = signature.getReturnType();
                InstructionAdapter iv = new InstructionAdapter(mv);
                if (!componentType.equals(Type.VOID_TYPE)) {
                    iv.load(0, ImplementationBodyCodegen.this.classAsmType);
                    String desc = "()" + componentType.getDescriptor();
                    iv.invokevirtual(ImplementationBodyCodegen.this.classAsmType.getInternalName(), PropertyCodegen.getterName(parameter.getName()), desc);
                }
                iv.areturn(componentType);
            }
        });
    }

    private void generateCopyFunction(final @NotNull FunctionDescriptor function) {
        if (function == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "function", "org/jetbrains/jet/codegen/ImplementationBodyCodegen", "generateCopyFunction"));
        }
        JvmMethodSignature methodSignature = this.typeMapper.mapSignature(function);
        final Type thisDescriptorType = this.typeMapper.mapType(this.descriptor);
        this.functionCodegen.generateMethod(this.myClass, methodSignature, function, new FunctionGenerationStrategy(){

            @Override
            public void generateBody(@NotNull MethodVisitor mv, @NotNull JvmMethodSignature signature, @NotNull MethodContext context, @Nullable MemberCodegen parentCodegen) {
                if (mv == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "mv", "org/jetbrains/jet/codegen/ImplementationBodyCodegen$2", "generateBody"));
                }
                if (signature == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "signature", "org/jetbrains/jet/codegen/ImplementationBodyCodegen$2", "generateBody"));
                }
                if (context == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/jet/codegen/ImplementationBodyCodegen$2", "generateBody"));
                }
                InstructionAdapter iv = new InstructionAdapter(mv);
                iv.anew(thisDescriptorType);
                iv.dup();
                ConstructorDescriptor constructor = DescriptorUtils.getConstructorOfDataClass(ImplementationBodyCodegen.this.descriptor);
                assert (function.getValueParameters().size() == constructor.getValueParameters().size()) : "Number of parameters of copy function and constructor are different. Copy: " + function.getValueParameters().size() + ", " + "constructor: " + constructor.getValueParameters().size();
                MutableClosure closure = ImplementationBodyCodegen.this.context.closure;
                if (closure != null && closure.getCaptureThis() != null) {
                    Type type = ImplementationBodyCodegen.this.typeMapper.mapType(CodegenBinding.enclosingClassDescriptor(ImplementationBodyCodegen.this.bindingContext, ImplementationBodyCodegen.this.descriptor));
                    iv.load(0, ImplementationBodyCodegen.this.classAsmType);
                    iv.getfield(ImplementationBodyCodegen.this.classAsmType.getInternalName(), "this$0", type.getDescriptor());
                }
                int parameterIndex = 1;
                for (ValueParameterDescriptor parameterDescriptor : function.getValueParameters()) {
                    Type type = ImplementationBodyCodegen.this.typeMapper.mapType(parameterDescriptor.getType());
                    iv.load(parameterIndex, type);
                    parameterIndex += type.getSize();
                }
                String constructorJvmDescriptor = ImplementationBodyCodegen.this.typeMapper.mapToCallableMethod(constructor).getAsmMethod().getDescriptor();
                iv.invokespecial(thisDescriptorType.getInternalName(), "<init>", constructorJvmDescriptor);
                iv.areturn(thisDescriptorType);
            }
        });
        MethodContext functionContext = this.context.intoFunction(function);
        this.functionCodegen.generateDefaultIfNeeded(functionContext, methodSignature, function, OwnerKind.IMPLEMENTATION, new DefaultParameterValueLoader(){

            @Override
            public void putValueOnStack(ValueParameterDescriptor descriptor, ExpressionCodegen codegen) {
                assert (KotlinBuiltIns.getInstance().isData((ClassDescriptor)function.getContainingDeclaration())) : "Trying to create function with default arguments for function that isn't presented in code for class without data annotation";
                PropertyDescriptor propertyDescriptor = codegen.getBindingContext().get(BindingContext.VALUE_PARAMETER_AS_PROPERTY, descriptor);
                assert (propertyDescriptor != null) : "Trying to generate default value for parameter of copy function that doesn't correspond to any property";
                codegen.v.load(0, thisDescriptorType);
                Type propertyType = codegen.typeMapper.mapType(propertyDescriptor);
                codegen.intermediateValueForProperty(propertyDescriptor, false, null).put(propertyType, codegen.v);
            }
        });
    }

    private void generateEnumMethodsAndConstInitializers() {
        if (DescriptorUtils.isEnumClass(this.descriptor)) {
            this.generateEnumValuesMethod();
            this.generateEnumValueOfMethod();
            this.initializeEnumConstants();
        }
    }

    private void generateEnumValuesMethod() {
        Type type = this.typeMapper.mapType(KotlinBuiltIns.getInstance().getArrayType(this.descriptor.getDefaultType()));
        MethodVisitor mv = this.v.newMethod(this.myClass, 9, "values", "()" + type.getDescriptor(), null, null);
        if (this.state.getClassBuilderMode() != ClassBuilderMode.FULL) {
            return;
        }
        mv.visitCode();
        mv.visitFieldInsn(178, this.classAsmType.getInternalName(), "$VALUES", type.getDescriptor());
        mv.visitMethodInsn(182, type.getInternalName(), "clone", "()Ljava/lang/Object;");
        mv.visitTypeInsn(192, type.getInternalName());
        mv.visitInsn(176);
        FunctionCodegen.endVisit(mv, "values()", this.myClass);
    }

    private void generateEnumValueOfMethod() {
        MethodVisitor mv = this.v.newMethod(this.myClass, 9, "valueOf", "(Ljava/lang/String;)" + this.classAsmType.getDescriptor(), null, null);
        if (this.state.getClassBuilderMode() != ClassBuilderMode.FULL) {
            return;
        }
        mv.visitCode();
        mv.visitLdcInsn(this.classAsmType);
        mv.visitVarInsn(25, 0);
        mv.visitMethodInsn(184, "java/lang/Enum", "valueOf", "(Ljava/lang/Class;Ljava/lang/String;)Ljava/lang/Enum;");
        mv.visitTypeInsn(192, this.classAsmType.getInternalName());
        mv.visitInsn(176);
        FunctionCodegen.endVisit(mv, "valueOf()", this.myClass);
    }

    protected void generateSyntheticAccessors() {
        Map<DeclarationDescriptor, DeclarationDescriptor> accessors = this.context.getAccessors();
        for (Map.Entry<DeclarationDescriptor, DeclarationDescriptor> entry : accessors.entrySet()) {
            this.generateSyntheticAccessor(entry);
        }
    }

    private void generateSyntheticAccessor(Map.Entry<DeclarationDescriptor, DeclarationDescriptor> entry) {
        if (entry.getValue() instanceof FunctionDescriptor) {
            FunctionDescriptor bridge = (FunctionDescriptor)entry.getValue();
            final FunctionDescriptor original = (FunctionDescriptor)entry.getKey();
            this.functionCodegen.generateMethod(null, this.typeMapper.mapSignature(bridge), bridge, new FunctionGenerationStrategy.CodegenBased<FunctionDescriptor>(this.state, bridge){

                @Override
                public void doGenerateBody(@NotNull ExpressionCodegen codegen, @NotNull JvmMethodSignature signature) {
                    if (codegen == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "codegen", "org/jetbrains/jet/codegen/ImplementationBodyCodegen$4", "doGenerateBody"));
                    }
                    if (signature == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "signature", "org/jetbrains/jet/codegen/ImplementationBodyCodegen$4", "doGenerateBody"));
                    }
                    ImplementationBodyCodegen.this.generateMethodCallTo(original, codegen.v);
                    codegen.v.areturn(signature.getReturnType());
                }
            });
        } else if (entry.getValue() instanceof PropertyDescriptor) {
            final PropertyDescriptor bridge = (PropertyDescriptor)entry.getValue();
            final PropertyDescriptor original = (PropertyDescriptor)entry.getKey();
            PropertyGetterDescriptor getter = bridge.getGetter();
            assert (getter != null);
            this.functionCodegen.generateMethod(null, this.typeMapper.mapSignature(getter), getter, new FunctionGenerationStrategy.CodegenBased<PropertyGetterDescriptor>(this.state, getter){

                @Override
                public void doGenerateBody(@NotNull ExpressionCodegen codegen, @NotNull JvmMethodSignature signature) {
                    if (codegen == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "codegen", "org/jetbrains/jet/codegen/ImplementationBodyCodegen$5", "doGenerateBody"));
                    }
                    if (signature == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "signature", "org/jetbrains/jet/codegen/ImplementationBodyCodegen$5", "doGenerateBody"));
                    }
                    InstructionAdapter iv = codegen.v;
                    boolean forceField = AsmUtil.isPropertyWithBackingFieldInOuterClass(original) && !DescriptorUtils.isClassObject(bridge.getContainingDeclaration());
                    StackValue.Property property2 = codegen.intermediateValueForProperty(original, forceField, null, MethodKind.SYNTHETIC_ACCESSOR);
                    if (!forceField) {
                        iv.load(0, AsmTypeConstants.OBJECT_TYPE);
                    }
                    ((StackValue)property2).put(property2.type, iv);
                    iv.areturn(signature.getReturnType());
                }
            });
            if (bridge.isVar()) {
                PropertySetterDescriptor setter = bridge.getSetter();
                assert (setter != null);
                this.functionCodegen.generateMethod(null, this.typeMapper.mapSignature(setter), setter, new FunctionGenerationStrategy.CodegenBased<PropertySetterDescriptor>(this.state, setter){

                    @Override
                    public void doGenerateBody(@NotNull ExpressionCodegen codegen, @NotNull JvmMethodSignature signature) {
                        if (codegen == null) {
                            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "codegen", "org/jetbrains/jet/codegen/ImplementationBodyCodegen$6", "doGenerateBody"));
                        }
                        if (signature == null) {
                            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "signature", "org/jetbrains/jet/codegen/ImplementationBodyCodegen$6", "doGenerateBody"));
                        }
                        boolean forceField = AsmUtil.isPropertyWithBackingFieldInOuterClass(original) && !DescriptorUtils.isClassObject(bridge.getContainingDeclaration());
                        StackValue.Property property2 = codegen.intermediateValueForProperty(original, forceField, null, MethodKind.SYNTHETIC_ACCESSOR);
                        InstructionAdapter iv = codegen.v;
                        Type[] argTypes = signature.getAsmMethod().getArgumentTypes();
                        int reg = 0;
                        for (int i = 0; i < argTypes.length; ++i) {
                            Type argType = argTypes[i];
                            iv.load(reg, argType);
                            reg += argType.getSize();
                        }
                        ((StackValue)property2).store(property2.type, iv);
                        iv.areturn(signature.getReturnType());
                    }
                });
            }
        } else {
            throw new UnsupportedOperationException();
        }
    }

    private void generateMethodCallTo(FunctionDescriptor functionDescriptor, InstructionAdapter iv) {
        boolean isConstructor = functionDescriptor instanceof ConstructorDescriptor;
        boolean callFromAccessor = !JetTypeMapper.isAccessor(functionDescriptor);
        CallableMethod callableMethod = isConstructor ? this.typeMapper.mapToCallableMethod((ConstructorDescriptor)functionDescriptor) : this.typeMapper.mapToCallableMethod(functionDescriptor, callFromAccessor, this.context);
        int reg = 1;
        if (isConstructor) {
            iv.anew(callableMethod.getOwner());
            iv.dup();
            reg = 0;
        } else if (callFromAccessor) {
            iv.load(0, AsmTypeConstants.OBJECT_TYPE);
        }
        for (Type argType : callableMethod.getAsmMethod().getArgumentTypes()) {
            iv.load(reg, argType);
            reg += argType.getSize();
        }
        callableMethod.invokeWithoutAssertions(iv);
    }

    private void generateFieldForSingleton() {
        ClassDescriptor fieldTypeDescriptor;
        JetClassOrObject original;
        if (DescriptorUtils.isEnumClass(this.descriptor) || DescriptorUtils.isEnumEntry(this.descriptor)) {
            return;
        }
        ClassDescriptor classObjectDescriptor = this.descriptor.getClassObjectDescriptor();
        if (DescriptorUtils.isObject(this.descriptor)) {
            original = this.myClass;
            fieldTypeDescriptor = this.descriptor;
        } else if (classObjectDescriptor != null) {
            JetClassObject classObject = ((JetClass)this.myClass).getClassObject();
            assert (classObject != null) : "Class object not found: " + this.myClass.getText();
            original = classObject.getObjectDeclaration();
            fieldTypeDescriptor = classObjectDescriptor;
        } else {
            return;
        }
        StackValue.Field field = StackValue.singleton(fieldTypeDescriptor, this.typeMapper);
        this.v.newField(original, 25, field.name, field.type.getDescriptor(), null, null);
        if (!AsmUtil.isClassObjectWithBackingFieldsInOuter(fieldTypeDescriptor)) {
            this.genInitSingleton(fieldTypeDescriptor, field);
        }
    }

    private void generateClassObjectBackingFieldCopies() {
        if (this.classObjectPropertiesToCopy != null) {
            for (PropertyAndDefaultValue propertyInfo : this.classObjectPropertiesToCopy) {
                PropertyDescriptor propertyDescriptor = propertyInfo.descriptor;
                FieldVisitor fv = this.v.newField(null, 25, this.context.getFieldName(propertyDescriptor), this.typeMapper.mapType(propertyDescriptor).getDescriptor(), null, propertyInfo.defaultValue);
                AnnotationCodegen.forField(fv, this.typeMapper).genAnnotations(propertyDescriptor);
                if (this.state.getClassBuilderMode() != ClassBuilderMode.FULL || propertyInfo.defaultValue != null) continue;
                ExpressionCodegen codegen = this.createOrGetClInitCodegen();
                int classObjectIndex = this.putClassObjectInLocalVar(codegen);
                StackValue.local(classObjectIndex, AsmTypeConstants.OBJECT_TYPE).put(AsmTypeConstants.OBJECT_TYPE, codegen.v);
                this.copyFieldFromClassObject(propertyDescriptor);
            }
        }
    }

    private int putClassObjectInLocalVar(ExpressionCodegen codegen) {
        FrameMap frameMap = codegen.myFrameMap;
        ClassDescriptor classObjectDescriptor = this.descriptor.getClassObjectDescriptor();
        int classObjectIndex = frameMap.getIndex(classObjectDescriptor);
        if (classObjectIndex == -1) {
            classObjectIndex = frameMap.enter(classObjectDescriptor, AsmTypeConstants.OBJECT_TYPE);
            StackValue.Field classObject = StackValue.singleton(classObjectDescriptor, this.typeMapper);
            ((StackValue)classObject).put(classObject.type, codegen.v);
            StackValue.local(classObjectIndex, classObject.type).store(classObject.type, codegen.v);
        }
        return classObjectIndex;
    }

    private void copyFieldFromClassObject(PropertyDescriptor propertyDescriptor) {
        ExpressionCodegen codegen = this.createOrGetClInitCodegen();
        StackValue.Property property2 = codegen.intermediateValueForProperty(propertyDescriptor, false, null);
        ((StackValue)property2).put(property2.type, codegen.v);
        StackValue.Field field = StackValue.field(property2.type, this.classAsmType, propertyDescriptor.getName().asString(), true);
        field.store(field.type, codegen.v);
    }

    protected void genInitSingleton(ClassDescriptor fieldTypeDescriptor, StackValue.Field field) {
        if (this.state.getClassBuilderMode() == ClassBuilderMode.FULL) {
            ConstructorDescriptor constructorDescriptor = DescriptorUtils.getConstructorOfSingletonObject(fieldTypeDescriptor);
            ExpressionCodegen codegen = this.createOrGetClInitCodegen();
            FunctionDescriptor fd = codegen.accessibleFunctionDescriptor(constructorDescriptor);
            this.generateMethodCallTo(fd, codegen.v);
            field.store(field.type, codegen.v);
        }
    }

    protected void generatePrimaryConstructor() {
        if (this.ignoreIfTraitOrAnnotation()) {
            return;
        }
        if (this.kind != OwnerKind.IMPLEMENTATION) {
            throw new IllegalStateException("incorrect kind for primary constructor: " + (Object)((Object)this.kind));
        }
        final MutableClosure closure = this.context.closure;
        ConstructorDescriptor constructorDescriptor = this.bindingContext.get(BindingContext.CONSTRUCTOR, this.myClass);
        ConstructorContext constructorContext = this.context.intoConstructor(constructorDescriptor, closure);
        if (this.state.getClassBuilderMode() == ClassBuilderMode.FULL) {
            this.lookupConstructorExpressionsInClosureIfPresent(constructorContext);
        }
        assert (constructorDescriptor != null);
        final JvmMethodSignature constructorSignature = this.typeMapper.mapSignature(constructorDescriptor);
        this.functionCodegen.generateMethod(this.myClass, constructorSignature, constructorDescriptor, constructorContext, new FunctionGenerationStrategy.CodegenBased<ConstructorDescriptor>(this.state, constructorDescriptor){

            @Override
            @NotNull
            protected FrameMap createFrameMap(@NotNull JetTypeMapper typeMapper, @NotNull MethodContext context) {
                if (typeMapper == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "typeMapper", "org/jetbrains/jet/codegen/ImplementationBodyCodegen$7", "createFrameMap"));
                }
                if (context == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/jet/codegen/ImplementationBodyCodegen$7", "createFrameMap"));
                }
                ConstructorFrameMap constructorFrameMap = new ConstructorFrameMap(constructorSignature);
                if (constructorFrameMap == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/codegen/ImplementationBodyCodegen$7", "createFrameMap"));
                }
                return constructorFrameMap;
            }

            @Override
            public void doGenerateBody(@NotNull ExpressionCodegen codegen, @NotNull JvmMethodSignature signature) {
                if (codegen == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "codegen", "org/jetbrains/jet/codegen/ImplementationBodyCodegen$7", "doGenerateBody"));
                }
                if (signature == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "signature", "org/jetbrains/jet/codegen/ImplementationBodyCodegen$7", "doGenerateBody"));
                }
                ImplementationBodyCodegen.this.generatePrimaryConstructorImpl((ConstructorDescriptor)this.callableDescriptor, codegen, closure);
            }
        });
        this.functionCodegen.generateDefaultIfNeeded(constructorContext, constructorSignature, constructorDescriptor, OwnerKind.IMPLEMENTATION, DefaultParameterValueLoader.DEFAULT);
        CallableMethod callableMethod = this.typeMapper.mapToCallableMethod(constructorDescriptor);
        FunctionCodegen.generateConstructorWithoutParametersIfNeeded(this.state, callableMethod, constructorDescriptor, this.v);
        if (DescriptorUtils.isClassObject(this.descriptor)) {
            this.context.recordSyntheticAccessorIfNeeded(constructorDescriptor, this.bindingContext);
        }
    }

    private void generatePrimaryConstructorImpl(@Nullable ConstructorDescriptor constructorDescriptor, @NotNull ExpressionCodegen codegen, @Nullable MutableClosure closure) {
        if (codegen == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "codegen", "org/jetbrains/jet/codegen/ImplementationBodyCodegen", "generatePrimaryConstructorImpl"));
        }
        List<Object> paramDescrs = constructorDescriptor != null ? constructorDescriptor.getValueParameters() : Collections.emptyList();
        InstructionAdapter iv = codegen.v;
        if (this.superCall == null) {
            this.genSimpleSuperCall(iv);
        } else if (this.superCall instanceof JetDelegatorToSuperClass) {
            this.genSuperCallToDelegatorToSuperClass(iv);
        } else {
            this.generateDelegatorToConstructorCall(iv, codegen, constructorDescriptor);
        }
        if (closure != null) {
            List<FieldInfo> argsFromClosure = ClosureCodegen.calculateConstructorParameters(this.typeMapper, closure, this.classAsmType);
            int k = 1;
            for (FieldInfo info : argsFromClosure) {
                k = AsmUtil.genAssignInstanceFieldFromParam(info, k, iv);
            }
        }
        int n = 0;
        for (JetDelegationSpecifier specifier : this.myClass.getDelegationSpecifiers()) {
            if (specifier == this.superCall || !(specifier instanceof JetDelegatorByExpressionSpecifier)) continue;
            this.genCallToDelegatorByExpressionSpecifier(iv, codegen, n++, specifier);
        }
        int curParam = 0;
        List<JetParameter> constructorParameters = this.getPrimaryConstructorParameters();
        for (JetParameter parameter : constructorParameters) {
            if (parameter.getValOrVarNode() != null) {
                VariableDescriptor descriptor = (VariableDescriptor)paramDescrs.get(curParam);
                Type type = this.typeMapper.mapType(descriptor);
                iv.load(0, this.classAsmType);
                iv.load(codegen.myFrameMap.getIndex(descriptor), type);
                PropertyDescriptor propertyDescriptor = this.bindingContext.get(BindingContext.PRIMARY_CONSTRUCTOR_PARAMETER, parameter);
                assert (propertyDescriptor != null) : "Property descriptor is not found for primary constructor parameter: " + parameter;
                iv.putfield(this.classAsmType.getInternalName(), this.context.getFieldName(propertyDescriptor), type.getDescriptor());
            }
            ++curParam;
        }
        boolean generateInitializerInOuter = AsmUtil.isClassObjectWithBackingFieldsInOuter(this.descriptor);
        if (generateInitializerInOuter) {
            ImplementationBodyCodegen parentCodegen = CodegenUtil.getParentBodyCodegen(this);
            parentCodegen.genInitSingleton(this.descriptor, StackValue.singleton(this.descriptor, this.typeMapper));
            ImplementationBodyCodegen.generateInitializers(parentCodegen.createOrGetClInitCodegen(), this.myClass.getDeclarations(), this.bindingContext, this.state);
        } else {
            ImplementationBodyCodegen.generateInitializers(codegen, this.myClass.getDeclarations(), this.bindingContext, this.state);
        }
        iv.visitInsn(177);
    }

    private void genSuperCallToDelegatorToSuperClass(InstructionAdapter iv) {
        iv.load(0, this.superClassAsmType);
        JetType superType = this.bindingContext.get(BindingContext.TYPE, this.superCall.getTypeReference());
        ArrayList<Type> parameterTypes = new ArrayList<Type>();
        assert (superType != null);
        ClassDescriptor superClassDescriptor = (ClassDescriptor)superType.getConstructor().getDeclarationDescriptor();
        if (CodegenBinding.hasThis0(this.bindingContext, superClassDescriptor)) {
            iv.load(1, AsmTypeConstants.OBJECT_TYPE);
            parameterTypes.add(this.typeMapper.mapType(CodegenBinding.enclosingClassDescriptor(this.bindingContext, this.descriptor)));
        }
        Method superCallMethod = new Method("<init>", Type.VOID_TYPE, parameterTypes.toArray(new Type[parameterTypes.size()]));
        iv.invokespecial(this.typeMapper.mapType(superClassDescriptor).getInternalName(), "<init>", superCallMethod.getDescriptor());
    }

    private void genSimpleSuperCall(InstructionAdapter iv) {
        iv.load(0, this.superClassAsmType);
        if (this.descriptor.getKind() == ClassKind.ENUM_CLASS || this.descriptor.getKind() == ClassKind.ENUM_ENTRY) {
            iv.load(1, AsmTypeConstants.JAVA_STRING_TYPE);
            iv.load(2, Type.INT_TYPE);
            iv.invokespecial(this.superClassAsmType.getInternalName(), "<init>", "(Ljava/lang/String;I)V");
        } else {
            iv.invokespecial(this.superClassAsmType.getInternalName(), "<init>", "()V");
        }
    }

    private void genCallToDelegatorByExpressionSpecifier(InstructionAdapter iv, ExpressionCodegen codegen, int n, JetDelegationSpecifier specifier) {
        StackValue.Field field;
        ValueParameterDescriptor valueParameterDescriptor;
        CallableDescriptor callResultingDescriptor;
        ResolvedCall<? extends CallableDescriptor> call;
        JetExpression expression = ((JetDelegatorByExpressionSpecifier)specifier).getDelegateExpression();
        VariableDescriptor propertyDescriptor = null;
        if (expression instanceof JetSimpleNameExpression && (call = this.bindingContext.get(BindingContext.RESOLVED_CALL, expression)) != null && (callResultingDescriptor = call.getResultingDescriptor()) instanceof ValueParameterDescriptor && (valueParameterDescriptor = (ValueParameterDescriptor)callResultingDescriptor).getContainingDeclaration() instanceof ConstructorDescriptor && valueParameterDescriptor.getContainingDeclaration().getContainingDeclaration() == this.descriptor) {
            propertyDescriptor = this.bindingContext.get(BindingContext.VALUE_PARAMETER_AS_PROPERTY, valueParameterDescriptor);
        }
        JetType superType = this.bindingContext.get(BindingContext.TYPE, specifier.getTypeReference());
        assert (superType != null);
        ClassDescriptor superClassDescriptor = (ClassDescriptor)superType.getConstructor().getDeclarationDescriptor();
        assert (superClassDescriptor != null);
        if (propertyDescriptor != null && !propertyDescriptor.isVar() && Boolean.TRUE.equals(this.bindingContext.get(BindingContext.BACKING_FIELD_REQUIRED, propertyDescriptor))) {
            field = StackValue.field(this.typeMapper.mapType(propertyDescriptor), this.classAsmType, propertyDescriptor.getName().asString(), false);
        } else {
            iv.load(0, this.classAsmType);
            codegen.genToJVMStack(expression);
            String delegateField = "$delegate_" + n;
            Type fieldType = this.typeMapper.mapType(superClassDescriptor);
            String fieldDesc = fieldType.getDescriptor();
            this.v.newField(specifier, 4114, delegateField, fieldDesc, null, null);
            field = StackValue.field(fieldType, this.classAsmType, delegateField, false);
            ((StackValue)field).store(fieldType, iv);
        }
        this.generateDelegates(superClassDescriptor, field);
    }

    private void lookupConstructorExpressionsInClosureIfPresent(final ConstructorContext constructorContext) {
        JetVisitorVoid visitor = new JetVisitorVoid(){

            @Override
            public void visitJetElement(@NotNull JetElement e) {
                if (e == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "org/jetbrains/jet/codegen/ImplementationBodyCodegen$8", "visitJetElement"));
                }
                e.acceptChildren(this);
            }

            @Override
            public void visitSimpleNameExpression(@NotNull JetSimpleNameExpression expr) {
                DeclarationDescriptor toLookup;
                if (expr == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expr", "org/jetbrains/jet/codegen/ImplementationBodyCodegen$8", "visitSimpleNameExpression"));
                }
                DeclarationDescriptor descriptor = ImplementationBodyCodegen.this.bindingContext.get(BindingContext.REFERENCE_TARGET, expr);
                if (CodegenBinding.isLocalNamedFun(descriptor)) {
                    toLookup = descriptor;
                } else if (descriptor instanceof CallableMemberDescriptor) {
                    toLookup = descriptor.getContainingDeclaration();
                } else if (descriptor instanceof VariableDescriptor) {
                    ConstructorDescriptor constructorDescriptor = (ConstructorDescriptor)constructorContext.getContextDescriptor();
                    for (ValueParameterDescriptor parameterDescriptor : constructorDescriptor.getValueParameters()) {
                        if (!descriptor.equals(parameterDescriptor)) continue;
                        return;
                    }
                    toLookup = descriptor;
                } else {
                    return;
                }
                constructorContext.lookupInContext(toLookup, null, ImplementationBodyCodegen.this.state, true);
            }

            @Override
            public void visitThisExpression(@NotNull JetThisExpression expression) {
                if (expression == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/jet/codegen/ImplementationBodyCodegen$8", "visitThisExpression"));
                }
                DeclarationDescriptor descriptor = ImplementationBodyCodegen.this.bindingContext.get(BindingContext.REFERENCE_TARGET, expression.getInstanceReference());
                assert (descriptor instanceof CallableDescriptor || descriptor instanceof ClassDescriptor) : "'This' reference target should be class or callable descriptor but was " + descriptor;
                if (ImplementationBodyCodegen.this.context.getCallableDescriptorWithReceiver() != descriptor) {
                    ImplementationBodyCodegen.this.context.lookupInContext(descriptor, null, ImplementationBodyCodegen.this.state, true);
                }
            }
        };
        for (JetDeclaration declaration : this.myClass.getDeclarations()) {
            if (declaration instanceof JetProperty) {
                JetProperty property2 = (JetProperty)declaration;
                JetExpression initializer = property2.getInitializer();
                if (initializer == null) continue;
                initializer.accept(visitor);
                continue;
            }
            if (!(declaration instanceof JetClassInitializer)) continue;
            JetClassInitializer initializer = (JetClassInitializer)declaration;
            initializer.accept(visitor);
        }
        for (JetDelegationSpecifier specifier : this.myClass.getDelegationSpecifiers()) {
            JetValueArgumentList argumentList;
            if (specifier != this.superCall) {
                if (!(specifier instanceof JetDelegatorByExpressionSpecifier)) continue;
                JetExpression delegateExpression = ((JetDelegatorByExpressionSpecifier)specifier).getDelegateExpression();
                assert (delegateExpression != null);
                delegateExpression.accept(visitor);
                continue;
            }
            if (!(this.superCall instanceof JetDelegatorToSuperCall) || (argumentList = ((JetDelegatorToSuperCall)this.superCall).getValueArgumentList()) == null) continue;
            argumentList.accept(visitor);
        }
    }

    private boolean ignoreIfTraitOrAnnotation() {
        if (this.myClass instanceof JetClass) {
            JetClass aClass = (JetClass)this.myClass;
            if (aClass.isTrait()) {
                return true;
            }
            if (aClass.isAnnotation()) {
                return true;
            }
        }
        return false;
    }

    private void generateTraitMethods() {
        if (JetPsiUtil.isTrait(this.myClass)) {
            return;
        }
        for (Pair<CallableMemberDescriptor, CallableMemberDescriptor> needDelegates : this.getTraitImplementations(this.descriptor)) {
            if (needDelegates.second instanceof SimpleFunctionDescriptor) {
                this.generateDelegationToTraitImpl((FunctionDescriptor)needDelegates.second, (FunctionDescriptor)needDelegates.first);
                continue;
            }
            if (!(needDelegates.second instanceof PropertyDescriptor)) continue;
            PropertyDescriptor property2 = (PropertyDescriptor)needDelegates.second;
            List<PropertyAccessorDescriptor> inheritedAccessors = ((PropertyDescriptor)needDelegates.first).getAccessors();
            for (PropertyAccessorDescriptor accessor : property2.getAccessors()) {
                for (PropertyAccessorDescriptor inheritedAccessor : inheritedAccessors) {
                    if (inheritedAccessor.getClass() != accessor.getClass()) continue;
                    this.generateDelegationToTraitImpl(accessor, inheritedAccessor);
                }
            }
        }
    }

    private void generateDelegationToTraitImpl(@NotNull FunctionDescriptor fun, @NotNull FunctionDescriptor inheritedFun) {
        if (fun == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fun", "org/jetbrains/jet/codegen/ImplementationBodyCodegen", "generateDelegationToTraitImpl"));
        }
        if (inheritedFun == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "inheritedFun", "org/jetbrains/jet/codegen/ImplementationBodyCodegen", "generateDelegationToTraitImpl"));
        }
        DeclarationDescriptor containingDeclaration = fun.getContainingDeclaration();
        if (!(containingDeclaration instanceof ClassDescriptor)) {
            return;
        }
        ClassDescriptor containingClass = (ClassDescriptor)containingDeclaration;
        if (containingClass.getKind() != ClassKind.TRAIT) {
            return;
        }
        int flags = 1;
        Method methodToGenerate = this.typeMapper.mapSignature(fun).getAsmMethod();
        Method methodInTrait = this.typeMapper.mapSignature(fun.getOriginal()).getAsmMethod();
        PsiElement origin = BindingContextUtils.descriptorToDeclaration(this.bindingContext, fun);
        MethodVisitor mv = this.v.newMethod(origin, flags, methodToGenerate.getName(), methodToGenerate.getDescriptor(), null, CodegenUtil.getExceptions(fun, this.typeMapper));
        AnnotationCodegen.forMethod(mv, this.typeMapper).genAnnotations(fun);
        if (this.state.getClassBuilderMode() == ClassBuilderMode.FULL) {
            Type returnType = methodToGenerate.getReturnType();
            mv.visitCode();
            FrameMap frameMap = this.context.prepareFrame(this.typeMapper);
            ExpressionCodegen codegen = new ExpressionCodegen(mv, frameMap, returnType, this.context.intoFunction(inheritedFun), this.state, this);
            codegen.generateThisOrOuter(this.descriptor, false);
            Type[] argTypes = methodToGenerate.getArgumentTypes();
            Type[] originalArgTypes = methodInTrait.getArgumentTypes();
            InstructionAdapter iv = new InstructionAdapter(mv);
            iv.load(0, AsmTypeConstants.OBJECT_TYPE);
            int reg = 1;
            for (int i = 0; i < argTypes.length; ++i) {
                StackValue.local(reg, argTypes[i]).put(originalArgTypes[i], iv);
                reg += argTypes[i].getSize();
            }
            Type type = AsmUtil.getTraitImplThisParameterType(containingClass, this.typeMapper);
            String functionDescriptor = methodInTrait.getDescriptor().replace("(", "(" + type.getDescriptor());
            iv.invokestatic(this.typeMapper.mapTraitImpl(containingClass).getInternalName(), methodToGenerate.getName(), functionDescriptor);
            StackValue.onStack(methodInTrait.getReturnType()).put(returnType, iv);
            iv.areturn(returnType);
            FunctionCodegen.endVisit(iv, "trait method", BindingContextUtils.callableDescriptorToDeclaration(this.bindingContext, fun));
        }
        FunctionCodegen.generateBridgeIfNeeded(this.context, this.state, this.v, fun);
    }

    private void generateDelegatorToConstructorCall(InstructionAdapter iv, ExpressionCodegen codegen, ConstructorDescriptor constructorDescriptor) {
        ClassDescriptor classDecl = constructorDescriptor.getContainingDeclaration();
        iv.load(0, AsmTypeConstants.OBJECT_TYPE);
        if (classDecl.getKind() == ClassKind.ENUM_CLASS || classDecl.getKind() == ClassKind.ENUM_ENTRY) {
            iv.load(1, AsmTypeConstants.OBJECT_TYPE);
            iv.load(2, Type.INT_TYPE);
        }
        CallableMethod method = this.typeMapper.mapToCallableMethod(constructorDescriptor);
        ResolvedCall<? extends CallableDescriptor> resolvedCall = this.bindingContext.get(BindingContext.RESOLVED_CALL, ((JetCallElement)((Object)this.superCall)).getCalleeExpression());
        assert (resolvedCall != null);
        ConstructorDescriptor superConstructor = (ConstructorDescriptor)resolvedCall.getResultingDescriptor();
        CalculatedClosure closureForSuper = this.bindingContext.get(CodegenBinding.CLOSURE, superConstructor.getContainingDeclaration());
        if (closureForSuper != null && closureForSuper.getCaptureThis() != null) {
            iv.load(((ConstructorFrameMap)codegen.myFrameMap).getOuterThisIndex(), AsmTypeConstants.OBJECT_TYPE);
        }
        CallableMethod superCallable = this.typeMapper.mapToCallableMethod(superConstructor);
        if (DescriptorUtils.isAnonymousObject(this.descriptor) && this.superCall instanceof JetDelegatorToSuperCall) {
            int nextVar = ImplementationBodyCodegen.findFirstSuperArgument(method);
            for (Type t : superCallable.getAsmMethod().getArgumentTypes()) {
                iv.load(nextVar, t);
                nextVar += t.getSize();
            }
            superCallable.invokeWithNotNullAssertion(codegen.v, this.state, resolvedCall);
        } else {
            codegen.invokeMethodWithArguments(null, superCallable, resolvedCall, StackValue.none());
        }
    }

    private static int findFirstSuperArgument(@NotNull CallableMethod method) {
        if (method == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "method", "org/jetbrains/jet/codegen/ImplementationBodyCodegen", "findFirstSuperArgument"));
        }
        int i = 0;
        for (JvmMethodParameterSignature type : method.getValueParameters()) {
            if (type.getKind() == JvmMethodParameterKind.SUPER_CALL_PARAM) {
                return i + 1;
            }
            i += type.getAsmType().getSize();
        }
        return -1;
    }

    @Override
    protected void generateDeclaration(PropertyCodegen propertyCodegen, JetDeclaration declaration) {
        if (declaration instanceof JetEnumEntry) {
            String name = declaration.getName();
            assert (name != null) : "Enum entry has no name: " + declaration.getText();
            String desc = "L" + this.classAsmType.getInternalName() + ";";
            this.v.newField(declaration, 16409, name, desc, null, null);
            this.myEnumConstants.add((JetEnumEntry)declaration);
        }
        super.generateDeclaration(propertyCodegen, declaration);
    }

    private void initializeEnumConstants() {
        if (this.state.getClassBuilderMode() != ClassBuilderMode.FULL) {
            return;
        }
        ExpressionCodegen codegen = this.createOrGetClInitCodegen();
        InstructionAdapter iv = codegen.v;
        Type arrayAsmType = this.typeMapper.mapType(KotlinBuiltIns.getInstance().getArrayType(this.descriptor.getDefaultType()));
        this.v.newField(this.myClass, 4122, "$VALUES", arrayAsmType.getDescriptor(), null, null);
        iv.iconst(this.myEnumConstants.size());
        iv.newarray(this.classAsmType);
        if (!this.myEnumConstants.isEmpty()) {
            iv.dup();
            int size = this.myEnumConstants.size();
            for (int ordinal = 0; ordinal < size; ++ordinal) {
                this.initializeEnumConstant(codegen, ordinal);
            }
        }
        iv.putstatic(this.classAsmType.getInternalName(), "$VALUES", arrayAsmType.getDescriptor());
    }

    private void initializeEnumConstant(@NotNull ExpressionCodegen codegen, int ordinal) {
        if (codegen == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "codegen", "org/jetbrains/jet/codegen/ImplementationBodyCodegen", "initializeEnumConstant"));
        }
        InstructionAdapter iv = codegen.v;
        JetEnumEntry enumConstant = this.myEnumConstants.get(ordinal);
        iv.dup();
        iv.iconst(ordinal);
        ClassDescriptor classDescriptor = this.bindingContext.get(BindingContext.CLASS, enumConstant);
        assert (classDescriptor != null);
        Type implClass = this.typeMapper.mapClass(classDescriptor);
        List<JetDelegationSpecifier> delegationSpecifiers = enumConstant.getDelegationSpecifiers();
        if (delegationSpecifiers.size() > 1) {
            throw new UnsupportedOperationException("multiple delegation specifiers for enum constant not supported");
        }
        iv.anew(implClass);
        iv.dup();
        iv.aconst(enumConstant.getName());
        iv.iconst(ordinal);
        if (delegationSpecifiers.size() == 1 && !CodegenBinding.enumEntryNeedSubclass(this.state.getBindingContext(), enumConstant)) {
            JetDelegationSpecifier specifier = delegationSpecifiers.get(0);
            if (!(specifier instanceof JetDelegatorToSuperCall)) {
                throw new UnsupportedOperationException("unsupported type of enum constant initializer: " + specifier);
            }
            ResolvedCall<? extends CallableDescriptor> resolvedCall = this.bindingContext.get(BindingContext.RESOLVED_CALL, ((JetDelegatorToSuperCall)specifier).getCalleeExpression());
            assert (resolvedCall != null) : "Enum entry delegation specifier is unresolved: " + specifier.getText();
            CallableMethod method = this.typeMapper.mapToCallableMethod((ConstructorDescriptor)resolvedCall.getResultingDescriptor());
            codegen.invokeMethodWithArguments(null, method, resolvedCall, StackValue.none());
        } else {
            iv.invokespecial(implClass.getInternalName(), "<init>", "(Ljava/lang/String;I)V");
        }
        iv.dup();
        iv.putstatic(this.classAsmType.getInternalName(), enumConstant.getName(), this.classAsmType.getDescriptor());
        iv.astore(AsmTypeConstants.OBJECT_TYPE);
    }

    public static void generateInitializers(@NotNull ExpressionCodegen codegen, @NotNull List<JetDeclaration> declarations, @NotNull BindingContext bindingContext, @NotNull GenerationState state) {
        if (codegen == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "codegen", "org/jetbrains/jet/codegen/ImplementationBodyCodegen", "generateInitializers"));
        }
        if (declarations == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "declarations", "org/jetbrains/jet/codegen/ImplementationBodyCodegen", "generateInitializers"));
        }
        if (bindingContext == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "bindingContext", "org/jetbrains/jet/codegen/ImplementationBodyCodegen", "generateInitializers"));
        }
        if (state == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "state", "org/jetbrains/jet/codegen/ImplementationBodyCodegen", "generateInitializers"));
        }
        JetTypeMapper typeMapper = state.getTypeMapper();
        for (JetDeclaration declaration : declarations) {
            if (declaration instanceof JetProperty) {
                if (!ImplementationBodyCodegen.shouldInitializeProperty((JetProperty)declaration, typeMapper)) continue;
                ImplementationBodyCodegen.initializeProperty(codegen, bindingContext, (JetProperty)declaration);
                continue;
            }
            if (!(declaration instanceof JetClassInitializer)) continue;
            codegen.gen(((JetClassInitializer)declaration).getBody(), Type.VOID_TYPE);
        }
    }

    public static void initializeProperty(@NotNull ExpressionCodegen codegen, @NotNull BindingContext bindingContext, @NotNull JetProperty property2) {
        if (codegen == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "codegen", "org/jetbrains/jet/codegen/ImplementationBodyCodegen", "initializeProperty"));
        }
        if (bindingContext == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "bindingContext", "org/jetbrains/jet/codegen/ImplementationBodyCodegen", "initializeProperty"));
        }
        if (property2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "property", "org/jetbrains/jet/codegen/ImplementationBodyCodegen", "initializeProperty"));
        }
        PropertyDescriptor propertyDescriptor = (PropertyDescriptor)bindingContext.get(BindingContext.VARIABLE, property2);
        assert (propertyDescriptor != null);
        JetExpression initializer = property2.getDelegateExpressionOrInitializer();
        assert (initializer != null) : "shouldInitializeProperty must return false if initializer is null";
        JetType jetType = ImplementationBodyCodegen.getPropertyOrDelegateType(bindingContext, property2, propertyDescriptor);
        StackValue.Property propValue = codegen.intermediateValueForProperty(propertyDescriptor, true, null, MethodKind.INITIALIZER);
        if (!propValue.isStatic) {
            codegen.v.load(0, AsmTypeConstants.OBJECT_TYPE);
        }
        Type type = codegen.expressionType(initializer);
        if (jetType.isNullable()) {
            type = AsmUtil.boxType(type);
        }
        codegen.gen(initializer, type);
        ((StackValue)propValue).store(type, codegen.v);
    }

    public static boolean shouldWriteFieldInitializer(PropertyDescriptor descriptor, JetTypeMapper mapper) {
        if (!descriptor.isVar()) {
            Type type = mapper.mapType(descriptor);
            return AsmUtil.isPrimitive(type) || "java.lang.String".equals(type.getClassName());
        }
        return false;
    }

    public static boolean shouldInitializeProperty(@NotNull JetProperty property2, @NotNull JetTypeMapper typeMapper) {
        JetType jetType;
        Type type;
        if (property2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "property", "org/jetbrains/jet/codegen/ImplementationBodyCodegen", "shouldInitializeProperty"));
        }
        if (typeMapper == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "typeMapper", "org/jetbrains/jet/codegen/ImplementationBodyCodegen", "shouldInitializeProperty"));
        }
        JetExpression initializer = property2.getDelegateExpressionOrInitializer();
        if (initializer == null) {
            return false;
        }
        CompileTimeConstant compileTimeValue = ExpressionCodegen.getCompileTimeConstant(initializer, typeMapper.getBindingContext());
        if (compileTimeValue == null) {
            return true;
        }
        PropertyDescriptor propertyDescriptor = (PropertyDescriptor)typeMapper.getBindingContext().get(BindingContext.VARIABLE, property2);
        assert (propertyDescriptor != null);
        Object value = compileTimeValue.getValue();
        return !ImplementationBodyCodegen.skipDefaultValue(propertyDescriptor, value, type = typeMapper.mapType(jetType = ImplementationBodyCodegen.getPropertyOrDelegateType(typeMapper.getBindingContext(), property2, propertyDescriptor)));
    }

    @NotNull
    private static JetType getPropertyOrDelegateType(@NotNull BindingContext bindingContext, @NotNull JetProperty property2, @NotNull PropertyDescriptor descriptor) {
        if (bindingContext == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "bindingContext", "org/jetbrains/jet/codegen/ImplementationBodyCodegen", "getPropertyOrDelegateType"));
        }
        if (property2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "property", "org/jetbrains/jet/codegen/ImplementationBodyCodegen", "getPropertyOrDelegateType"));
        }
        if (descriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "org/jetbrains/jet/codegen/ImplementationBodyCodegen", "getPropertyOrDelegateType"));
        }
        JetExpression delegateExpression = property2.getDelegateExpression();
        if (delegateExpression != null) {
            JetType delegateType = bindingContext.get(BindingContext.EXPRESSION_TYPE, delegateExpression);
            assert (delegateType != null) : "Type of delegate expression should be recorded";
            JetType jetType = delegateType;
            if (jetType == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/codegen/ImplementationBodyCodegen", "getPropertyOrDelegateType"));
            }
            return jetType;
        }
        JetType jetType = descriptor.getType();
        if (jetType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/codegen/ImplementationBodyCodegen", "getPropertyOrDelegateType"));
        }
        return jetType;
    }

    private static boolean skipDefaultValue(@NotNull PropertyDescriptor propertyDescriptor, Object value, @NotNull Type type) {
        if (propertyDescriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "propertyDescriptor", "org/jetbrains/jet/codegen/ImplementationBodyCodegen", "skipDefaultValue"));
        }
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "org/jetbrains/jet/codegen/ImplementationBodyCodegen", "skipDefaultValue"));
        }
        if (AsmUtil.isPrimitive(type)) {
            if (!propertyDescriptor.getType().isNullable() && value instanceof Number) {
                if (type == Type.INT_TYPE && ((Number)value).intValue() == 0) {
                    return true;
                }
                if (type == Type.BYTE_TYPE && ((Number)value).byteValue() == 0) {
                    return true;
                }
                if (type == Type.LONG_TYPE && ((Number)value).longValue() == 0L) {
                    return true;
                }
                if (type == Type.SHORT_TYPE && ((Number)value).shortValue() == 0) {
                    return true;
                }
                if (type == Type.DOUBLE_TYPE && ((Number)value).doubleValue() == 0.0) {
                    return true;
                }
                if (type == Type.FLOAT_TYPE && ((Number)value).floatValue() == 0.0f) {
                    return true;
                }
            }
            if (type == Type.BOOLEAN_TYPE && value instanceof Boolean && !((Boolean)value).booleanValue()) {
                return true;
            }
            if (type == Type.CHAR_TYPE && value instanceof Character && ((Character)value).charValue() == '\u0000') {
                return true;
            }
        } else if (value == null) {
            return true;
        }
        return false;
    }

    protected void generateDelegates(ClassDescriptor toClass, StackValue field) {
        for (DeclarationDescriptor declaration : this.descriptor.getDefaultType().getMemberScope().getAllDescriptors()) {
            CallableMemberDescriptor callableMemberDescriptor;
            if (!(declaration instanceof CallableMemberDescriptor) || (callableMemberDescriptor = (CallableMemberDescriptor)declaration).getKind() != CallableMemberDescriptor.Kind.DELEGATION) continue;
            Set<? extends CallableMemberDescriptor> overriddenDescriptors = callableMemberDescriptor.getOverriddenDescriptors();
            for (CallableMemberDescriptor callableMemberDescriptor2 : overriddenDescriptors) {
                if (callableMemberDescriptor2.getContainingDeclaration() != toClass) continue;
                if (declaration instanceof PropertyDescriptor) {
                    this.propertyCodegen.genDelegate((PropertyDescriptor)declaration, (PropertyDescriptor)callableMemberDescriptor2, field);
                    continue;
                }
                if (!(declaration instanceof FunctionDescriptor)) continue;
                this.functionCodegen.genDelegate((FunctionDescriptor)declaration, (FunctionDescriptor)callableMemberDescriptor2, field);
            }
        }
    }

    private List<Pair<CallableMemberDescriptor, CallableMemberDescriptor>> getTraitImplementations(@NotNull ClassDescriptor classDescriptor) {
        if (classDescriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "classDescriptor", "org/jetbrains/jet/codegen/ImplementationBodyCodegen", "getTraitImplementations"));
        }
        ArrayList<Pair<CallableMemberDescriptor, CallableMemberDescriptor>> r = Lists.newArrayList();
        for (DeclarationDescriptor decl : classDescriptor.getDefaultType().getMemberScope().getAllDescriptors()) {
            CallableMemberDescriptor callableMemberDescriptor;
            if (!(decl instanceof CallableMemberDescriptor) || (callableMemberDescriptor = (CallableMemberDescriptor)decl).getKind() != CallableMemberDescriptor.Kind.FAKE_OVERRIDE || CallResolverUtil.isOrOverridesSynthesized(callableMemberDescriptor)) continue;
            Collection<CallableMemberDescriptor> overriddenDeclarations = OverridingUtil.getOverriddenDeclarations(callableMemberDescriptor);
            Set<CallableMemberDescriptor> filteredOverriddenDeclarations = OverridingUtil.filterOutOverridden(Sets.newLinkedHashSet(overriddenDeclarations));
            int count = 0;
            CallableDescriptor candidate = null;
            for (CallableMemberDescriptor overriddenDeclaration : filteredOverriddenDeclarations) {
                if (!DescriptorUtils.isTrait(overriddenDeclaration.getContainingDeclaration()) || overriddenDeclaration.getModality() == Modality.ABSTRACT) continue;
                candidate = overriddenDeclaration;
                ++count;
            }
            if (candidate == null) continue;
            assert (count == 1) : "Ambiguous overridden declaration: " + callableMemberDescriptor.getName();
            Set superTypesOfSuperClass = this.superClassType != null ? TypeUtils.getAllSupertypes(this.superClassType) : Collections.emptySet();
            ReceiverParameterDescriptor expectedThisObject = candidate.getExpectedThisObject();
            assert (expectedThisObject != null);
            JetType candidateType = expectedThisObject.getType();
            boolean implementedInSuperClass = superTypesOfSuperClass.contains(candidateType);
            if (implementedInSuperClass) continue;
            r.add(Pair.create(callableMemberDescriptor, candidate));
        }
        return r;
    }

    public void addClassObjectPropertyToCopy(PropertyDescriptor descriptor, Object defaultValue) {
        if (this.classObjectPropertiesToCopy == null) {
            this.classObjectPropertiesToCopy = new ArrayList<PropertyAndDefaultValue>();
        }
        this.classObjectPropertiesToCopy.add(new PropertyAndDefaultValue(descriptor, defaultValue));
    }

    private static class PropertyAndDefaultValue {
        public final PropertyDescriptor descriptor;
        public final Object defaultValue;

        public PropertyAndDefaultValue(PropertyDescriptor descriptor, Object defaultValue) {
            this.descriptor = descriptor;
            this.defaultValue = defaultValue;
        }
    }
}

