/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.codegen;

import com.intellij.util.containers.MultiMap;
import java.util.Collection;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.asm4.Type;
import org.jetbrains.jet.codegen.CompilationErrorHandler;
import org.jetbrains.jet.codegen.PackageCodegen;
import org.jetbrains.jet.codegen.binding.CodegenBinding;
import org.jetbrains.jet.codegen.state.GenerationState;
import org.jetbrains.jet.lang.psi.JetFile;
import org.jetbrains.jet.lang.psi.JetPsiUtil;
import org.jetbrains.jet.lang.psi.JetScript;
import org.jetbrains.jet.lang.resolve.ScriptNameUtil;
import org.jetbrains.jet.lang.resolve.name.FqName;

public class KotlinCodegenFacade {
    public static void compileCorrectFiles(@NotNull GenerationState state, @NotNull CompilationErrorHandler errorHandler) {
        if (state == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "state", "org/jetbrains/jet/codegen/KotlinCodegenFacade", "compileCorrectFiles"));
        }
        if (errorHandler == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "errorHandler", "org/jetbrains/jet/codegen/KotlinCodegenFacade", "compileCorrectFiles"));
        }
        for (JetFile file : state.getFiles()) {
            if (!file.isScript()) continue;
            String string = ScriptNameUtil.classNameForScript(file);
            JetScript script = file.getScript();
            assert (script != null);
            CodegenBinding.registerClassNameForScript(state.getBindingTrace(), script, Type.getObjectType(string));
        }
        state.beforeCompile();
        MultiMap<FqName, JetFile> packageFqNameToFiles = new MultiMap<FqName, JetFile>();
        for (JetFile jetFile : state.getFiles()) {
            if (jetFile == null) {
                throw new IllegalArgumentException("A null file given for compilation");
            }
            packageFqNameToFiles.putValue(JetPsiUtil.getFQName(jetFile), jetFile);
        }
        for (Map.Entry entry : packageFqNameToFiles.entrySet()) {
            KotlinCodegenFacade.generatePackage(state, (FqName)entry.getKey(), (Collection)entry.getValue(), errorHandler);
        }
        state.getFactory().done();
    }

    public static void generatePackage(@NotNull GenerationState state, @NotNull FqName fqName, @NotNull Collection<JetFile> jetFiles, @NotNull CompilationErrorHandler errorHandler) {
        if (state == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "state", "org/jetbrains/jet/codegen/KotlinCodegenFacade", "generatePackage"));
        }
        if (fqName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fqName", "org/jetbrains/jet/codegen/KotlinCodegenFacade", "generatePackage"));
        }
        if (jetFiles == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "jetFiles", "org/jetbrains/jet/codegen/KotlinCodegenFacade", "generatePackage"));
        }
        if (errorHandler == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "errorHandler", "org/jetbrains/jet/codegen/KotlinCodegenFacade", "generatePackage"));
        }
        PackageCodegen codegen = state.getFactory().forPackage(fqName, jetFiles);
        codegen.generate(errorHandler);
    }

    private KotlinCodegenFacade() {
    }
}

