/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.codegen.inline;

import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.asm4.tree.AbstractInsnNode;
import org.jetbrains.asm4.tree.FieldInsnNode;
import org.jetbrains.asm4.tree.MethodNode;
import org.jetbrains.asm4.tree.VarInsnNode;
import org.jetbrains.jet.codegen.inline.CapturedParamInfo;
import org.jetbrains.jet.codegen.inline.LambdaInfo;
import org.jetbrains.jet.codegen.inline.MethodInliner;
import org.jetbrains.jet.codegen.inline.Parameters;

public class LambdaFieldRemapper {
    private String lambdaInternalName;
    protected LambdaFieldRemapper parent;
    private final Parameters params;

    public LambdaFieldRemapper(@Nullable String lambdaInternalName, @Nullable LambdaFieldRemapper parent, @NotNull Parameters methodParams) {
        if (methodParams == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "methodParams", "org/jetbrains/jet/codegen/inline/LambdaFieldRemapper", "<init>"));
        }
        this.lambdaInternalName = lambdaInternalName;
        this.parent = parent;
        this.params = methodParams;
    }

    public AbstractInsnNode doTransform(MethodNode node, FieldInsnNode fieldInsnNode, CapturedParamInfo capturedField) {
        AbstractInsnNode loadThis = LambdaFieldRemapper.getPreviousThis(fieldInsnNode);
        int opcode = fieldInsnNode.getOpcode() == 180 ? capturedField.getType().getOpcode(21) : capturedField.getType().getOpcode(54);
        VarInsnNode newInstruction = new VarInsnNode(opcode, capturedField.getIndex());
        node.instructions.remove(loadThis);
        node.instructions.insertBefore(fieldInsnNode, newInstruction);
        node.instructions.remove(fieldInsnNode);
        return newInstruction;
    }

    protected static AbstractInsnNode getPreviousThis(FieldInsnNode fieldInsnNode) {
        AbstractInsnNode loadThis = MethodInliner.getPreviousNoLabelNoLine(fieldInsnNode);
        assert (loadThis.getType() == 2 || loadThis.getType() == 4) : "Field access instruction should go after load this but goes after " + loadThis;
        assert (loadThis.getOpcode() == 25 || loadThis.getOpcode() == 178) : "This should be loaded by ALOAD or GETSTATIC but " + loadThis.getOpcode();
        return loadThis;
    }

    public List<CapturedParamInfo> markRecaptured(List<CapturedParamInfo> originalCaptured, LambdaInfo lambda) {
        return originalCaptured;
    }

    public boolean canProcess(@NotNull String owner, @NotNull String currentLambdaType) {
        if (owner == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "owner", "org/jetbrains/jet/codegen/inline/LambdaFieldRemapper", "canProcess"));
        }
        if (currentLambdaType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "currentLambdaType", "org/jetbrains/jet/codegen/inline/LambdaFieldRemapper", "canProcess"));
        }
        return owner.equals(currentLambdaType);
    }

    @Nullable
    public CapturedParamInfo findField(@NotNull FieldInsnNode fieldInsnNode, @NotNull Collection<CapturedParamInfo> captured) {
        if (fieldInsnNode == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fieldInsnNode", "org/jetbrains/jet/codegen/inline/LambdaFieldRemapper", "findField"));
        }
        if (captured == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "captured", "org/jetbrains/jet/codegen/inline/LambdaFieldRemapper", "findField"));
        }
        for (CapturedParamInfo valueDescriptor : captured) {
            if (!valueDescriptor.getFieldName().equals(fieldInsnNode.name)) continue;
            return valueDescriptor;
        }
        return null;
    }

    public LambdaFieldRemapper getParent() {
        return this.parent;
    }

    public String getLambdaInternalName() {
        return this.lambdaInternalName;
    }

    public boolean isRoot() {
        return this.parent == null;
    }

    public boolean shouldPatch(@NotNull FieldInsnNode node) {
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "org/jetbrains/jet/codegen/inline/LambdaFieldRemapper", "shouldPatch"));
        }
        return !this.isRoot() && this.parent.shouldPatch(node);
    }

    @NotNull
    public AbstractInsnNode patch(@NotNull FieldInsnNode field, @NotNull MethodNode node) {
        if (field == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "field", "org/jetbrains/jet/codegen/inline/LambdaFieldRemapper", "patch"));
        }
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "org/jetbrains/jet/codegen/inline/LambdaFieldRemapper", "patch"));
        }
        if (!this.isRoot()) {
            AbstractInsnNode abstractInsnNode = this.parent.patch(field, node);
            if (abstractInsnNode == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/codegen/inline/LambdaFieldRemapper", "patch"));
            }
            return abstractInsnNode;
        }
        throw new IllegalStateException("Should be invoked");
    }
}

