/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.codegen.inline;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.asm4.Type;
import org.jetbrains.asm4.tree.MethodNode;
import org.jetbrains.jet.codegen.binding.CalculatedClosure;
import org.jetbrains.jet.codegen.binding.CodegenBinding;
import org.jetbrains.jet.codegen.context.EnclosedValueDescriptor;
import org.jetbrains.jet.codegen.inline.CapturedParamInfo;
import org.jetbrains.jet.codegen.inline.LambdaFieldRemapper;
import org.jetbrains.jet.codegen.inline.Parameters;
import org.jetbrains.jet.codegen.inline.ParametersBuilder;
import org.jetbrains.jet.codegen.state.JetTypeMapper;
import org.jetbrains.jet.lang.descriptors.ClassDescriptor;
import org.jetbrains.jet.lang.descriptors.FunctionDescriptor;
import org.jetbrains.jet.lang.descriptors.ValueParameterDescriptor;
import org.jetbrains.jet.lang.psi.JetFunctionLiteral;
import org.jetbrains.jet.lang.psi.JetFunctionLiteralExpression;
import org.jetbrains.jet.lang.resolve.BindingContext;
import org.jetbrains.jet.lang.resolve.java.AsmTypeConstants;

public class LambdaInfo {
    public final JetFunctionLiteralExpression expression;
    @NotNull
    private final JetTypeMapper typeMapper;
    public final CalculatedClosure closure;
    private MethodNode node;
    private List<CapturedParamInfo> capturedVars;
    private final FunctionDescriptor functionDescriptor;
    private final ClassDescriptor classDescriptor;
    private final Type closureClassType;

    LambdaInfo(@NotNull JetFunctionLiteralExpression expression, @NotNull JetTypeMapper typeMapper) {
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/jet/codegen/inline/LambdaInfo", "<init>"));
        }
        if (typeMapper == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "typeMapper", "org/jetbrains/jet/codegen/inline/LambdaInfo", "<init>"));
        }
        this.expression = expression;
        this.typeMapper = typeMapper;
        BindingContext bindingContext = typeMapper.getBindingContext();
        this.functionDescriptor = bindingContext.get(BindingContext.FUNCTION, expression.getFunctionLiteral());
        assert (this.functionDescriptor != null) : "Function is not resolved to descriptor: " + expression.getText();
        this.classDescriptor = CodegenBinding.anonymousClassForFunction(bindingContext, this.functionDescriptor);
        this.closureClassType = CodegenBinding.asmTypeForAnonymousClass(bindingContext, this.functionDescriptor);
        this.closure = bindingContext.get(CodegenBinding.CLOSURE, this.classDescriptor);
    }

    public MethodNode getNode() {
        return this.node;
    }

    public void setNode(MethodNode node) {
        this.node = node;
    }

    public FunctionDescriptor getFunctionDescriptor() {
        return this.functionDescriptor;
    }

    public JetFunctionLiteral getFunctionLiteral() {
        return this.expression.getFunctionLiteral();
    }

    public ClassDescriptor getClassDescriptor() {
        return this.classDescriptor;
    }

    public Type getLambdaClassType() {
        return this.closureClassType;
    }

    public List<CapturedParamInfo> getCapturedVars() {
        int index = 0;
        if (this.capturedVars == null) {
            EnclosedValueDescriptor descriptor;
            this.capturedVars = new ArrayList<CapturedParamInfo>();
            if (this.closure.getCaptureThis() != null) {
                descriptor = new EnclosedValueDescriptor("this$0", null, null, this.typeMapper.mapType(this.closure.getCaptureThis()));
                this.capturedVars.add(LambdaInfo.getCapturedParamInfo(descriptor, index));
                index += descriptor.getType().getSize();
            }
            if (this.closure.getCaptureReceiverType() != null) {
                descriptor = new EnclosedValueDescriptor("receiver$0", null, null, this.typeMapper.mapType(this.closure.getCaptureReceiverType()));
                this.capturedVars.add(LambdaInfo.getCapturedParamInfo(descriptor, index));
                index += descriptor.getType().getSize();
            }
            if (this.closure != null) {
                for (EnclosedValueDescriptor descriptor2 : this.closure.getCaptureVariables().values()) {
                    this.capturedVars.add(LambdaInfo.getCapturedParamInfo(descriptor2, index));
                    index += descriptor2.getType().getSize();
                }
            }
        }
        return this.capturedVars;
    }

    @NotNull
    public static CapturedParamInfo getCapturedParamInfo(@NotNull EnclosedValueDescriptor descriptor, int index) {
        if (descriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "org/jetbrains/jet/codegen/inline/LambdaInfo", "getCapturedParamInfo"));
        }
        CapturedParamInfo capturedParamInfo = new CapturedParamInfo(descriptor.getFieldName(), descriptor.getType(), false, index, -1);
        if (capturedParamInfo == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/codegen/inline/LambdaInfo", "getCapturedParamInfo"));
        }
        return capturedParamInfo;
    }

    public void setParamOffset(int paramOffset) {
        for (CapturedParamInfo var : this.getCapturedVars()) {
            var.setShift(paramOffset);
        }
    }

    public List<Type> getParamsWithoutCapturedValOrVar() {
        Type[] types = this.typeMapper.mapSignature(this.functionDescriptor).getAsmMethod().getArgumentTypes();
        return Arrays.asList(types);
    }

    public Parameters addAllParameters(@NotNull LambdaFieldRemapper remapper) {
        if (remapper == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "remapper", "org/jetbrains/jet/codegen/inline/LambdaInfo", "addAllParameters"));
        }
        ParametersBuilder builder = ParametersBuilder.newBuilder();
        builder.addThis(AsmTypeConstants.OBJECT_TYPE, true).setLambda(this);
        List<ValueParameterDescriptor> valueParameters = this.getFunctionDescriptor().getValueParameters();
        for (ValueParameterDescriptor parameter : valueParameters) {
            Type type = this.typeMapper.mapType(parameter.getType());
            builder.addNextParameter(type, false, null);
        }
        List<CapturedParamInfo> infos = remapper.markRecaptured(this.getCapturedVars(), this);
        for (CapturedParamInfo info : infos) {
            builder.addCapturedParam(info.getFieldName(), info.getType(), info.isSkipped, info);
        }
        return builder.buildParameters();
    }

    public int getCapturedVarsSize() {
        int size = 0;
        for (CapturedParamInfo next : this.getCapturedVars()) {
            size += next.getType().getSize();
        }
        return size;
    }
}

