/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.lang.resolve;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.intellij.lang.ASTNode;
import com.intellij.psi.PsiElement;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.LinkedMultiMap;
import com.intellij.util.containers.MultiMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.KotlinPackage;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jet.lang.descriptors.CallableDescriptor;
import org.jetbrains.jet.lang.descriptors.CallableMemberDescriptor;
import org.jetbrains.jet.lang.descriptors.ClassDescriptor;
import org.jetbrains.jet.lang.descriptors.ClassDescriptorWithResolutionScopes;
import org.jetbrains.jet.lang.descriptors.ClassifierDescriptor;
import org.jetbrains.jet.lang.descriptors.DeclarationDescriptor;
import org.jetbrains.jet.lang.descriptors.Modality;
import org.jetbrains.jet.lang.descriptors.PropertyDescriptor;
import org.jetbrains.jet.lang.descriptors.SimpleFunctionDescriptor;
import org.jetbrains.jet.lang.descriptors.ValueParameterDescriptor;
import org.jetbrains.jet.lang.descriptors.Visibilities;
import org.jetbrains.jet.lang.descriptors.Visibility;
import org.jetbrains.jet.lang.descriptors.annotations.AnnotationDescriptor;
import org.jetbrains.jet.lang.descriptors.impl.MutableClassDescriptor;
import org.jetbrains.jet.lang.descriptors.impl.MutableClassDescriptorLite;
import org.jetbrains.jet.lang.diagnostics.Errors;
import org.jetbrains.jet.lang.psi.JetAnnotationEntry;
import org.jetbrains.jet.lang.psi.JetClass;
import org.jetbrains.jet.lang.psi.JetClassOrObject;
import org.jetbrains.jet.lang.psi.JetDeclaration;
import org.jetbrains.jet.lang.psi.JetModifierList;
import org.jetbrains.jet.lang.psi.JetModifierListOwner;
import org.jetbrains.jet.lang.psi.JetNamedDeclaration;
import org.jetbrains.jet.lang.psi.JetObjectDeclaration;
import org.jetbrains.jet.lang.psi.JetParameter;
import org.jetbrains.jet.lang.psi.JetProperty;
import org.jetbrains.jet.lang.resolve.BindingContext;
import org.jetbrains.jet.lang.resolve.BindingContextUtils;
import org.jetbrains.jet.lang.resolve.BindingTrace;
import org.jetbrains.jet.lang.resolve.DelegationResolver;
import org.jetbrains.jet.lang.resolve.DescriptorUtils;
import org.jetbrains.jet.lang.resolve.OverridingUtil;
import org.jetbrains.jet.lang.resolve.TopDownAnalysisContext;
import org.jetbrains.jet.lang.resolve.calls.CallResolverUtil;
import org.jetbrains.jet.lang.resolve.name.Name;
import org.jetbrains.jet.lang.resolve.scopes.JetScope;
import org.jetbrains.jet.lang.types.JetType;
import org.jetbrains.jet.lang.types.checker.JetTypeChecker;
import org.jetbrains.jet.lang.types.lang.KotlinBuiltIns;
import org.jetbrains.jet.lexer.JetTokens;

public class OverrideResolver {
    private BindingTrace trace;

    public void setTrace(BindingTrace trace) {
        this.trace = trace;
    }

    public void process(@NotNull TopDownAnalysisContext c) {
        if (c == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "c", "org/jetbrains/jet/lang/resolve/OverrideResolver", "process"));
        }
        this.generateOverridesAndDelegation(c);
        this.checkVisibility(c);
        this.checkOverrides(c);
        this.checkParameterOverridesForAllClasses(c);
    }

    private void generateOverridesAndDelegation(@NotNull TopDownAnalysisContext c) {
        if (c == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "c", "org/jetbrains/jet/lang/resolve/OverrideResolver", "generateOverridesAndDelegation"));
        }
        HashSet<ClassDescriptorWithResolutionScopes> ourClasses = new HashSet<ClassDescriptorWithResolutionScopes>(c.getClasses().values());
        HashSet<ClassifierDescriptor> processed = new HashSet<ClassifierDescriptor>();
        for (MutableClassDescriptorLite klass : ContainerUtil.reverse(c.getClassesTopologicalOrder())) {
            if (!(klass instanceof MutableClassDescriptor) || !ourClasses.contains(klass)) continue;
            this.generateOverridesAndDelegationInAClass((MutableClassDescriptor)klass, processed, ourClasses);
            MutableClassDescriptorLite classObject = klass.getClassObjectDescriptor();
            if (!(classObject instanceof MutableClassDescriptor)) continue;
            this.generateOverridesAndDelegationInAClass((MutableClassDescriptor)classObject, processed, ourClasses);
        }
    }

    private void generateOverridesAndDelegationInAClass(@NotNull MutableClassDescriptor classDescriptor, @NotNull Set<ClassifierDescriptor> processed, @NotNull Set<ClassDescriptorWithResolutionScopes> classesBeingAnalyzed) {
        if (classDescriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "classDescriptor", "org/jetbrains/jet/lang/resolve/OverrideResolver", "generateOverridesAndDelegationInAClass"));
        }
        if (processed == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processed", "org/jetbrains/jet/lang/resolve/OverrideResolver", "generateOverridesAndDelegationInAClass"));
        }
        if (classesBeingAnalyzed == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "classesBeingAnalyzed", "org/jetbrains/jet/lang/resolve/OverrideResolver", "generateOverridesAndDelegationInAClass"));
        }
        if (!processed.add(classDescriptor)) {
            return;
        }
        for (JetType supertype : classDescriptor.getTypeConstructor().getSupertypes()) {
            ClassDescriptor superclass = (ClassDescriptor)supertype.getConstructor().getDeclarationDescriptor();
            if (!(superclass instanceof MutableClassDescriptor) || !classesBeingAnalyzed.contains(superclass)) continue;
            this.generateOverridesAndDelegationInAClass((MutableClassDescriptor)superclass, processed, classesBeingAnalyzed);
        }
        JetClassOrObject classOrObject = (JetClassOrObject)BindingContextUtils.classDescriptorToDeclaration(this.trace.getBindingContext(), classDescriptor);
        if (classOrObject != null) {
            DelegationResolver.generateDelegatesInAClass(classDescriptor, this.trace, classOrObject);
        }
        this.generateOverridesInAClass(classDescriptor);
    }

    private void generateOverridesInAClass(final @NotNull MutableClassDescriptor classDescriptor) {
        if (classDescriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "classDescriptor", "org/jetbrains/jet/lang/resolve/OverrideResolver", "generateOverridesInAClass"));
        }
        List<CallableMemberDescriptor> membersFromSupertypes = OverrideResolver.getCallableMembersFromSupertypes(classDescriptor);
        MultiMap<Name, CallableMemberDescriptor> membersFromSupertypesByName = OverrideResolver.groupDescriptorsByName(membersFromSupertypes);
        MultiMap membersFromCurrentByName = OverrideResolver.groupDescriptorsByName(classDescriptor.getDeclaredCallableMembers());
        LinkedHashSet<Name> memberNames = new LinkedHashSet<Name>();
        memberNames.addAll(membersFromSupertypesByName.keySet());
        memberNames.addAll(membersFromCurrentByName.keySet());
        for (Name memberName : memberNames) {
            Collection<CallableMemberDescriptor> fromSupertypes = membersFromSupertypesByName.get(memberName);
            Collection fromCurrent = membersFromCurrentByName.get(memberName);
            OverridingUtil.generateOverridesInFunctionGroup(memberName, fromSupertypes, fromCurrent, classDescriptor, new OverridingUtil.DescriptorSink(){

                @Override
                public void addToScope(@NotNull CallableMemberDescriptor fakeOverride) {
                    if (fakeOverride == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fakeOverride", "org/jetbrains/jet/lang/resolve/OverrideResolver$1", "addToScope"));
                    }
                    if (fakeOverride instanceof PropertyDescriptor) {
                        classDescriptor.getBuilder().addPropertyDescriptor((PropertyDescriptor)fakeOverride);
                    } else if (fakeOverride instanceof SimpleFunctionDescriptor) {
                        classDescriptor.getBuilder().addFunctionDescriptor((SimpleFunctionDescriptor)fakeOverride);
                    } else {
                        throw new IllegalStateException(fakeOverride.getClass().getName());
                    }
                }

                @Override
                public void conflict(@NotNull CallableMemberDescriptor fromSuper, @NotNull CallableMemberDescriptor fromCurrent) {
                    if (fromSuper == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fromSuper", "org/jetbrains/jet/lang/resolve/OverrideResolver$1", "conflict"));
                    }
                    if (fromCurrent == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fromCurrent", "org/jetbrains/jet/lang/resolve/OverrideResolver$1", "conflict"));
                    }
                    JetDeclaration declaration = (JetDeclaration)BindingContextUtils.descriptorToDeclaration(OverrideResolver.this.trace.getBindingContext(), fromCurrent);
                    OverrideResolver.this.trace.report(Errors.CONFLICTING_OVERLOADS.on(declaration, fromCurrent, fromCurrent.getContainingDeclaration().getName().asString()));
                }
            });
        }
        OverrideResolver.resolveUnknownVisibilities(classDescriptor.getAllCallableMembers(), this.trace);
    }

    public static void resolveUnknownVisibilities(@NotNull Collection<? extends CallableMemberDescriptor> descriptors, @NotNull BindingTrace trace) {
        if (descriptors == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptors", "org/jetbrains/jet/lang/resolve/OverrideResolver", "resolveUnknownVisibilities"));
        }
        if (trace == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "trace", "org/jetbrains/jet/lang/resolve/OverrideResolver", "resolveUnknownVisibilities"));
        }
        for (CallableMemberDescriptor callableMemberDescriptor : descriptors) {
            OverrideResolver.resolveUnknownVisibilityForMember(callableMemberDescriptor, trace);
        }
    }

    public static void resolveUnknownVisibilityForMember(@NotNull CallableMemberDescriptor descriptor, final @NotNull BindingTrace trace) {
        if (descriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "org/jetbrains/jet/lang/resolve/OverrideResolver", "resolveUnknownVisibilityForMember"));
        }
        if (trace == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "trace", "org/jetbrains/jet/lang/resolve/OverrideResolver", "resolveUnknownVisibilityForMember"));
        }
        OverridingUtil.resolveUnknownVisibilityForMember(descriptor, new OverridingUtil.NotInferredVisibilitySink(){

            @Override
            public void cannotInferVisibility(@NotNull CallableMemberDescriptor descriptor) {
                if (descriptor == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "org/jetbrains/jet/lang/resolve/OverrideResolver$2", "cannotInferVisibility"));
                }
                PsiElement element = BindingContextUtils.descriptorToDeclaration(trace.getBindingContext(), descriptor);
                if (element instanceof JetDeclaration) {
                    trace.report(Errors.CANNOT_INFER_VISIBILITY.on((JetDeclaration)element));
                }
            }
        });
    }

    private static <T extends DeclarationDescriptor> MultiMap<Name, T> groupDescriptorsByName(Collection<T> properties) {
        LinkedMultiMap<Name, DeclarationDescriptor> r = new LinkedMultiMap<Name, DeclarationDescriptor>();
        for (DeclarationDescriptor property2 : properties) {
            r.putValue(property2.getName(), property2);
        }
        return r;
    }

    private static List<CallableMemberDescriptor> getCallableMembersFromSupertypes(ClassDescriptor classDescriptor) {
        LinkedHashSet<CallableMemberDescriptor> r = Sets.newLinkedHashSet();
        for (JetType supertype : classDescriptor.getTypeConstructor().getSupertypes()) {
            r.addAll(OverrideResolver.getCallableMembersFromType(supertype.getMemberScope()));
        }
        return new ArrayList<CallableMemberDescriptor>(r);
    }

    private static List<CallableMemberDescriptor> getCallableMembersFromType(JetScope scope) {
        ArrayList<CallableMemberDescriptor> r = Lists.newArrayList();
        for (DeclarationDescriptor decl : scope.getAllDescriptors()) {
            if (!(decl instanceof PropertyDescriptor) && !(decl instanceof SimpleFunctionDescriptor)) continue;
            r.add((CallableMemberDescriptor)decl);
        }
        return r;
    }

    private void checkOverrides(@NotNull TopDownAnalysisContext c) {
        if (c == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "c", "org/jetbrains/jet/lang/resolve/OverrideResolver", "checkOverrides"));
        }
        for (Map.Entry<JetClassOrObject, ClassDescriptorWithResolutionScopes> entry : c.getClasses().entrySet()) {
            this.checkOverridesInAClass(c, (MutableClassDescriptor)entry.getValue(), entry.getKey());
        }
    }

    private void checkOverridesInAClass(@NotNull TopDownAnalysisContext c, @NotNull MutableClassDescriptor classDescriptor, @NotNull JetClassOrObject klass) {
        block11: {
            CallableMemberDescriptor memberDescriptor;
            if (c == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "c", "org/jetbrains/jet/lang/resolve/OverrideResolver", "checkOverridesInAClass"));
            }
            if (classDescriptor == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "classDescriptor", "org/jetbrains/jet/lang/resolve/OverrideResolver", "checkOverridesInAClass"));
            }
            if (klass == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "klass", "org/jetbrains/jet/lang/resolve/OverrideResolver", "checkOverridesInAClass"));
            }
            if (c.getTopDownAnalysisParameters().isAnalyzingBootstrapLibrary()) {
                return;
            }
            for (CallableMemberDescriptor member : classDescriptor.getDeclaredCallableMembers()) {
                this.checkOverrideForMember(member);
            }
            LinkedHashSet<CallableMemberDescriptor> abstractNoImpl = Sets.newLinkedHashSet();
            LinkedHashSet<CallableMemberDescriptor> manyImpl = Sets.newLinkedHashSet();
            OverrideResolver.collectMissingImplementations(classDescriptor, abstractNoImpl, manyImpl);
            PsiElement nameIdentifier = null;
            if (klass instanceof JetClass) {
                nameIdentifier = klass.getNameIdentifier();
            } else if (klass instanceof JetObjectDeclaration && (nameIdentifier = klass.getNameIdentifier()) == null) {
                nameIdentifier = ((JetObjectDeclaration)klass).getObjectKeyword();
            }
            if (nameIdentifier == null) {
                return;
            }
            Iterator i$ = manyImpl.iterator();
            if (i$.hasNext()) {
                memberDescriptor = (CallableMemberDescriptor)i$.next();
                this.trace.report(Errors.MANY_IMPL_MEMBER_NOT_IMPLEMENTED.on(nameIdentifier, klass, memberDescriptor));
            }
            if (classDescriptor.getModality() == Modality.ABSTRACT) {
                return;
            }
            i$ = abstractNoImpl.iterator();
            if (!i$.hasNext()) break block11;
            memberDescriptor = (CallableMemberDescriptor)i$.next();
            this.trace.report(Errors.ABSTRACT_MEMBER_NOT_IMPLEMENTED.on(nameIdentifier, klass, memberDescriptor));
        }
    }

    public static void collectMissingImplementations(MutableClassDescriptor classDescriptor, Set<CallableMemberDescriptor> abstractNoImpl, Set<CallableMemberDescriptor> manyImpl) {
        for (CallableMemberDescriptor descriptor : classDescriptor.getAllCallableMembers()) {
            OverrideResolver.collectMissingImplementations(descriptor, abstractNoImpl, manyImpl);
        }
    }

    public static void collectMissingImplementations(ClassDescriptor classDescriptor, Set<CallableMemberDescriptor> abstractNoImpl, Set<CallableMemberDescriptor> manyImpl) {
        Iterator<CallableMemberDescriptor> callableMembers = KotlinPackage.filterIsInstance(classDescriptor.getDefaultType().getMemberScope().getAllDescriptors().iterator(), CallableMemberDescriptor.class);
        while (callableMembers.hasNext()) {
            OverrideResolver.collectMissingImplementations(callableMembers.next(), abstractNoImpl, manyImpl);
        }
    }

    private static void collectMissingImplementations(@NotNull CallableMemberDescriptor descriptor, @NotNull Set<CallableMemberDescriptor> abstractNoImpl, @NotNull Set<CallableMemberDescriptor> manyImpl) {
        List<CallableMemberDescriptor> allOverriddenDeclarations;
        Set<CallableMemberDescriptor> allFilteredOverriddenDeclarations;
        if (descriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "org/jetbrains/jet/lang/resolve/OverrideResolver", "collectMissingImplementations"));
        }
        if (abstractNoImpl == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "abstractNoImpl", "org/jetbrains/jet/lang/resolve/OverrideResolver", "collectMissingImplementations"));
        }
        if (manyImpl == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "manyImpl", "org/jetbrains/jet/lang/resolve/OverrideResolver", "collectMissingImplementations"));
        }
        if (descriptor.getKind().isReal()) {
            return;
        }
        if (descriptor.getVisibility() == Visibilities.INVISIBLE_FAKE) {
            return;
        }
        Set<? extends CallableMemberDescriptor> directOverridden = descriptor.getOverriddenDescriptors();
        if (directOverridden.size() == 0) {
            throw new IllegalStateException("A 'fake override' must override something");
        }
        Map<CallableMemberDescriptor, Set<CallableMemberDescriptor>> overriddenDeclarationsByDirectParent = OverrideResolver.collectOverriddenDeclarations(directOverridden);
        Set<CallableMemberDescriptor> relevantDirectlyOverridden = OverrideResolver.getRelevantDirectlyOverridden(overriddenDeclarationsByDirectParent, allFilteredOverriddenDeclarations = OverridingUtil.filterOutOverridden(Sets.newLinkedHashSet(allOverriddenDeclarations = ContainerUtil.flatten(overriddenDeclarationsByDirectParent.values()))));
        int implCount = OverrideResolver.countImplementations(relevantDirectlyOverridden);
        if (implCount == 0) {
            OverrideResolver.collectNotSynthesizedDescriptorsByModality(allFilteredOverriddenDeclarations, abstractNoImpl, Modality.ABSTRACT);
        } else if (implCount > 1) {
            OverrideResolver.collectNotSynthesizedDescriptorsByModality(allFilteredOverriddenDeclarations, manyImpl, Modality.OPEN, Modality.FINAL);
        }
    }

    private static int countImplementations(@NotNull Set<CallableMemberDescriptor> relevantDirectlyOverridden) {
        if (relevantDirectlyOverridden == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "relevantDirectlyOverridden", "org/jetbrains/jet/lang/resolve/OverrideResolver", "countImplementations"));
        }
        int implCount = 0;
        for (CallableMemberDescriptor overriddenDescriptor : relevantDirectlyOverridden) {
            if (overriddenDescriptor.getModality() == Modality.ABSTRACT) continue;
            ++implCount;
        }
        return implCount;
    }

    private static void collectNotSynthesizedDescriptorsByModality(@NotNull Set<CallableMemberDescriptor> allOverriddenDeclarations, @NotNull Set<CallableMemberDescriptor> result2, Modality ... modalities) {
        if (allOverriddenDeclarations == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "allOverriddenDeclarations", "org/jetbrains/jet/lang/resolve/OverrideResolver", "collectNotSynthesizedDescriptorsByModality"));
        }
        if (result2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "org/jetbrains/jet/lang/resolve/OverrideResolver", "collectNotSynthesizedDescriptorsByModality"));
        }
        HashSet<Modality> modalitySet = Sets.newHashSet(modalities);
        for (CallableMemberDescriptor overridden : allOverriddenDeclarations) {
            if (!modalitySet.contains((Object)overridden.getModality()) || CallResolverUtil.isOrOverridesSynthesized(overridden)) continue;
            result2.add(overridden);
        }
    }

    @NotNull
    private static Set<CallableMemberDescriptor> getRelevantDirectlyOverridden(@NotNull Map<CallableMemberDescriptor, Set<CallableMemberDescriptor>> overriddenByParent, @NotNull Set<CallableMemberDescriptor> allFilteredOverriddenDeclarations) {
        if (overriddenByParent == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "overriddenByParent", "org/jetbrains/jet/lang/resolve/OverrideResolver", "getRelevantDirectlyOverridden"));
        }
        if (allFilteredOverriddenDeclarations == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "allFilteredOverriddenDeclarations", "org/jetbrains/jet/lang/resolve/OverrideResolver", "getRelevantDirectlyOverridden"));
        }
        LinkedHashMap<CallableMemberDescriptor, Set<CallableMemberDescriptor>> relevantOverriddenByParent = Maps.newLinkedHashMap(overriddenByParent);
        for (Map.Entry<CallableMemberDescriptor, Set<CallableMemberDescriptor>> entry : overriddenByParent.entrySet()) {
            CallableMemberDescriptor directlyOverridden = entry.getKey();
            Set<CallableMemberDescriptor> declarationSet = entry.getValue();
            if (OverrideResolver.isRelevant(declarationSet, relevantOverriddenByParent.values(), allFilteredOverriddenDeclarations)) continue;
            relevantOverriddenByParent.remove(directlyOverridden);
        }
        Set<CallableMemberDescriptor> set = relevantOverriddenByParent.keySet();
        if (set == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/OverrideResolver", "getRelevantDirectlyOverridden"));
        }
        return set;
    }

    private static boolean isRelevant(@NotNull Set<CallableMemberDescriptor> declarationSet, @NotNull Collection<Set<CallableMemberDescriptor>> allDeclarationSets, @NotNull Set<CallableMemberDescriptor> allFilteredOverriddenDeclarations) {
        if (declarationSet == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "declarationSet", "org/jetbrains/jet/lang/resolve/OverrideResolver", "isRelevant"));
        }
        if (allDeclarationSets == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "allDeclarationSets", "org/jetbrains/jet/lang/resolve/OverrideResolver", "isRelevant"));
        }
        if (allFilteredOverriddenDeclarations == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "allFilteredOverriddenDeclarations", "org/jetbrains/jet/lang/resolve/OverrideResolver", "isRelevant"));
        }
        for (Set<CallableMemberDescriptor> otherSet : allDeclarationSets) {
            if (otherSet == declarationSet) continue;
            if (otherSet.containsAll(declarationSet)) {
                return false;
            }
            if (!Collections.disjoint(allFilteredOverriddenDeclarations, declarationSet)) continue;
            return false;
        }
        return true;
    }

    @NotNull
    private static Map<CallableMemberDescriptor, Set<CallableMemberDescriptor>> collectOverriddenDeclarations(@NotNull Collection<? extends CallableMemberDescriptor> directOverriddenDescriptors) {
        if (directOverriddenDescriptors == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "directOverriddenDescriptors", "org/jetbrains/jet/lang/resolve/OverrideResolver", "collectOverriddenDeclarations"));
        }
        LinkedHashMap<CallableMemberDescriptor, Set<CallableMemberDescriptor>> overriddenDeclarationsByDirectParent = Maps.newLinkedHashMap();
        for (CallableMemberDescriptor callableMemberDescriptor : directOverriddenDescriptors) {
            Collection<CallableMemberDescriptor> overriddenDeclarations = OverridingUtil.getOverriddenDeclarations(callableMemberDescriptor);
            Set<CallableMemberDescriptor> filteredOverrides = OverridingUtil.filterOutOverridden(Sets.newLinkedHashSet(overriddenDeclarations));
            LinkedHashSet<CallableMemberDescriptor> overridden = Sets.newLinkedHashSet();
            for (CallableMemberDescriptor memberDescriptor : filteredOverrides) {
                overridden.add(memberDescriptor);
            }
            overriddenDeclarationsByDirectParent.put(callableMemberDescriptor, overridden);
        }
        LinkedHashMap<CallableMemberDescriptor, Set<CallableMemberDescriptor>> linkedHashMap = overriddenDeclarationsByDirectParent;
        if (linkedHashMap == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/OverrideResolver", "collectOverriddenDeclarations"));
        }
        return linkedHashMap;
    }

    private void checkOverrideForMember(final @NotNull CallableMemberDescriptor declared) {
        if (declared == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "declared", "org/jetbrains/jet/lang/resolve/OverrideResolver", "checkOverrideForMember"));
        }
        if (declared.getKind() == CallableMemberDescriptor.Kind.SYNTHESIZED) {
            if (declared.getName().asString().startsWith("component")) {
                this.checkOverrideForComponentFunction(declared);
            }
            return;
        }
        if (declared.getKind() != CallableMemberDescriptor.Kind.DECLARATION) {
            return;
        }
        final JetNamedDeclaration member = (JetNamedDeclaration)BindingContextUtils.descriptorToDeclaration(this.trace.getBindingContext(), declared);
        if (member == null) {
            throw new IllegalStateException("declared descriptor is not resolved to declaration: " + declared);
        }
        JetModifierList modifierList = member.getModifierList();
        final ASTNode overrideNode = modifierList != null ? modifierList.getModifierNode(JetTokens.OVERRIDE_KEYWORD) : null;
        Set<? extends CallableMemberDescriptor> overriddenDescriptors = declared.getOverriddenDescriptors();
        if (overrideNode != null) {
            this.checkOverridesForMemberMarkedOverride(declared, true, new CheckOverrideReportStrategy(){
                private boolean finalOverriddenError = false;
                private boolean typeMismatchError = false;
                private boolean kindMismatchError = false;

                @Override
                public void overridingFinalMember(@NotNull CallableMemberDescriptor overridden) {
                    if (overridden == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "overridden", "org/jetbrains/jet/lang/resolve/OverrideResolver$3", "overridingFinalMember"));
                    }
                    if (!this.finalOverriddenError) {
                        this.finalOverriddenError = true;
                        OverrideResolver.this.trace.report(Errors.OVERRIDING_FINAL_MEMBER.on(overrideNode.getPsi(), overridden, overridden.getContainingDeclaration()));
                    }
                }

                @Override
                public void returnTypeMismatchOnOverride(@NotNull CallableMemberDescriptor overridden) {
                    if (overridden == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "overridden", "org/jetbrains/jet/lang/resolve/OverrideResolver$3", "returnTypeMismatchOnOverride"));
                    }
                    if (!this.typeMismatchError) {
                        this.typeMismatchError = true;
                        OverrideResolver.this.trace.report(Errors.RETURN_TYPE_MISMATCH_ON_OVERRIDE.on(member, declared, overridden));
                    }
                }

                @Override
                public void propertyTypeMismatchOnOverride(@NotNull CallableMemberDescriptor overridden) {
                    if (overridden == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "overridden", "org/jetbrains/jet/lang/resolve/OverrideResolver$3", "propertyTypeMismatchOnOverride"));
                    }
                    if (!this.typeMismatchError) {
                        this.typeMismatchError = true;
                        OverrideResolver.this.trace.report(Errors.PROPERTY_TYPE_MISMATCH_ON_OVERRIDE.on(member, declared, overridden));
                    }
                }

                @Override
                public void varOverriddenByVal(@NotNull CallableMemberDescriptor overridden) {
                    if (overridden == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "overridden", "org/jetbrains/jet/lang/resolve/OverrideResolver$3", "varOverriddenByVal"));
                    }
                    if (!this.kindMismatchError) {
                        this.kindMismatchError = true;
                        OverrideResolver.this.trace.report(Errors.VAR_OVERRIDDEN_BY_VAL.on((JetProperty)member, (PropertyDescriptor)declared, (PropertyDescriptor)overridden));
                    }
                }

                @Override
                public void cannotOverrideInvisibleMember(@NotNull CallableMemberDescriptor invisibleOverridden) {
                    if (invisibleOverridden == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "invisibleOverridden", "org/jetbrains/jet/lang/resolve/OverrideResolver$3", "cannotOverrideInvisibleMember"));
                    }
                    OverrideResolver.this.trace.report(Errors.CANNOT_OVERRIDE_INVISIBLE_MEMBER.on(member, declared, invisibleOverridden, invisibleOverridden.getContainingDeclaration()));
                }

                @Override
                public void nothingToOverride() {
                    OverrideResolver.this.trace.report(Errors.NOTHING_TO_OVERRIDE.on(member, declared));
                }
            });
        } else if (!overriddenDescriptors.isEmpty()) {
            CallableMemberDescriptor overridden = overriddenDescriptors.iterator().next();
            this.trace.report(Errors.VIRTUAL_MEMBER_HIDDEN.on(member, declared, overridden, overridden.getContainingDeclaration()));
        }
    }

    private void checkOverridesForMemberMarkedOverride(@NotNull CallableMemberDescriptor declared, boolean checkIfOverridesNothing, @NotNull CheckOverrideReportStrategy reportError) {
        if (declared == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "declared", "org/jetbrains/jet/lang/resolve/OverrideResolver", "checkOverridesForMemberMarkedOverride"));
        }
        if (reportError == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "reportError", "org/jetbrains/jet/lang/resolve/OverrideResolver", "checkOverridesForMemberMarkedOverride"));
        }
        Set<? extends CallableMemberDescriptor> overriddenDescriptors = declared.getOverriddenDescriptors();
        for (CallableMemberDescriptor callableMemberDescriptor : overriddenDescriptors) {
            if (callableMemberDescriptor == null) continue;
            if (!callableMemberDescriptor.getModality().isOverridable()) {
                reportError.overridingFinalMember(callableMemberDescriptor);
            }
            if (declared instanceof PropertyDescriptor && !OverridingUtil.isPropertyTypeOkForOverride(JetTypeChecker.INSTANCE, (PropertyDescriptor)callableMemberDescriptor, (PropertyDescriptor)declared)) {
                reportError.propertyTypeMismatchOnOverride(callableMemberDescriptor);
            } else if (!OverridingUtil.isReturnTypeOkForOverride(JetTypeChecker.INSTANCE, callableMemberDescriptor, declared)) {
                reportError.returnTypeMismatchOnOverride(callableMemberDescriptor);
            }
            if (!this.checkPropertyKind(callableMemberDescriptor, true) || !this.checkPropertyKind(declared, false)) continue;
            reportError.varOverriddenByVal(callableMemberDescriptor);
        }
        if (checkIfOverridesNothing && overriddenDescriptors.isEmpty()) {
            DeclarationDescriptor containingDeclaration = declared.getContainingDeclaration();
            assert (containingDeclaration instanceof ClassDescriptor) : "Overrides may only be resolved in a class, but " + declared + " comes from " + containingDeclaration;
            ClassDescriptor classDescriptor = (ClassDescriptor)containingDeclaration;
            CallableMemberDescriptor invisibleOverriddenDescriptor = this.findInvisibleOverriddenDescriptor(declared, classDescriptor);
            if (invisibleOverriddenDescriptor != null) {
                reportError.cannotOverrideInvisibleMember(invisibleOverriddenDescriptor);
            } else {
                reportError.nothingToOverride();
            }
        }
    }

    private void checkOverrideForComponentFunction(final @NotNull CallableMemberDescriptor componentFunction) {
        if (componentFunction == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "componentFunction", "org/jetbrains/jet/lang/resolve/OverrideResolver", "checkOverrideForComponentFunction"));
        }
        final JetAnnotationEntry dataAnnotation = this.findDataAnnotationForDataClass(componentFunction.getContainingDeclaration());
        this.checkOverridesForMemberMarkedOverride(componentFunction, false, new CheckOverrideReportStrategy(){
            private boolean overrideConflict = false;

            @Override
            public void overridingFinalMember(@NotNull CallableMemberDescriptor overridden) {
                if (overridden == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "overridden", "org/jetbrains/jet/lang/resolve/OverrideResolver$4", "overridingFinalMember"));
                }
                if (!this.overrideConflict) {
                    this.overrideConflict = true;
                    OverrideResolver.this.trace.report(Errors.DATA_CLASS_OVERRIDE_CONFLICT.on(dataAnnotation, componentFunction, overridden.getContainingDeclaration()));
                }
            }

            @Override
            public void returnTypeMismatchOnOverride(@NotNull CallableMemberDescriptor overridden) {
                if (overridden == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "overridden", "org/jetbrains/jet/lang/resolve/OverrideResolver$4", "returnTypeMismatchOnOverride"));
                }
                if (!this.overrideConflict) {
                    this.overrideConflict = true;
                    OverrideResolver.this.trace.report(Errors.DATA_CLASS_OVERRIDE_CONFLICT.on(dataAnnotation, componentFunction, overridden.getContainingDeclaration()));
                }
            }

            @Override
            public void propertyTypeMismatchOnOverride(@NotNull CallableMemberDescriptor overridden) {
                if (overridden == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "overridden", "org/jetbrains/jet/lang/resolve/OverrideResolver$4", "propertyTypeMismatchOnOverride"));
                }
                throw new IllegalStateException("Component functions are not properties");
            }

            @Override
            public void varOverriddenByVal(@NotNull CallableMemberDescriptor overridden) {
                if (overridden == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "overridden", "org/jetbrains/jet/lang/resolve/OverrideResolver$4", "varOverriddenByVal"));
                }
                throw new IllegalStateException("Component functions are not properties");
            }

            @Override
            public void cannotOverrideInvisibleMember(@NotNull CallableMemberDescriptor invisibleOverridden) {
                if (invisibleOverridden == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "invisibleOverridden", "org/jetbrains/jet/lang/resolve/OverrideResolver$4", "cannotOverrideInvisibleMember"));
                }
                throw new IllegalStateException("CANNOT_OVERRIDE_INVISIBLE_MEMBER should be reported on the corresponding property");
            }

            @Override
            public void nothingToOverride() {
                throw new IllegalStateException("Component functions are OK to override nothing");
            }
        });
    }

    @NotNull
    private JetAnnotationEntry findDataAnnotationForDataClass(@NotNull DeclarationDescriptor dataClass) {
        if (dataClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataClass", "org/jetbrains/jet/lang/resolve/OverrideResolver", "findDataAnnotationForDataClass"));
        }
        ClassDescriptor stdDataClassAnnotation = KotlinBuiltIns.getInstance().getDataClassAnnotation();
        AnnotationDescriptor annotation = dataClass.getAnnotations().findAnnotation(DescriptorUtils.getFqNameSafe(stdDataClassAnnotation));
        if (annotation == null) {
            throw new IllegalStateException("No data annotation is found for data class " + dataClass);
        }
        JetAnnotationEntry jetAnnotationEntry = BindingContextUtils.getNotNull(this.trace.getBindingContext(), BindingContext.ANNOTATION_DESCRIPTOR_TO_PSI_ELEMENT, annotation);
        if (jetAnnotationEntry == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/OverrideResolver", "findDataAnnotationForDataClass"));
        }
        return jetAnnotationEntry;
    }

    private CallableMemberDescriptor findInvisibleOverriddenDescriptor(CallableMemberDescriptor declared, ClassDescriptor declaringClass) {
        CallableMemberDescriptor invisibleOverride = null;
        block0: for (JetType supertype : declaringClass.getTypeConstructor().getSupertypes()) {
            LinkedHashSet<CallableDescriptor> all = Sets.newLinkedHashSet();
            all.addAll(supertype.getMemberScope().getFunctions(declared.getName()));
            all.addAll(supertype.getMemberScope().getProperties(declared.getName()));
            for (CallableMemberDescriptor callableMemberDescriptor : all) {
                if (OverridingUtil.isOverridableBy(callableMemberDescriptor, declared).getResult() != OverridingUtil.OverrideCompatibilityInfo.Result.OVERRIDABLE) continue;
                invisibleOverride = callableMemberDescriptor;
                if (!Visibilities.isVisible(callableMemberDescriptor, declared)) break block0;
                throw new IllegalStateException("Descriptor " + callableMemberDescriptor + " is overridable by " + declared + " and visible but does not appear in its getOverriddenDescriptors()");
            }
        }
        return invisibleOverride;
    }

    private void checkParameterOverridesForAllClasses(@NotNull TopDownAnalysisContext c) {
        if (c == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "c", "org/jetbrains/jet/lang/resolve/OverrideResolver", "checkParameterOverridesForAllClasses"));
        }
        for (ClassDescriptorWithResolutionScopes classDescriptor : c.getClasses().values()) {
            for (DeclarationDescriptor member : classDescriptor.getDefaultType().getMemberScope().getAllDescriptors()) {
                if (!(member instanceof CallableMemberDescriptor)) continue;
                this.checkOverridesForParameters((CallableMemberDescriptor)member);
            }
        }
    }

    private void checkOverridesForParameters(@NotNull CallableMemberDescriptor declared) {
        JetModifierListOwner declaration;
        boolean noDeclaration;
        if (declared == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "declared", "org/jetbrains/jet/lang/resolve/OverrideResolver", "checkOverridesForParameters"));
        }
        boolean bl = noDeclaration = declared.getKind() != CallableMemberDescriptor.Kind.DECLARATION;
        if (!noDeclaration && !(declaration = (JetModifierListOwner)BindingContextUtils.descriptorToDeclaration(this.trace.getBindingContext(), declared)).hasModifier(JetTokens.OVERRIDE_KEYWORD)) {
            return;
        }
        block0: for (ValueParameterDescriptor parameterFromSubclass : declared.getValueParameters()) {
            JetClassOrObject classElement;
            JetParameter parameter = noDeclaration ? null : (JetParameter)BindingContextUtils.descriptorToDeclaration(this.trace.getBindingContext(), parameterFromSubclass);
            JetClassOrObject jetClassOrObject = classElement = noDeclaration ? (JetClassOrObject)BindingContextUtils.descriptorToDeclaration(this.trace.getBindingContext(), declared.getContainingDeclaration()) : null;
            if (parameterFromSubclass.declaresDefaultValue() && !noDeclaration) {
                this.trace.report(Errors.DEFAULT_VALUE_NOT_ALLOWED_IN_OVERRIDE.on(parameter));
            }
            boolean superWithDefault = false;
            for (ValueParameterDescriptor valueParameterDescriptor : parameterFromSubclass.getOverriddenDescriptors()) {
                if (valueParameterDescriptor.declaresDefaultValue()) {
                    if (!superWithDefault) {
                        superWithDefault = true;
                    } else {
                        if (noDeclaration) {
                            this.trace.report(Errors.MULTIPLE_DEFAULTS_INHERITED_FROM_SUPERTYPES_WHEN_NO_EXPLICIT_OVERRIDE.on(classElement, parameterFromSubclass));
                            continue block0;
                        }
                        this.trace.report(Errors.MULTIPLE_DEFAULTS_INHERITED_FROM_SUPERTYPES.on(parameter, parameterFromSubclass));
                        continue block0;
                    }
                }
                if (valueParameterDescriptor.getName().equals(parameterFromSubclass.getName())) continue;
                if (noDeclaration) {
                    this.trace.report(Errors.DIFFERENT_NAMES_FOR_THE_SAME_PARAMETER_IN_SUPERTYPES.on(classElement, declared.getOverriddenDescriptors(), valueParameterDescriptor.getIndex() + 1));
                    continue;
                }
                this.trace.report(Errors.PARAMETER_NAME_CHANGED_ON_OVERRIDE.on(parameter, (ClassDescriptor)valueParameterDescriptor.getContainingDeclaration().getContainingDeclaration(), valueParameterDescriptor));
            }
        }
    }

    private boolean checkPropertyKind(CallableMemberDescriptor descriptor, boolean isVar) {
        if (descriptor instanceof PropertyDescriptor) {
            PropertyDescriptor propertyDescriptor = (PropertyDescriptor)descriptor;
            return propertyDescriptor.isVar() == isVar;
        }
        return false;
    }

    private void checkVisibility(@NotNull TopDownAnalysisContext c) {
        if (c == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "c", "org/jetbrains/jet/lang/resolve/OverrideResolver", "checkVisibility"));
        }
        for (Map.Entry<JetDeclaration, CallableMemberDescriptor> entry : c.getMembers().entrySet()) {
            this.checkVisibilityForMember(entry.getKey(), entry.getValue());
        }
    }

    private void checkVisibilityForMember(@NotNull JetDeclaration declaration, @NotNull CallableMemberDescriptor memberDescriptor) {
        if (declaration == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "declaration", "org/jetbrains/jet/lang/resolve/OverrideResolver", "checkVisibilityForMember"));
        }
        if (memberDescriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "memberDescriptor", "org/jetbrains/jet/lang/resolve/OverrideResolver", "checkVisibilityForMember"));
        }
        Visibility visibility = memberDescriptor.getVisibility();
        for (CallableMemberDescriptor callableMemberDescriptor : memberDescriptor.getOverriddenDescriptors()) {
            Integer compare = Visibilities.compare(visibility, callableMemberDescriptor.getVisibility());
            if (compare == null) {
                this.trace.report(Errors.CANNOT_CHANGE_ACCESS_PRIVILEGE.on(declaration, callableMemberDescriptor.getVisibility(), callableMemberDescriptor, callableMemberDescriptor.getContainingDeclaration()));
                return;
            }
            if (compare >= 0) continue;
            this.trace.report(Errors.CANNOT_WEAKEN_ACCESS_PRIVILEGE.on(declaration, callableMemberDescriptor.getVisibility(), callableMemberDescriptor, callableMemberDescriptor.getContainingDeclaration()));
            return;
        }
    }

    private static interface CheckOverrideReportStrategy {
        public void overridingFinalMember(@NotNull CallableMemberDescriptor var1);

        public void returnTypeMismatchOnOverride(@NotNull CallableMemberDescriptor var1);

        public void propertyTypeMismatchOnOverride(@NotNull CallableMemberDescriptor var1);

        public void varOverriddenByVal(@NotNull CallableMemberDescriptor var1);

        public void cannotOverrideInvisibleMember(@NotNull CallableMemberDescriptor var1);

        public void nothingToOverride();
    }
}

