/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.lang.resolve.scopes.receivers;

import org.jetbrains.annotations.NotNull;
import org.jetbrains.jet.lang.psi.JetExpression;
import org.jetbrains.jet.lang.resolve.scopes.receivers.AbstractReceiverValue;
import org.jetbrains.jet.lang.resolve.scopes.receivers.ReceiverValue;
import org.jetbrains.jet.lang.types.JetType;

public class ExpressionReceiver
extends AbstractReceiverValue
implements ReceiverValue {
    private final JetExpression expression;

    public ExpressionReceiver(@NotNull JetExpression expression, @NotNull JetType type) {
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/jet/lang/resolve/scopes/receivers/ExpressionReceiver", "<init>"));
        }
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "org/jetbrains/jet/lang/resolve/scopes/receivers/ExpressionReceiver", "<init>"));
        }
        super(type);
        this.expression = expression;
    }

    @NotNull
    public JetExpression getExpression() {
        JetExpression jetExpression = this.expression;
        if (jetExpression == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/scopes/receivers/ExpressionReceiver", "getExpression"));
        }
        return jetExpression;
    }

    public String toString() {
        return this.getType() + " {" + this.expression + ": " + this.expression.getText() + "}";
    }
}

