/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.k2js.translate.intrinsic.functions.patterns;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jet.lang.descriptors.CallableDescriptor;
import org.jetbrains.jet.lang.descriptors.CallableMemberDescriptor;
import org.jetbrains.jet.lang.descriptors.ClassDescriptor;
import org.jetbrains.jet.lang.descriptors.DeclarationDescriptor;
import org.jetbrains.jet.lang.descriptors.FunctionDescriptor;
import org.jetbrains.jet.lang.descriptors.PackageFragmentDescriptor;
import org.jetbrains.jet.lang.resolve.DescriptorUtils;
import org.jetbrains.jet.lang.resolve.OverridingUtil;
import org.jetbrains.jet.lang.resolve.name.Name;
import org.jetbrains.k2js.translate.context.Namer;
import org.jetbrains.k2js.translate.intrinsic.functions.patterns.DescriptorPredicate;
import org.jetbrains.k2js.translate.intrinsic.functions.patterns.NamePredicate;

public final class PatternBuilder {
    @NotNull
    private static final NamePredicate KOTLIN_NAME_PREDICATE = new NamePredicate("kotlin");
    @NotNull
    private static final Name KOTLIN_NAME = Name.identifier(Namer.KOTLIN_LOWER_NAME);

    private PatternBuilder() {
    }

    @NotNull
    public static DescriptorPredicate pattern(@NotNull NamePredicate checker, @NotNull String stringWithPattern) {
        if (checker == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "checker", "org/jetbrains/k2js/translate/intrinsic/functions/patterns/PatternBuilder", "pattern"));
        }
        if (stringWithPattern == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "stringWithPattern", "org/jetbrains/k2js/translate/intrinsic/functions/patterns/PatternBuilder", "pattern"));
        }
        ArrayList<NamePredicate> checkers = Lists.newArrayList(checker);
        checkers.addAll(PatternBuilder.parseStringAsCheckerList(stringWithPattern));
        DescriptorPredicate descriptorPredicate = PatternBuilder.pattern(checkers);
        if (descriptorPredicate == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/k2js/translate/intrinsic/functions/patterns/PatternBuilder", "pattern"));
        }
        return descriptorPredicate;
    }

    @NotNull
    public static DescriptorPredicate pattern(@NotNull String stringWithPattern, @NotNull NamePredicate checker) {
        if (stringWithPattern == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "stringWithPattern", "org/jetbrains/k2js/translate/intrinsic/functions/patterns/PatternBuilder", "pattern"));
        }
        if (checker == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "checker", "org/jetbrains/k2js/translate/intrinsic/functions/patterns/PatternBuilder", "pattern"));
        }
        ArrayList<NamePredicate> checkers = Lists.newArrayList(PatternBuilder.parseStringAsCheckerList(stringWithPattern));
        checkers.add(checker);
        DescriptorPredicate descriptorPredicate = PatternBuilder.pattern(checkers);
        if (descriptorPredicate == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/k2js/translate/intrinsic/functions/patterns/PatternBuilder", "pattern"));
        }
        return descriptorPredicate;
    }

    @NotNull
    public static DescriptorPredicate pattern(@NotNull String string) {
        if (string == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "string", "org/jetbrains/k2js/translate/intrinsic/functions/patterns/PatternBuilder", "pattern"));
        }
        List<NamePredicate> checkers = PatternBuilder.parseStringAsCheckerList(string);
        DescriptorPredicate descriptorPredicate = PatternBuilder.pattern(checkers);
        if (descriptorPredicate == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/k2js/translate/intrinsic/functions/patterns/PatternBuilder", "pattern"));
        }
        return descriptorPredicate;
    }

    @NotNull
    private static List<NamePredicate> parseStringAsCheckerList(@NotNull String stringWithPattern) {
        if (stringWithPattern == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "stringWithPattern", "org/jetbrains/k2js/translate/intrinsic/functions/patterns/PatternBuilder", "parseStringAsCheckerList"));
        }
        String[] subPatterns = stringWithPattern.split("\\.");
        ArrayList<NamePredicate> checkers = Lists.newArrayList();
        for (String subPattern : subPatterns) {
            String[] validNames = subPattern.split("\\|");
            checkers.add(new NamePredicate(validNames));
        }
        ArrayList<NamePredicate> arrayList = checkers;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/k2js/translate/intrinsic/functions/patterns/PatternBuilder", "parseStringAsCheckerList"));
        }
        return arrayList;
    }

    @NotNull
    private static DescriptorPredicate pattern(@NotNull List<NamePredicate> checkers) {
        if (checkers == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "checkers", "org/jetbrains/k2js/translate/intrinsic/functions/patterns/PatternBuilder", "pattern"));
        }
        assert (!checkers.isEmpty());
        final ArrayList<NamePredicate> checkersWithPrefixChecker = Lists.newArrayList();
        if (!checkers.get(0).apply(KOTLIN_NAME)) {
            checkersWithPrefixChecker.add(KOTLIN_NAME_PREDICATE);
        }
        checkersWithPrefixChecker.addAll(checkers);
        assert (checkersWithPrefixChecker.size() > 1);
        DescriptorPredicate descriptorPredicate = new DescriptorPredicate(){

            @Override
            public boolean apply(@NotNull FunctionDescriptor descriptor) {
                if (descriptor == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "org/jetbrains/k2js/translate/intrinsic/functions/patterns/PatternBuilder$1", "apply"));
                }
                try {
                    return this.doApply(descriptor);
                }
                catch (IllegalArgumentException e) {
                    return false;
                }
            }

            private boolean doApply(@NotNull FunctionDescriptor descriptor) {
                if (descriptor == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "org/jetbrains/k2js/translate/intrinsic/functions/patterns/PatternBuilder$1", "doApply"));
                }
                List<Name> nameParts = DescriptorUtils.getFqName(descriptor).pathSegments();
                if (nameParts.size() != checkersWithPrefixChecker.size()) {
                    return false;
                }
                return this.allNamePartsValid(nameParts);
            }

            private boolean allNamePartsValid(@NotNull List<Name> nameParts) {
                if (nameParts == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "nameParts", "org/jetbrains/k2js/translate/intrinsic/functions/patterns/PatternBuilder$1", "allNamePartsValid"));
                }
                for (int i = 0; i < nameParts.size(); ++i) {
                    Name namePart = nameParts.get(i);
                    NamePredicate correspondingPredicate = (NamePredicate)checkersWithPrefixChecker.get(i);
                    if (correspondingPredicate.apply(namePart)) continue;
                    return false;
                }
                return true;
            }
        };
        if (descriptorPredicate == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/k2js/translate/intrinsic/functions/patterns/PatternBuilder", "pattern"));
        }
        return descriptorPredicate;
    }

    @NotNull
    public static DescriptorPredicate pattern(NamePredicate ... checkers) {
        if (checkers == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "checkers", "org/jetbrains/k2js/translate/intrinsic/functions/patterns/PatternBuilder", "pattern"));
        }
        DescriptorPredicate descriptorPredicate = PatternBuilder.pattern(Arrays.asList(checkers));
        if (descriptorPredicate == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/k2js/translate/intrinsic/functions/patterns/PatternBuilder", "pattern"));
        }
        return descriptorPredicate;
    }

    @NotNull
    public static DescriptorPredicateImpl pattern(String ... names) {
        if (names == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "names", "org/jetbrains/k2js/translate/intrinsic/functions/patterns/PatternBuilder", "pattern"));
        }
        DescriptorPredicateImpl descriptorPredicateImpl = new DescriptorPredicateImpl(names);
        if (descriptorPredicateImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/k2js/translate/intrinsic/functions/patterns/PatternBuilder", "pattern"));
        }
        return descriptorPredicateImpl;
    }

    public static class DescriptorPredicateImpl
    implements DescriptorPredicate {
        private final String[] names;
        private boolean receiverParameterExists;
        private boolean checkOverridden;

        public DescriptorPredicateImpl(String ... names) {
            this.names = names;
        }

        public DescriptorPredicateImpl receiverExists() {
            this.receiverParameterExists = true;
            return this;
        }

        public DescriptorPredicateImpl checkOverridden() {
            this.checkOverridden = true;
            return this;
        }

        private boolean matches(@NotNull CallableDescriptor callable2) {
            if (callable2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "callable", "org/jetbrains/k2js/translate/intrinsic/functions/patterns/PatternBuilder$DescriptorPredicateImpl", "matches"));
            }
            DeclarationDescriptor descriptor = callable2;
            int nameIndex = this.names.length - 1;
            do {
                if (nameIndex == -1) {
                    return false;
                }
                if (!descriptor.getName().asString().equals(this.names[nameIndex])) {
                    return false;
                }
                --nameIndex;
            } while (!((descriptor = descriptor.getContainingDeclaration()) instanceof PackageFragmentDescriptor));
            return nameIndex == 0 && this.names[0].equals(((PackageFragmentDescriptor)descriptor).getFqName().asString());
        }

        @Override
        public boolean apply(@NotNull FunctionDescriptor functionDescriptor) {
            if (functionDescriptor == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "functionDescriptor", "org/jetbrains/k2js/translate/intrinsic/functions/patterns/PatternBuilder$DescriptorPredicateImpl", "apply"));
            }
            if (functionDescriptor.getReceiverParameter() == null == this.receiverParameterExists) {
                return false;
            }
            if (!(functionDescriptor.getContainingDeclaration() instanceof ClassDescriptor)) {
                return this.matches(functionDescriptor);
            }
            for (CallableMemberDescriptor real : OverridingUtil.getOverriddenDeclarations(functionDescriptor)) {
                if (!this.matches(real)) continue;
                return true;
            }
            if (this.checkOverridden) {
                for (CallableDescriptor overridden : OverridingUtil.getAllOverriddenDescriptors(functionDescriptor)) {
                    if (!this.matches(overridden)) continue;
                    return true;
                }
            }
            return false;
        }
    }
}

