/*
 * Copyright 2010-2014 JetBrains s.r.o.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.jetbrains.jet.lang.resolve.kotlin.incremental

import java.io.File
import java.util.ServiceLoader

public trait IncrementalCacheProvider {
    public fun getIncrementalCache(baseDir: File): IncrementalCache

    public class object {
        public fun getInstance(): IncrementalCacheProvider? {
            val serviceLoader = ServiceLoader.load(javaClass<IncrementalCacheProvider>(), javaClass<IncrementalCacheProvider>().getClassLoader())
            val implementations = serviceLoader.toList()
            if (implementations.size > 1) {
                throw IllegalStateException("More than one IncrementalCacheProvider: " + implementations)
            }
            return implementations.firstOrNull()
        }
    }
}